/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.sounds;

import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;

public class SoundManager {
    private final Deque<TimedSound> soundQueue = new ArrayDeque<TimedSound>();
    private final ClientLevel level;

    public SoundManager(ClientLevel level) {
        this.level = level;
    }

    public void tick() {
        if (this.soundQueue.isEmpty()) {
            return;
        }
        TimedSound instance = this.soundQueue.peek();
        if (instance.timeout <= 0) {
            this.level.m_5594_((Player)Minecraft.m_91087_().f_91074_, instance.pos, instance.soundEvent, instance.source, instance.volume, instance.pitch);
            instance.timeout = instance.length;
            --instance.repetitions;
            if (instance.repetitions < 0) {
                this.soundQueue.pop();
            }
        } else {
            --instance.timeout;
        }
    }

    public void addToQueue(SoundEvent soundEvent, SoundSource source, int repetitions, int length, BlockPos pos, float volume, float pitch) {
        this.soundQueue.add(new TimedSound(soundEvent, source, repetitions, length, pos, volume, pitch));
    }

    public static class TimedSound {
        final SoundEvent soundEvent;
        final SoundSource source;
        final int length;
        final BlockPos pos;
        final float volume;
        final float pitch;
        int repetitions;
        int timeout = 0;

        public TimedSound(SoundEvent soundEvent, SoundSource source, int repetitions, int length, BlockPos pos, float volume, float pitch) {
            this.soundEvent = soundEvent;
            this.source = source;
            this.repetitions = repetitions;
            this.length = length;
            this.pos = pos;
            this.volume = volume;
            this.pitch = pitch;
        }
    }
}

