/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity.citizen.happiness;

import com.minecolonies.api.entity.citizen.happiness.StaticHappinessModifier;
import java.util.function.DoubleSupplier;
import net.minecraft.nbt.CompoundTag;

public class ExpirationBasedHappinessModifier
extends StaticHappinessModifier {
    private int days = 0;
    private final int period;
    private boolean inverted;

    public ExpirationBasedHappinessModifier(String id, double weight, DoubleSupplier supplier, int period) {
        super(id, weight, supplier);
        this.period = period;
    }

    public ExpirationBasedHappinessModifier(String id, double weight, DoubleSupplier supplier, int period, boolean inverted) {
        this(id, weight, supplier, period);
        this.inverted = inverted;
    }

    @Override
    public double getFactor() {
        if (this.inverted) {
            if (this.days > 0) {
                return 1.0;
            }
            return super.getFactor();
        }
        if (this.days > 0) {
            return super.getFactor();
        }
        return 1.0;
    }

    @Override
    public void reset() {
        this.days = this.period;
    }

    @Override
    public void dayEnd() {
        super.dayEnd();
        if (this.days > 0) {
            --this.days;
        }
    }

    @Override
    public int getDays() {
        return this.days;
    }

    @Override
    public void read(CompoundTag compoundNBT) {
        super.read(compoundNBT);
        this.days = compoundNBT.m_128451_("day");
    }

    @Override
    public void write(CompoundTag compoundNBT) {
        super.write(compoundNBT);
        compoundNBT.m_128405_("day", this.days);
    }
}

