/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.blocks.decorative;

import com.minecolonies.api.blocks.AbstractBlockMinecoloniesFalling;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractBlockMinecoloniesConstructionTape<B extends AbstractBlockMinecoloniesConstructionTape<B>>
extends AbstractBlockMinecoloniesFalling<B>
implements SimpleWaterloggedBlock {
    public static final BooleanProperty NORTH = PipeBlock.f_55148_;
    public static final BooleanProperty EAST = PipeBlock.f_55149_;
    public static final BooleanProperty SOUTH = PipeBlock.f_55150_;
    public static final BooleanProperty WEST = PipeBlock.f_55151_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected VoxelShape[] shapes = new VoxelShape[0];
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty CORNER = BooleanProperty.m_61465_((String)"corner");

    public AbstractBlockMinecoloniesConstructionTape(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.shapes[this.getIndex(state)];
    }

    private static int getMask(Direction facing) {
        return 1 << facing.m_122416_();
    }

    protected int getIndex(BlockState state) {
        int i = 0;
        if (((Boolean)state.m_61143_((Property)NORTH)).booleanValue()) {
            i |= AbstractBlockMinecoloniesConstructionTape.getMask(Direction.NORTH);
        }
        if (((Boolean)state.m_61143_((Property)EAST)).booleanValue()) {
            i |= AbstractBlockMinecoloniesConstructionTape.getMask(Direction.EAST);
        }
        if (((Boolean)state.m_61143_((Property)SOUTH)).booleanValue()) {
            i |= AbstractBlockMinecoloniesConstructionTape.getMask(Direction.SOUTH);
        }
        if (((Boolean)state.m_61143_((Property)WEST)).booleanValue()) {
            i |= AbstractBlockMinecoloniesConstructionTape.getMask(Direction.WEST);
        }
        return i;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected VoxelShape[] makeShapes(float nodeWidth, float limbWidth, float nodeHeight, float limbBase, float limbTop) {
        float nodeStart = 8.0f - nodeWidth;
        float nodeEnd = 8.0f + nodeWidth;
        float limbStart = 8.0f - limbWidth;
        float limbEnd = 8.0f + limbWidth;
        VoxelShape node = Block.m_49796_((double)nodeStart, (double)0.0, (double)nodeStart, (double)nodeEnd, (double)nodeHeight, (double)nodeEnd);
        VoxelShape north = Block.m_49796_((double)limbStart, (double)limbBase, (double)0.0, (double)limbEnd, (double)limbTop, (double)limbEnd);
        VoxelShape south = Block.m_49796_((double)limbStart, (double)limbBase, (double)limbStart, (double)limbEnd, (double)limbTop, (double)16.0);
        VoxelShape west = Block.m_49796_((double)0.0, (double)limbBase, (double)limbStart, (double)limbEnd, (double)limbTop, (double)limbEnd);
        VoxelShape east = Block.m_49796_((double)limbStart, (double)limbBase, (double)limbStart, (double)16.0, (double)limbTop, (double)limbEnd);
        VoxelShape cornernw = Shapes.m_83110_((VoxelShape)north, (VoxelShape)east);
        VoxelShape cornerse = Shapes.m_83110_((VoxelShape)south, (VoxelShape)west);
        VoxelShape[] avoxelshape = new VoxelShape[]{Shapes.m_83040_(), south, west, cornerse, north, Shapes.m_83110_((VoxelShape)south, (VoxelShape)north), Shapes.m_83110_((VoxelShape)west, (VoxelShape)north), Shapes.m_83110_((VoxelShape)cornerse, (VoxelShape)north), east, Shapes.m_83110_((VoxelShape)south, (VoxelShape)east), Shapes.m_83110_((VoxelShape)west, (VoxelShape)east), Shapes.m_83110_((VoxelShape)cornerse, (VoxelShape)east), cornernw, Shapes.m_83110_((VoxelShape)south, (VoxelShape)cornernw), Shapes.m_83110_((VoxelShape)west, (VoxelShape)cornernw), Shapes.m_83110_((VoxelShape)cornerse, (VoxelShape)cornernw)};
        for (int i = 0; i < 16; ++i) {
            avoxelshape[i] = Shapes.m_83110_((VoxelShape)node, (VoxelShape)avoxelshape[i]);
        }
        return avoxelshape;
    }
}

