/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.chunkloaders.ChunkLoaders;
import com.supermartijn642.chunkloaders.capability.ChunkLoadingCapability;
import com.supermartijn642.chunkloaders.packet.PacketToggleChunk;
import com.supermartijn642.chunkloaders.screen.ChunkImage;
import com.supermartijn642.chunkloaders.screen.PlayerRenderer;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.BaseWidget;
import com.supermartijn642.core.gui.widget.premade.AbstractButtonWidget;
import com.supermartijn642.core.network.BasePacket;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;

public class ChunkGridCell
extends BaseWidget {
    private static final ResourceLocation CELL_OVERLAY = new ResourceLocation("chunkloaders", "textures/gui/cell_overlay.png");
    private final ChunkPos pos;
    private final UUID player;
    private final BiFunction<Integer, Integer, Boolean> isLoaded;
    private final BiFunction<Integer, Integer, Boolean> isWithinRange;
    private final BiFunction<Integer, Integer, Boolean> isLoadedByOtherPlayer;
    private final ChunkImage image;

    public ChunkGridCell(int x, int y, ChunkPos chunk, int loaderYLevel, UUID player, BiFunction<Integer, Integer, Boolean> isLoaded, BiFunction<Integer, Integer, Boolean> isWithinRange, BiFunction<Integer, Integer, Boolean> isLoadedByOtherPlayer) {
        super(x, y, 18, 18);
        this.pos = chunk;
        this.player = player;
        this.isLoaded = isLoaded;
        this.isWithinRange = isWithinRange;
        this.isLoadedByOtherPlayer = isLoadedByOtherPlayer;
        this.image = new ChunkImage(ClientUtils.getWorld(), chunk, loaderYLevel);
    }

    public Component getNarrationMessage() {
        if (this.isLoaded.apply(0, 0).booleanValue()) {
            return TextComponents.translation((String)"chunkloaders.gui.chunk.loaded").get();
        }
        if (this.isWithinRange.apply(0, 0).booleanValue()) {
            return TextComponents.translation((String)"chunkloaders.gui.chunk.available").get();
        }
        if (this.isLoadedByOtherPlayer.apply(0, 0).booleanValue()) {
            return TextComponents.translation((String)"chunkloaders.gui.speech.chunk.others").get();
        }
        return TextComponents.translation((String)"chunkloaders.gui.speech.chunk.not_loaded").get();
    }

    public void renderBackground(PoseStack poseStack, int mouseX, int mouseY) {
        this.image.bindTexture();
        ScreenUtils.drawTexture((PoseStack)poseStack, (float)(this.x + 1), (float)(this.y + 1), (float)16.0f, (float)16.0f);
    }

    public void render(PoseStack poseStack, int mouseX, int mouseY) {
        this.drawOutline(poseStack, this.isLoadedByOtherPlayer, 0.15686275f, 0.15686275f, 0.15686275f, 0.76862746f, 0.76862746f, 0.76862746f, 0.38039216f);
        this.drawOutline(poseStack, this.isWithinRange, 0.0f, 0.32156864f, 0.76862746f, 0.0f, 0.32156864f, 0.76862746f, 0.22745098f);
        this.drawOutline(poseStack, this.isLoaded, 0.0f, 0.3882353f, 0.043137256f, 0.0f, 0.3882353f, 0.043137256f, 0.45490196f);
    }

    public void renderForeground(PoseStack poseStack, int mouseX, int mouseY) {
        if (this.isFocused() && this.canPlayerToggleChunk()) {
            ScreenUtils.bindTexture((ResourceLocation)CELL_OVERLAY);
            ScreenUtils.drawTexture((PoseStack)poseStack, (float)(this.x - 1), (float)(this.y - 1), (float)(this.width + 2), (float)(this.height + 2));
        }
    }

    private void drawOutline(PoseStack poseStack, BiFunction<Integer, Integer, Boolean> shouldConnect, float redBorder, float greenBorder, float blueBorder, float redFiller, float greenFiller, float blueFiller, float alphaFiller) {
        if (!shouldConnect.apply(0, 0).booleanValue()) {
            return;
        }
        ScreenUtils.fillRect((PoseStack)poseStack, (float)this.x, (float)this.y, (float)this.width, (float)this.height, (float)redFiller, (float)greenFiller, (float)blueFiller, (float)alphaFiller);
        if (!shouldConnect.apply(0, -1).booleanValue()) {
            ScreenUtils.fillRect((PoseStack)poseStack, (float)this.x, (float)this.y, (float)this.width, (float)1.0f, (float)redBorder, (float)greenBorder, (float)blueBorder, (float)1.0f);
        }
        if (!shouldConnect.apply(1, 0).booleanValue()) {
            ScreenUtils.fillRect((PoseStack)poseStack, (float)(this.x + this.width - 1), (float)this.y, (float)1.0f, (float)this.height, (float)redBorder, (float)greenBorder, (float)blueBorder, (float)1.0f);
        }
        if (!shouldConnect.apply(0, 1).booleanValue()) {
            ScreenUtils.fillRect((PoseStack)poseStack, (float)this.x, (float)(this.y + this.height - 1), (float)this.width, (float)1.0f, (float)redBorder, (float)greenBorder, (float)blueBorder, (float)1.0f);
        }
        if (!shouldConnect.apply(-1, 0).booleanValue()) {
            ScreenUtils.fillRect((PoseStack)poseStack, (float)this.x, (float)this.y, (float)1.0f, (float)this.height, (float)redBorder, (float)greenBorder, (float)blueBorder, (float)1.0f);
        }
        if (shouldConnect.apply(0, -1).booleanValue() && shouldConnect.apply(-1, 0).booleanValue() && !shouldConnect.apply(-1, -1).booleanValue()) {
            ScreenUtils.fillRect((PoseStack)poseStack, (float)this.x, (float)this.y, (float)1.0f, (float)1.0f, (float)redBorder, (float)greenBorder, (float)blueBorder, (float)1.0f);
        }
        if (shouldConnect.apply(0, -1).booleanValue() && shouldConnect.apply(1, 0).booleanValue() && !shouldConnect.apply(1, -1).booleanValue()) {
            ScreenUtils.fillRect((PoseStack)poseStack, (float)(this.x + this.width - 1), (float)this.y, (float)1.0f, (float)1.0f, (float)redBorder, (float)greenBorder, (float)blueBorder, (float)1.0f);
        }
        if (shouldConnect.apply(0, 1).booleanValue() && shouldConnect.apply(-1, 0).booleanValue() && !shouldConnect.apply(-1, 1).booleanValue()) {
            ScreenUtils.fillRect((PoseStack)poseStack, (float)this.x, (float)(this.y + this.height - 1), (float)1.0f, (float)1.0f, (float)redBorder, (float)greenBorder, (float)blueBorder, (float)1.0f);
        }
        if (shouldConnect.apply(0, 1).booleanValue() && shouldConnect.apply(1, 0).booleanValue() && !shouldConnect.apply(1, 1).booleanValue()) {
            ScreenUtils.fillRect((PoseStack)poseStack, (float)(this.x + this.width - 1), (float)(this.y + this.height - 1), (float)1.0f, (float)1.0f, (float)redBorder, (float)greenBorder, (float)blueBorder, (float)1.0f);
        }
    }

    protected void getTooltips(Consumer<Component> tooltipConsumer) {
        if (this.isFocused()) {
            ArrayList<MutableComponent> tooltips = new ArrayList<MutableComponent>();
            boolean canToggleChunk = this.canPlayerToggleChunk();
            if (canToggleChunk) {
                if (this.isLoaded.apply(0, 0).booleanValue()) {
                    tooltips.add(TextComponents.translation((String)"chunkloaders.gui.chunk.loaded").color(ChatFormatting.GOLD).get());
                } else if (this.isWithinRange.apply(0, 0).booleanValue()) {
                    tooltips.add(TextComponents.translation((String)"chunkloaders.gui.chunk.available").color(ChatFormatting.GOLD).get());
                }
            }
            ChunkLoadingCapability capability = ChunkLoadingCapability.get(ClientUtils.getWorld());
            capability.getActivePlayersLoadingChunk(this.pos).stream().filter(uuid -> !canToggleChunk || !uuid.equals(this.player)).map(PlayerRenderer::getPlayerUsername).filter(Objects::nonNull).map(name -> TextComponents.string((String)(" " + name)).color(ChatFormatting.GRAY).italic().get()).forEach(tooltips::add);
            capability.getInactivePlayersLoadingChunk(this.pos).stream().filter(uuid -> !canToggleChunk || !uuid.equals(this.player)).map(PlayerRenderer::getPlayerUsername).filter(Objects::nonNull).map(name -> TextComponents.string((String)" ").string(name).color(ChatFormatting.GRAY).italic().strikethrough().get()).forEach(tooltips::add);
            if (tooltips.size() > (canToggleChunk ? 1 : 0)) {
                tooltips.add(canToggleChunk ? 1 : 0, TextComponents.translation((String)"chunkloaders.gui.chunk.others").color(ChatFormatting.WHITE).get());
            }
            if (!ClientUtils.getPlayer().m_20148_().equals(this.player) && ClientUtils.getPlayer().m_20310_(2) && !Screen.m_96638_() && (this.isWithinRange.apply(0, 0).booleanValue() || this.isLoaded.apply(0, 0).booleanValue())) {
                MutableComponent keyName = TextComponents.fromTextComponent((Component)ClientUtils.getMinecraft().f_91066_.f_92090_.m_90863_()).color(ChatFormatting.GOLD).get();
                tooltips.add(TextComponents.translation((String)"chunkloaders.gui.chunk.overwrite", (Object[])new Object[]{keyName}).color(ChatFormatting.WHITE).get());
            }
            tooltips.forEach(tooltipConsumer);
        }
    }

    public void onPress() {
        if (this.canPlayerToggleChunk()) {
            AbstractButtonWidget.playClickSound();
            ChunkLoaders.CHANNEL.sendToServer((BasePacket)new PacketToggleChunk(this.player, this.pos));
        }
    }

    private boolean canPlayerToggleChunk() {
        Player player = ClientUtils.getPlayer();
        return (player.m_20148_().equals(this.player) || player.m_20310_(2) && Screen.m_96638_()) && (this.isWithinRange.apply(0, 0) != false || this.isLoaded.apply(0, 0) != false);
    }

    public boolean isLoaded() {
        return this.isLoaded.apply(0, 0);
    }

    public void discard() {
        this.image.dispose();
    }
}

