/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.behaviors.PickupSink;
import appeng.api.behaviors.PickupStrategy;
import appeng.api.config.Actionable;
import appeng.api.ids.AETags;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.core.AppEng;
import appeng.core.sync.packets.BlockTransitionEffectPacket;
import appeng.util.GenericContainerHelper;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class FluidPickupStrategy
implements PickupStrategy {
    private final ServerLevel level;
    private final BlockPos pos;
    private final Direction side;
    private long lastEffect;

    public FluidPickupStrategy(ServerLevel level, BlockPos pos, Direction side, BlockEntity host, Map<?, ?> enchantments) {
        this.level = level;
        this.pos = pos;
        this.side = side;
    }

    @Override
    public void reset() {
    }

    @Override
    public boolean canPickUpEntity(Entity entity) {
        return false;
    }

    @Override
    public boolean pickUpEntity(IEnergySource energySource, PickupSink sink, Entity entity) {
        return false;
    }

    @Override
    public PickupStrategy.Result tryStartPickup(IEnergySource energySource, PickupSink sink) {
        BlockState blockstate = this.level.m_8055_(this.pos);
        Block block = blockstate.m_60734_();
        if (block instanceof BucketPickup) {
            BucketPickup bucketPickup = (BucketPickup)block;
            FluidState fluidState = blockstate.m_60819_();
            Fluid fluid = fluidState.m_76152_();
            if (this.isFluidBlacklisted(fluid)) {
                return PickupStrategy.Result.CANT_PICKUP;
            }
            if (fluid != Fluids.f_76191_ && fluidState.m_76170_()) {
                AEFluidKey what = AEFluidKey.of(fluid);
                if (this.storeFluid(sink, what, 1000L, false)) {
                    AEKey aEKey;
                    ItemStack fluidContainer = bucketPickup.m_142598_((LevelAccessor)this.level, this.pos, blockstate);
                    GenericStack pickedUpStack = GenericContainerHelper.getContainedFluidStack(fluidContainer);
                    if (pickedUpStack != null && (aEKey = pickedUpStack.what()) instanceof AEFluidKey) {
                        AEFluidKey fluidKey = (AEFluidKey)aEKey;
                        this.storeFluid(sink, fluidKey, pickedUpStack.amount(), true);
                    }
                    if (!this.throttleEffect()) {
                        AppEng.instance().sendToAllNearExcept(null, this.pos.m_123341_(), this.pos.m_123342_(), this.pos.m_123343_(), 64.0, (Level)this.level, new BlockTransitionEffectPacket(this.pos, blockstate, this.side, BlockTransitionEffectPacket.SoundMode.FLUID));
                    }
                    return PickupStrategy.Result.PICKED_UP;
                }
                return PickupStrategy.Result.CANT_STORE;
            }
        }
        return PickupStrategy.Result.CANT_PICKUP;
    }

    @Override
    public void completePickup(IEnergySource energySource, PickupSink sink) {
    }

    private boolean storeFluid(PickupSink sink, AEFluidKey what, long amount, boolean modulate) {
        return sink.insert(what, amount, modulate ? Actionable.MODULATE : Actionable.SIMULATE) >= amount;
    }

    private boolean isFluidBlacklisted(Fluid fluid) {
        return fluid.m_205069_().m_203656_(AETags.ANNIHILATION_PLANE_FLUID_BLACKLIST);
    }

    private boolean throttleEffect() {
        long now = System.currentTimeMillis();
        if (now < this.lastEffect + 250L) {
            return true;
        }
        this.lastEffect = now;
        return false;
    }
}

