/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei;

import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.core.localization.ItemModText;
import appeng.integration.modules.jei.CyclingDrawable;
import appeng.integration.modules.jei.ViewBasedCategory;
import appeng.integration.modules.jei.widgets.View;
import appeng.integration.modules.jei.widgets.Widget;
import appeng.integration.modules.jei.widgets.WidgetFactory;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class CertusGrowthCategory
extends ViewBasedCategory<Page> {
    public static RecipeType<Page> TYPE = RecipeType.create((String)"ae2", (String)"certus_growth", Page.class);
    private final List<ItemStack> BUDDING_QUARTZ_VARIANTS = List.of(AEBlocks.DAMAGED_BUDDING_QUARTZ.stack(), AEBlocks.CHIPPED_BUDDING_QUARTZ.stack(), AEBlocks.FLAWED_BUDDING_QUARTZ.stack(), AEBlocks.FLAWLESS_BUDDING_QUARTZ.stack());
    private final List<Item> BUDDING_QUARTZ_DECAY_ORDER = List.of(AEBlocks.QUARTZ_BLOCK.m_5456_(), AEBlocks.DAMAGED_BUDDING_QUARTZ.m_5456_(), AEBlocks.CHIPPED_BUDDING_QUARTZ.m_5456_(), AEBlocks.FLAWED_BUDDING_QUARTZ.m_5456_());
    private final List<ItemStack> BUD_GROWTH_STAGES = List.of(AEBlocks.SMALL_QUARTZ_BUD.stack(), AEBlocks.MEDIUM_QUARTZ_BUD.stack(), AEBlocks.LARGE_QUARTZ_BUD.stack(), AEBlocks.QUARTZ_CLUSTER.stack());
    private final ItemStack END_RESULT = AEItems.CERTUS_QUARTZ_CRYSTAL.stack(4);
    private final IDrawable background;
    private final IDrawable slotBackground;
    private final IDrawable icon;
    private int centerX;

    public CertusGrowthCategory(IJeiHelpers helpers) {
        super(helpers);
        IGuiHelper guiHelper = helpers.getGuiHelper();
        this.background = guiHelper.createBlankDrawable(150, 60);
        this.slotBackground = guiHelper.getSlotDrawable();
        this.icon = CyclingDrawable.forItems(guiHelper, AEBlocks.SMALL_QUARTZ_BUD, AEBlocks.MEDIUM_QUARTZ_BUD, AEBlocks.LARGE_QUARTZ_BUD, AEBlocks.QUARTZ_CLUSTER);
        this.centerX = this.background.getWidth() / 2;
    }

    public RecipeType<Page> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return ItemModText.CERTUS_QUARTZ_GROWTH.text();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    @Override
    protected View getView(final Page page) {
        return switch (page) {
            default -> throw new IncompatibleClassChangeError();
            case Page.BUD_GROWTH -> new View(){

                @Override
                public void createWidgets(WidgetFactory factory, List<Widget> widgets) {
                    widgets.add(factory.label(CertusGrowthCategory.this.centerX, 0.0f, (Component)ItemModText.QUARTZ_BUDS_GROW_ON_BUDDING_QUARTZ.text()).bodyText().maxWidth(CertusGrowthCategory.this.background.getWidth()));
                    widgets.add(factory.unfilledArrow(CertusGrowthCategory.this.centerX - 12, 25));
                }

                @Override
                public void buildSlots(IRecipeLayoutBuilder builder) {
                    builder.addSlot(RecipeIngredientRole.CATALYST, CertusGrowthCategory.this.centerX - 40, 25).setBackground(CertusGrowthCategory.this.slotBackground, -1, -1).addItemStacks(CertusGrowthCategory.this.BUDDING_QUARTZ_VARIANTS);
                    builder.addSlot(RecipeIngredientRole.OUTPUT, CertusGrowthCategory.this.centerX + 40 - 18, 25).setBackground(CertusGrowthCategory.this.slotBackground, -1, -1).addItemStacks(CertusGrowthCategory.this.BUD_GROWTH_STAGES);
                }
            };
            case Page.BUD_LOOT, Page.CLUSTER_LOOT -> new View(){

                @Override
                public void createWidgets(WidgetFactory factory, List<Widget> widgets) {
                    MutableComponent text = page == Page.BUD_LOOT ? ItemModText.BUDS_DROP_DUST_WHEN_NOT_FULLY_GROWN.text() : ItemModText.FULLY_GROWN_BUDS_DROP_CRYSTALS.text();
                    widgets.add(factory.label(CertusGrowthCategory.this.centerX, 0.0f, (Component)text).bodyText().maxWidth(CertusGrowthCategory.this.background.getWidth()));
                    widgets.add(factory.unfilledArrow(CertusGrowthCategory.this.centerX - 12, 25));
                    if (page == Page.CLUSTER_LOOT) {
                        widgets.add(factory.label(CertusGrowthCategory.this.centerX, 50.0f, (Component)ItemModText.FORTUNE_APPLIES.text()).bodyText());
                    }
                }

                @Override
                public void buildSlots(IRecipeLayoutBuilder builder) {
                    List<ItemStack> input = page == Page.BUD_LOOT ? List.of(AEBlocks.SMALL_QUARTZ_BUD.stack(), AEBlocks.MEDIUM_QUARTZ_BUD.stack(), AEBlocks.LARGE_QUARTZ_BUD.stack()) : List.of(AEBlocks.QUARTZ_CLUSTER.stack());
                    builder.addSlot(RecipeIngredientRole.INPUT, CertusGrowthCategory.this.centerX - 40, 25).setBackground(CertusGrowthCategory.this.slotBackground, -1, -1).addItemStacks(input);
                    ItemStack finalResult = page == Page.BUD_LOOT ? AEItems.CERTUS_QUARTZ_DUST.stack() : AEItems.CERTUS_QUARTZ_CRYSTAL.stack(4);
                    IRecipeSlotBuilder outputSlot = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, CertusGrowthCategory.this.centerX + 40 - 18, 25).setBackground(CertusGrowthCategory.this.slotBackground, -1, -1).addItemStack(finalResult);
                }
            };
            case Page.BUDDING_QUARTZ_DECAY -> new View(){

                @Override
                public void createWidgets(WidgetFactory factory, List<Widget> widgets) {
                    widgets.add(factory.label(CertusGrowthCategory.this.centerX, 0.0f, (Component)ItemModText.IMPERFECT_BUDDING_QUARTZ_DECAYS.text()).bodyText().maxWidth(CertusGrowthCategory.this.background.getWidth()));
                    widgets.add(factory.unfilledArrow(CertusGrowthCategory.this.centerX - 12, 30));
                    int decayChancePct = 8;
                    widgets.add(factory.label(CertusGrowthCategory.this.centerX, 50.0f, (Component)ItemModText.DECAY_CHANCE.text(decayChancePct)).bodyText());
                }

                @Override
                public void buildSlots(IRecipeLayoutBuilder builder) {
                    ArrayList<ItemStack> decayingVariants = new ArrayList<ItemStack>(CertusGrowthCategory.this.BUDDING_QUARTZ_VARIANTS);
                    decayingVariants.removeIf(is -> !CertusGrowthCategory.this.BUDDING_QUARTZ_DECAY_ORDER.contains(is.m_41720_()));
                    builder.addSlot(RecipeIngredientRole.INPUT, CertusGrowthCategory.this.centerX - 40, 30).setBackground(CertusGrowthCategory.this.slotBackground, -1, -1).addItemStacks(decayingVariants);
                    builder.addSlot(RecipeIngredientRole.OUTPUT, CertusGrowthCategory.this.centerX + 40 - 18, 30).setBackground(CertusGrowthCategory.this.slotBackground, -1, -1).addItemStacks(CertusGrowthCategory.this.BUDDING_QUARTZ_DECAY_ORDER.stream().map(ItemStack::new).toList());
                }
            };
            case Page.BUDDING_QUARTZ_MOVING -> new View(){

                @Override
                public void buildSlots(IRecipeLayoutBuilder builder) {
                    builder.addSlot(RecipeIngredientRole.INPUT, CertusGrowthCategory.this.centerX - 40, 22).setBackground(CertusGrowthCategory.this.slotBackground, -1, -1).addItemStacks(CertusGrowthCategory.this.BUDDING_QUARTZ_VARIANTS);
                    builder.addSlot(RecipeIngredientRole.OUTPUT, CertusGrowthCategory.this.centerX + 40 - 18, 22).setBackground(CertusGrowthCategory.this.slotBackground, -1, -1).addItemStack(AEBlocks.QUARTZ_BLOCK.stack());
                }

                @Override
                public void createWidgets(WidgetFactory factory, List<Widget> widgets) {
                    widgets.add(factory.label(CertusGrowthCategory.this.centerX, 0.0f, (Component)ItemModText.BUDDING_QUARTZ_DECAYS_WHEN_BROKEN.text()).bodyText().maxWidth(CertusGrowthCategory.this.background.getWidth()));
                    widgets.add(factory.unfilledArrow(CertusGrowthCategory.this.centerX - 12, 22));
                    widgets.add(factory.label(CertusGrowthCategory.this.centerX, 42.0f, (Component)ItemModText.SILK_TOUCH_CAUSES_LESS_DECAY.text()).bodyText());
                    widgets.add(factory.label(CertusGrowthCategory.this.centerX, 53.0f, (Component)ItemModText.SPATIAL_IO_CAUSES_NONE.text()).bodyText());
                }
            };
            case Page.GETTING_BUDDING_QUARTZ -> new View(){

                @Override
                public void createWidgets(WidgetFactory factory, List<Widget> widgets) {
                    widgets.add(factory.label(22.0f, 13.0f, (Component)ItemModText.BUDDING_QUARTZ_CREATION_AND_WORLDGEN.text()).bodyText().alignLeft().maxWidth(CertusGrowthCategory.this.background.getWidth() - 20));
                }

                @Override
                public void buildSlots(IRecipeLayoutBuilder builder) {
                    List<ItemStack> decayingVariants = CertusGrowthCategory.this.BUDDING_QUARTZ_DECAY_ORDER.stream().map(ItemStack::new).toList();
                    builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).setBackground(CertusGrowthCategory.this.slotBackground, -1, -1).addItemStacks(decayingVariants);
                    builder.addSlot(RecipeIngredientRole.INPUT, 1, 22).setBackground(CertusGrowthCategory.this.slotBackground, -1, -1).addItemStack(AEItems.CERTUS_QUARTZ_CRYSTAL_CHARGED.stack());
                    builder.addSlot(RecipeIngredientRole.CATALYST, 1, 43).setBackground(CertusGrowthCategory.this.slotBackground, -1, -1).addItemStack(AEItems.METEORITE_COMPASS.stack());
                }
            };
            case Page.FLAWLESS_BUDDING_QUARTZ -> new View(){

                @Override
                public void createWidgets(WidgetFactory factory, List<Widget> widgets) {
                    widgets.add(factory.label(22.0f, 13.0f, (Component)ItemModText.FLAWLESS_BUDDING_QUARTZ_DESCRIPTION.text()).bodyText().alignLeft().maxWidth(CertusGrowthCategory.this.background.getWidth() - 20));
                }

                @Override
                public void buildSlots(IRecipeLayoutBuilder builder) {
                    builder.addSlot(RecipeIngredientRole.CATALYST, 1, 13).setBackground(CertusGrowthCategory.this.slotBackground, -1, -1).addItemStack(AEBlocks.FLAWLESS_BUDDING_QUARTZ.stack());
                    builder.addSlot(RecipeIngredientRole.INPUT, 1, 33).setBackground(CertusGrowthCategory.this.slotBackground, -1, -1).addItemStack(AEItems.METEORITE_COMPASS.stack());
                }
            };
            case Page.BUDDING_QUARTZ_ACCELERATION -> new View(){

                @Override
                public void createWidgets(WidgetFactory factory, List<Widget> widgets) {
                    int centerX = CertusGrowthCategory.this.background.getWidth() / 2;
                    widgets.add(factory.label(centerX, 0.0f, (Component)ItemModText.CRYSTAL_GROWTH_ACCELERATORS_EFFECT.text()).bodyText().maxWidth(CertusGrowthCategory.this.background.getWidth()));
                    widgets.add(factory.label(centerX, 45.0f, (Component)Component.m_237113_((String)"+")));
                }

                @Override
                public void buildSlots(IRecipeLayoutBuilder builder) {
                    builder.addSlot(RecipeIngredientRole.INPUT, CertusGrowthCategory.this.centerX - 8 - 16, 40).setBackground(CertusGrowthCategory.this.slotBackground, -1, -1).addItemStacks(CertusGrowthCategory.this.BUDDING_QUARTZ_VARIANTS);
                    builder.addSlot(RecipeIngredientRole.CATALYST, CertusGrowthCategory.this.centerX + 8, 40).setBackground(CertusGrowthCategory.this.slotBackground, -1, -1).addItemStack(AEBlocks.QUARTZ_GROWTH_ACCELERATOR.stack());
                }
            };
        };
    }

    public static enum Page {
        BUD_GROWTH,
        BUD_LOOT,
        CLUSTER_LOOT,
        BUDDING_QUARTZ_DECAY,
        BUDDING_QUARTZ_MOVING,
        GETTING_BUDDING_QUARTZ,
        FLAWLESS_BUDDING_QUARTZ,
        BUDDING_QUARTZ_ACCELERATION;

    }
}

