/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.overlay;

import appeng.api.util.DimensionalBlockPos;
import appeng.client.render.overlay.IOverlayDataSource;
import appeng.client.render.overlay.OverlayRenderType;
import appeng.client.render.overlay.OverlayRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class OverlayManager {
    private static final OverlayManager INSTANCE = new OverlayManager();
    private final Map<DimensionalBlockPos, OverlayRenderer> overlayHandlers = new HashMap<DimensionalBlockPos, OverlayRenderer>();

    public static OverlayManager getInstance() {
        return INSTANCE;
    }

    @SubscribeEvent
    public void renderWorldLastEvent(RenderLevelLastEvent event) {
        Minecraft minecraft = Minecraft.m_91087_();
        MultiBufferSource.BufferSource buffer = minecraft.m_91269_().m_110104_();
        PoseStack poseStack = event.getPoseStack();
        poseStack.m_85836_();
        Vec3 projectedView = minecraft.f_91063_.m_109153_().m_90583_();
        poseStack.m_85837_(-projectedView.f_82479_, -projectedView.f_82480_, -projectedView.f_82481_);
        for (OverlayRenderer handler : this.overlayHandlers.entrySet().stream().filter(e -> ((DimensionalBlockPos)e.getKey()).getLevel() == minecraft.f_91073_).map(Map.Entry::getValue).collect(Collectors.toList())) {
            handler.render(poseStack, (MultiBufferSource)buffer);
        }
        poseStack.m_85849_();
        buffer.m_109912_(OverlayRenderType.getBlockHilightFace());
        buffer.m_109912_(OverlayRenderType.getBlockHilightLine());
    }

    public OverlayRenderer showArea(IOverlayDataSource source) {
        Objects.requireNonNull(source);
        OverlayRenderer handler = new OverlayRenderer(source);
        this.overlayHandlers.put(source.getOverlaySourceLocation(), handler);
        return handler;
    }

    public boolean isShowing(IOverlayDataSource source) {
        return this.overlayHandlers.containsKey(source.getOverlaySourceLocation());
    }

    public void removeHandlers(IOverlayDataSource source) {
        this.overlayHandlers.remove(source.getOverlaySourceLocation());
    }
}

