/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.io;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import journeymap.client.Constants;
import journeymap.client.cartography.color.RGB;
import journeymap.client.io.FileHandler;
import journeymap.client.model.MapType;
import journeymap.client.model.RegionCoord;
import journeymap.client.model.RegionImageCache;
import journeymap.client.render.map.TileDrawStep;
import journeymap.client.render.map.TileDrawStepCache;
import journeymap.client.texture.ImageUtil;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.world.level.ChunkPos;

public class RegionImageHandler {
    public static File getImageDir(RegionCoord rCoord, MapType mapType) {
        File dimDir = rCoord.dimDir.toFile();
        File subDir = null;
        subDir = mapType.isUnderground() ? new File(dimDir, Integer.toString(mapType.vSlice)) : new File(dimDir, mapType.name());
        if (!subDir.exists()) {
            subDir.mkdirs();
        }
        return subDir;
    }

    public static File getRegionImageFile(RegionCoord rCoord, MapType mapType) {
        StringBuffer sb = new StringBuffer();
        sb.append(rCoord.regionX).append(",").append(rCoord.regionZ).append(".png");
        File regionFile = new File(RegionImageHandler.getImageDir(rCoord, mapType), sb.toString());
        return regionFile;
    }

    public static NativeImage readRegionImage(File regionFile) {
        if (regionFile.canRead()) {
            try {
                NativeImage image = RegionImageHandler.getImage(regionFile);
                return image;
            }
            catch (Exception e) {
                String error = "Region file produced error: " + regionFile + ": " + LogFormatter.toPartialString(e);
                Journeymap.getLogger().error(error);
            }
        }
        return null;
    }

    public static NativeImage getImage(File file) {
        try {
            FileInputStream is = new FileInputStream(file.getPath());
            return NativeImage.m_85058_((InputStream)is);
        }
        catch (IOException e) {
            String error = "Could not get image from file: " + file + ": " + e.getMessage();
            Journeymap.getLogger().error(error);
            return null;
        }
    }

    public static synchronized NativeImage getMergedChunks(File worldDir, ChunkPos startCoord, ChunkPos endCoord, MapType mapType, Boolean useCache, NativeImage image, Integer imageWidth, Integer imageHeight, boolean allowNullImage, boolean showGrid) {
        int scale = 1;
        scale = Math.max(scale, 1);
        int initialWidth = Math.min(512, (endCoord.f_45578_ - startCoord.f_45578_ + 1) * 16 / scale);
        int initialHeight = Math.min(512, (endCoord.f_45579_ - startCoord.f_45579_ + 1) * 16 / scale);
        image = new NativeImage(initialWidth, initialHeight, false);
        RegionImageCache cache = RegionImageCache.INSTANCE;
        RegionCoord rc = null;
        NativeImage regionImage = null;
        int rx1 = RegionCoord.getRegionPos(startCoord.f_45578_);
        int rx2 = RegionCoord.getRegionPos(endCoord.f_45578_);
        int rz1 = RegionCoord.getRegionPos(startCoord.f_45579_);
        int rz2 = RegionCoord.getRegionPos(endCoord.f_45579_);
        boolean imageDrawn = false;
        for (int rx = rx1; rx <= rx2; ++rx) {
            for (int rz = rz1; rz <= rz2; ++rz) {
                rc = new RegionCoord(worldDir, rx, rz, mapType.dimension);
                regionImage = cache.getRegionImageSet(rc).getImage(mapType);
                if (regionImage == null) continue;
                int rminCx = Math.max(rc.getMinChunkX(), startCoord.f_45578_);
                int rminCz = Math.max(rc.getMinChunkZ(), startCoord.f_45579_);
                int rmaxCx = Math.min(rc.getMaxChunkX(), endCoord.f_45578_);
                int rmaxCz = Math.min(rc.getMaxChunkZ(), endCoord.f_45579_);
                int xoffset = rc.getMinChunkX() * 16;
                int yoffset = rc.getMinChunkZ() * 16;
                int sx1 = rminCx * 16 - xoffset;
                int sy1 = rminCz * 16 - yoffset;
                int sx2 = sx1 + (rmaxCx - rminCx + 1) * 16;
                int sy2 = sy1 + (rmaxCz - rminCz + 1) * 16;
                xoffset = startCoord.f_45578_ * 16;
                yoffset = startCoord.f_45579_ * 16;
                int dx1 = startCoord.f_45578_ * 16 - xoffset;
                int dy1 = startCoord.f_45579_ * 16 - yoffset;
                int dx2 = dx1 + (endCoord.f_45578_ - startCoord.f_45578_ + 1) * 16;
                int dy2 = dy1 + (endCoord.f_45579_ - startCoord.f_45579_ + 1) * 16;
                for (int x = 0; x < sx2; ++x) {
                    for (int y = 0; y < sy2; ++y) {
                        int pixel = regionImage.m_84985_(x, y);
                        image.m_84988_(x, y, pixel);
                    }
                }
                imageDrawn = true;
            }
        }
        if (imageDrawn && showGrid) {
            int color = mapType.isDay() ? RGB.toArbg(0, 0.25f) : RGB.toArbg(0x808080, 0.1f);
            for (int y = 0; y < initialHeight; y += 16) {
                for (int x = 0; x < initialWidth; ++x) {
                    image.m_166411_(x, y, color);
                }
            }
            for (int x = 0; x < initialWidth; x += 16) {
                for (int y = 0; y < initialHeight; ++y) {
                    image.m_166411_(x, y, color);
                }
            }
        }
        if (allowNullImage && !imageDrawn) {
            return null;
        }
        if (imageHeight != null && imageWidth != null && (initialHeight != imageHeight || initialWidth != imageWidth)) {
            return ImageUtil.getSizedImage(imageWidth, imageHeight, image, true);
        }
        return image;
    }

    public static synchronized List<TileDrawStep> getTileDrawSteps(File worldDir, ChunkPos startCoord, ChunkPos endCoord, MapType mapType, Integer zoom, boolean highQuality) {
        boolean isUnderground = mapType.isUnderground();
        int rx1 = RegionCoord.getRegionPos(startCoord.f_45578_);
        int rx2 = RegionCoord.getRegionPos(endCoord.f_45578_);
        int rz1 = RegionCoord.getRegionPos(startCoord.f_45579_);
        int rz2 = RegionCoord.getRegionPos(endCoord.f_45579_);
        ArrayList<TileDrawStep> drawSteps = new ArrayList<TileDrawStep>();
        for (int rx = rx1; rx <= rx2; ++rx) {
            for (int rz = rz1; rz <= rz2; ++rz) {
                RegionCoord rc = new RegionCoord(worldDir, rx, rz, mapType.dimension);
                int rminCx = Math.max(rc.getMinChunkX(), startCoord.f_45578_);
                int rminCz = Math.max(rc.getMinChunkZ(), startCoord.f_45579_);
                int rmaxCx = Math.min(rc.getMaxChunkX(), endCoord.f_45578_);
                int rmaxCz = Math.min(rc.getMaxChunkZ(), endCoord.f_45579_);
                int xoffset = rc.getMinChunkX() * 16;
                int yoffset = rc.getMinChunkZ() * 16;
                int sx1 = rminCx * 16 - xoffset;
                int sy1 = rminCz * 16 - yoffset;
                int sx2 = sx1 + (rmaxCx - rminCx + 1) * 16;
                int sy2 = sy1 + (rmaxCz - rminCz + 1) * 16;
                drawSteps.add(TileDrawStepCache.getOrCreate(mapType, rc, zoom, highQuality, sx1, sy1, sx2, sy2));
            }
        }
        return drawSteps;
    }

    public static File getBlank512x512ImageFile() {
        File dataDir = new File(FileHandler.MinecraftDirectory, Constants.DATA_DIR);
        File tmpFile = new File(dataDir, "blank512x512.png");
        if (!tmpFile.canRead()) {
            try (NativeImage image = new NativeImage(512, 512, false);){
                dataDir.mkdirs();
                image.m_85056_(tmpFile);
                tmpFile.setReadOnly();
                tmpFile.deleteOnExit();
            }
            catch (IOException e) {
                Journeymap.getLogger().error("Could not create blank temp file " + tmpFile + ": " + LogFormatter.toString(e));
            }
        }
        return tmpFile;
    }
}

