/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.vanilla.provider;

import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerAccessor;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.component.PairComponent;
import mcp.mobius.waila.plugin.vanilla.config.Options;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.AgeableMob;

public enum MobTimerProvider implements IEntityComponentProvider,
IServerDataProvider<AgeableMob>
{
    INSTANCE;

    private static final String TIMER = "%02d:%02d";
    private long lastAge;
    private long lastDataSync;

    @Override
    public void appendBody(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        CompoundTag data = accessor.getServerData();
        if (data.m_128441_("age")) {
            long minutes;
            long seconds;
            if (this.lastDataSync != accessor.getServerDataTime()) {
                this.lastDataSync = accessor.getServerDataTime();
                this.lastAge = data.m_128451_("age");
                long delay = (System.currentTimeMillis() - this.lastDataSync) / 50L;
                if (this.lastAge < 0L) {
                    this.lastAge += delay;
                } else if (this.lastAge > 0L) {
                    this.lastAge -= delay;
                }
            }
            if (this.lastAge < 0L && config.getBoolean(Options.TIMER_GROW)) {
                seconds = -this.lastAge / 20L + 1L;
                minutes = seconds / 60L;
                tooltip.addLine(new PairComponent((Component)Component.m_237115_((String)"tooltip.waila.timer.grow"), (Component)Component.m_237113_((String)TIMER.formatted(minutes, seconds -= minutes * 60L))));
            }
            if (this.lastAge > 0L && config.getBoolean(Options.TIMER_BREED)) {
                seconds = this.lastAge / 20L + 1L;
                minutes = seconds / 60L;
                tooltip.addLine(new PairComponent((Component)Component.m_237115_((String)"tooltip.waila.timer.breed"), (Component)Component.m_237113_((String)TIMER.formatted(minutes, seconds -= minutes * 60L))));
            }
            if (this.lastAge < 0L) {
                ++this.lastAge;
            } else if (this.lastAge > 0L) {
                --this.lastAge;
            }
        }
    }

    @Override
    public void appendServerData(CompoundTag data, IServerAccessor<AgeableMob> accessor, IPluginConfig config) {
        AgeableMob mob = accessor.getTarget();
        data.m_128405_("age", mob.m_146764_());
    }
}

