/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.item.decoration;

import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.ldtteam.domumornamentum.block.decorative.FramedLightBlock;
import com.ldtteam.domumornamentum.block.types.FramedLightType;
import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.ldtteam.domumornamentum.util.BlockUtils;
import com.ldtteam.domumornamentum.util.MaterialTextureDataUtil;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FramedLightBlockItem
extends BlockItem {
    private final FramedLightBlock framedLightBlock;

    public FramedLightBlockItem(FramedLightBlock blockIn, Item.Properties builder) {
        super((Block)blockIn, builder);
        this.framedLightBlock = blockIn;
    }

    public Component m_7626_(ItemStack stack) {
        CompoundTag dataNbt = stack.m_41698_("textureData");
        MaterialTextureData textureData = MaterialTextureData.deserializeFromNBT(dataNbt);
        IMateriallyTexturedBlockComponent centerComponent = (IMateriallyTexturedBlockComponent)this.framedLightBlock.getComponents().get(1);
        Block centerBlock = textureData.getTexturedComponents().getOrDefault(centerComponent.getId(), centerComponent.getDefault());
        Component centerBlockName = BlockUtils.getHoverName(centerBlock);
        return Component.m_237110_((String)"domum_ornamentum.light.frame.name.format", (Object[])new Object[]{centerBlockName});
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        CompoundTag dataNbt = stack.m_41698_("textureData");
        MaterialTextureData textureData = MaterialTextureData.deserializeFromNBT(dataNbt);
        if (textureData.isEmpty()) {
            textureData = MaterialTextureDataUtil.generateRandomTextureDataFrom(stack);
        }
        FramedLightType type = this.framedLightBlock.getFramedLightType();
        tooltip.add((Component)Component.m_237115_((String)"domum_ornamentum.origin.tooltip"));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"domum_ornamentum.light.frame.header"));
        tooltip.add((Component)Component.m_237110_((String)"domum_ornamentum.light.frame.type.format", (Object[])new Object[]{Component.m_237115_((String)("domum_ornamentum.light.frame.type." + type.getName()))}));
        IMateriallyTexturedBlockComponent frameComponent = (IMateriallyTexturedBlockComponent)this.framedLightBlock.getComponents().get(0);
        Block frameBlock = textureData.getTexturedComponents().getOrDefault(frameComponent.getId(), frameComponent.getDefault());
        Component frameBlockName = BlockUtils.getHoverName(frameBlock);
        tooltip.add((Component)Component.m_237110_((String)"domum_ornamentum.light.frame.block.format", (Object[])new Object[]{frameBlockName}));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"domum_ornamentum.light.center.header"));
        IMateriallyTexturedBlockComponent centerComponent = (IMateriallyTexturedBlockComponent)this.framedLightBlock.getComponents().get(1);
        Block centerBlock = textureData.getTexturedComponents().getOrDefault(centerComponent.getId(), centerComponent.getDefault());
        Component centerBlockName = BlockUtils.getHoverName(centerBlock);
        tooltip.add((Component)Component.m_237110_((String)"domum_ornamentum.light.center.block.format", (Object[])new Object[]{centerBlockName}));
    }
}

