/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile.tier1;

import com.bluepowermod.api.wire.redstone.CapabilityRedstoneDevice;
import com.bluepowermod.api.wire.redstone.IRedstoneDevice;
import com.bluepowermod.api.wire.redstone.RedstoneStorage;
import com.bluepowermod.block.BlockBPCableBase;
import com.bluepowermod.block.machine.BlockAlloyWire;
import com.bluepowermod.client.render.IBPColoredBlock;
import com.bluepowermod.init.BPBlockEntityType;
import com.bluepowermod.tile.TileBase;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class TileWire
extends TileBase {
    private final IRedstoneDevice device = new RedstoneStorage();
    @Nullable
    private BlockState cachedBlockState;
    private LazyOptional<IRedstoneDevice> redstoneCap;
    public static final ModelProperty<Pair<Integer, Integer>> COLOR_INFO = new ModelProperty();
    public static final ModelProperty<Boolean> LIGHT_INFO = new ModelProperty();

    public TileWire(BlockPos pos, BlockState state) {
        super((BlockEntityType)BPBlockEntityType.WIRE.get(), pos, state);
    }

    public TileWire(BlockEntityType type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public ModelData getModelData(BlockState state) {
        Pair colorData = Pair.of((Object)((IBPColoredBlock)state.m_60734_()).getColor(state, (BlockGetter)this.f_58857_, this.f_58858_, -1), (Object)((IBPColoredBlock)state.m_60734_()).getColor(state, (BlockGetter)this.f_58857_, this.f_58858_, 2));
        Boolean lightData = (Boolean)state.m_61143_((Property)BlockAlloyWire.POWERED);
        return ModelData.builder().with(COLOR_INFO, (Object)colorData).with(LIGHT_INFO, (Object)lightData).build();
    }

    @Override
    protected void readFromPacketNBT(CompoundTag compound) {
        super.readFromPacketNBT(compound);
        if (compound.m_128441_("device")) {
            Tag nbtstorage = compound.m_128423_("device");
            IRedstoneDevice.readNBT(CapabilityRedstoneDevice.UNINSULATED_CAPABILITY, this.device, null, nbtstorage);
        }
    }

    @Override
    protected void writeToPacketNBT(CompoundTag tCompound) {
        super.writeToPacketNBT(tCompound);
        Tag nbtstorage = IRedstoneDevice.writeNBT(CapabilityRedstoneDevice.UNINSULATED_CAPABILITY, this.device, null);
        tCompound.m_128365_("device", nbtstorage);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        BlockState state;
        ArrayList<Direction> directions = new ArrayList<Direction>(BlockBPCableBase.FACING.m_6908_());
        if (this.f_58857_ != null && (state = this.m_58900_()).m_60734_() instanceof BlockAlloyWire) {
            directions.remove(state.m_61143_((Property)BlockAlloyWire.FACING));
            directions.removeIf(d -> this.f_58857_.m_8055_(this.f_58858_.m_121945_(d)).m_60734_() instanceof BlockAlloyWire && this.f_58857_.m_8055_(this.f_58858_.m_121945_(d)).m_61143_((Property)BlockAlloyWire.FACING) != state.m_61143_((Property)BlockAlloyWire.FACING));
        }
        if (cap == CapabilityRedstoneDevice.UNINSULATED_CAPABILITY && (side == null || directions.contains(side))) {
            if (this.redstoneCap == null) {
                this.redstoneCap = LazyOptional.of(() -> this.device);
            }
            return this.redstoneCap.cast();
        }
        return LazyOptional.empty();
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.redstoneCap != null) {
            this.redstoneCap.invalidate();
            this.redstoneCap = null;
        }
    }
}

