/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile.tier1;

import com.bluepowermod.api.tube.IPneumaticTube;
import com.bluepowermod.client.gui.IGuiButtonSensitive;
import com.bluepowermod.container.ContainerFilter;
import com.bluepowermod.helper.IOHelper;
import com.bluepowermod.helper.ItemStackHelper;
import com.bluepowermod.tile.tier1.TileTransposer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class TileFilter
extends TileTransposer
implements WorldlyContainer,
IGuiButtonSensitive,
MenuProvider {
    public static final int SLOTS = 9;
    protected final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
    public IPneumaticTube.TubeColor filterColor = IPneumaticTube.TubeColor.NONE;
    public int fuzzySetting;

    public TileFilter(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    @Override
    protected boolean isItemAccepted(ItemStack item) {
        boolean everythingNull = true;
        for (ItemStack invStack : this.inventory) {
            if (invStack.m_41619_()) continue;
            if (ItemStackHelper.areStacksEqual(invStack, item, this.fuzzySetting)) {
                return true;
            }
            everythingNull = false;
        }
        return everythingNull;
    }

    @Override
    protected IPneumaticTube.TubeColor getAcceptedItemColor(ItemStack item) {
        return this.filterColor;
    }

    @Override
    protected void pullItem() {
        ItemStack extractedStack;
        Direction dir = this.getOutputDirection().m_122424_();
        BlockEntity tile = this.getTileCache(dir);
        Direction direction = dir.m_122424_();
        boolean everythingNull = true;
        for (ItemStack filterStack : this.inventory) {
            if (filterStack.m_41619_()) continue;
            everythingNull = false;
            ItemStack extractedStack2 = IOHelper.extract(tile, direction, filterStack, true, false, this.fuzzySetting);
            if (extractedStack2.m_41619_()) continue;
            this.addItemToOutputBuffer(extractedStack2, this.filterColor);
            break;
        }
        if (everythingNull && !(extractedStack = IOHelper.extract(tile, direction, false)).m_41619_()) {
            this.addItemToOutputBuffer(extractedStack, this.filterColor);
        }
    }

    @Override
    public void m_142466_(CompoundTag tCompound) {
        super.m_142466_(tCompound);
        for (int i = 0; i < 9; ++i) {
            CompoundTag tc = tCompound.m_128469_("inventory" + i);
            this.inventory.set(i, (Object)ItemStack.m_41712_((CompoundTag)tc));
        }
        this.filterColor = IPneumaticTube.TubeColor.values()[tCompound.m_128445_("filterColor")];
        this.fuzzySetting = tCompound.m_128445_("fuzzySetting");
    }

    @Override
    protected void m_183515_(CompoundTag tCompound) {
        super.m_183515_(tCompound);
        for (int i = 0; i < 9; ++i) {
            CompoundTag tc = new CompoundTag();
            ((ItemStack)this.inventory.get(i)).m_41739_(tc);
            tCompound.m_128365_("inventory" + i, (Tag)tc);
        }
        tCompound.m_128344_("filterColor", (byte)this.filterColor.ordinal());
        tCompound.m_128344_("fuzzySetting", (byte)this.fuzzySetting);
    }

    public int m_6643_() {
        return this.inventory.size();
    }

    public ItemStack m_8020_(int i) {
        return (ItemStack)this.inventory.get(i);
    }

    public ItemStack m_7407_(int slot, int amount) {
        ItemStack itemStack = this.m_8020_(slot);
        if (!itemStack.m_41619_()) {
            if (itemStack.m_41613_() <= amount) {
                this.m_6836_(slot, ItemStack.f_41583_);
            } else if ((itemStack = itemStack.m_41620_(amount)).m_41613_() == 0) {
                this.m_6836_(slot, ItemStack.f_41583_);
            }
        }
        return itemStack;
    }

    public ItemStack m_8016_(int i) {
        ItemStack itemStack = this.m_8020_(i);
        if (!itemStack.m_41619_()) {
            this.m_6836_(i, ItemStack.f_41583_);
        }
        return itemStack;
    }

    public void m_6836_(int i, ItemStack itemStack) {
        this.inventory.set(i, (Object)itemStack);
    }

    public int m_6893_() {
        return 64;
    }

    public boolean m_6542_(Player player) {
        return player.m_20183_().m_123314_((Vec3i)this.f_58858_, 64.0);
    }

    public void m_5856_(Player player) {
    }

    public void m_5785_(Player player) {
    }

    public boolean m_7013_(int i, ItemStack itemStack) {
        return true;
    }

    @Override
    public NonNullList<ItemStack> getDrops() {
        NonNullList<ItemStack> drops = super.getDrops();
        for (ItemStack stack : this.inventory) {
            if (stack.m_41619_()) continue;
            drops.add((Object)stack);
        }
        return drops;
    }

    public int[] m_7071_(Direction side) {
        Direction direction = this.getFacingDirection();
        if (side == direction || side == direction.m_122424_()) {
            return new int[0];
        }
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    }

    public boolean m_7155_(int index, ItemStack itemStackIn, Direction direction) {
        return true;
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return true;
    }

    @Override
    public boolean canConnectRedstone() {
        return true;
    }

    public boolean m_7983_() {
        return this.inventory.size() == 0;
    }

    public void m_6211_() {
    }

    @Override
    public void onButtonPress(Player player, int messageId, int value) {
        if (messageId == 0) {
            this.filterColor = IPneumaticTube.TubeColor.values()[value];
        }
        if (messageId == 1) {
            this.fuzzySetting = value;
        }
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"filter");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player playerEntity) {
        return new ContainerFilter(id, inventory, (Container)this);
    }
}

