/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile.tier1;

import com.bluepowermod.BluePower;
import com.bluepowermod.block.BlockContainerFacingBase;
import com.bluepowermod.container.ContainerDeployer;
import com.bluepowermod.helper.IOHelper;
import com.bluepowermod.init.BPBlockEntityType;
import com.bluepowermod.tile.IEjectAnimator;
import com.bluepowermod.tile.TileBase;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class TileDeployer
extends TileBase
implements WorldlyContainer,
IEjectAnimator,
MenuProvider {
    private static final List<Item> blacklistedItems = new ArrayList<Item>();
    private static final GameProfile FAKE_PLAYER_PROFILE = new GameProfile(UUID.randomUUID(), "[BP Deployer]");
    public static final int SLOTS = 10;
    private final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)10, (Object)ItemStack.f_41583_);

    public TileDeployer(BlockPos pos, BlockState state) {
        super((BlockEntityType)BPBlockEntityType.DEPLOYER.get(), pos, state);
    }

    private boolean canDeployItem(ItemStack stack) {
        return !stack.m_41619_() && !blacklistedItems.contains(stack.m_41720_());
    }

    @Override
    protected void redstoneChanged(boolean newValue) {
        super.redstoneChanged(newValue);
        if (!this.f_58857_.f_46443_ && newValue) {
            ItemStack stack;
            int i;
            this.sendUpdatePacket();
            FakePlayer player = FakePlayerFactory.get((ServerLevel)((ServerLevel)this.f_58857_), (GameProfile)FAKE_PLAYER_PROFILE);
            for (i = 0; i < this.inventory.size(); ++i) {
                stack = (ItemStack)this.inventory.get(i);
                player.m_150109_().m_6836_(i, stack);
            }
            this.rightClick(player, 9);
            for (i = 0; i < this.inventory.size(); ++i) {
                stack = player.m_150109_().m_8020_(i);
                if (stack.m_41619_() || stack.m_41613_() <= 0) {
                    this.inventory.set(i, (Object)ItemStack.f_41583_);
                } else {
                    this.inventory.set(i, (Object)stack);
                }
                player.m_150109_().m_6836_(i, ItemStack.f_41583_);
            }
            for (i = 0; i < player.m_150109_().m_6643_(); ++i) {
                stack = player.m_150109_().m_8020_(i);
                if (stack.m_41619_() || stack.m_41613_() <= 0) continue;
                ItemStack remainder = IOHelper.insert(this, stack, this.getFacingDirection().m_122424_(), false);
                if (!remainder.m_41619_()) {
                    this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, remainder));
                }
                player.m_150109_().m_6836_(i, ItemStack.f_41583_);
            }
        }
    }

    protected boolean rightClick(FakePlayer player, int useItems) {
        if (useItems > 9) {
            throw new IllegalArgumentException("Hotbar is 9 items in width! You're trying " + useItems + "!");
        }
        Direction faceDir = this.getFacingDirection();
        int dx = faceDir.m_122429_();
        int dy = faceDir.m_122430_();
        int dz = faceDir.m_122431_();
        int x = this.f_58858_.m_123341_() + dx;
        int y = this.f_58858_.m_123342_() + dy;
        int z = this.f_58858_.m_123343_() + dz;
        player.m_6034_((double)x + 0.5, (double)y + 0.5 - (double)player.m_20192_(), (double)z + 0.5);
        player.m_146926_((float)(faceDir.m_122430_() * -90));
        switch (faceDir) {
            case NORTH: {
                player.m_146922_(180.0f);
                break;
            }
            case SOUTH: {
                player.m_146922_(0.0f);
                break;
            }
            case WEST: {
                player.m_146922_(90.0f);
                break;
            }
            case EAST: {
                player.m_146922_(-90.0f);
            }
        }
        try {
            ItemStack stack;
            int i;
            Entity entity;
            PlayerInteractEvent.RightClickEmpty event = new PlayerInteractEvent.RightClickEmpty((Player)player, InteractionHand.MAIN_HAND);
            if (event.isCanceled()) {
                return false;
            }
            Block block = this.f_58857_.m_8055_(new BlockPos(x, y, z)).m_60734_();
            List detectedEntities = this.f_58857_.m_45976_(LivingEntity.class, new AABB((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)));
            Entity entity2 = entity = detectedEntities.isEmpty() ? null : (Entity)detectedEntities.get(this.f_58857_.f_46441_.m_188503_(detectedEntities.size()));
            if (entity != null) {
                for (i = 0; i < useItems; ++i) {
                    player.m_150109_().f_35977_ = i;
                    stack = player.m_21205_();
                    if (this.canDeployItem(stack) && stack.m_41720_().m_6880_(stack, (Player)player, (LivingEntity)entity, InteractionHand.MAIN_HAND).m_19080_()) {
                        return true;
                    }
                    if (!(entity instanceof Animal) || !((Animal)entity).m_6071_((Player)player, InteractionHand.MAIN_HAND).m_19080_()) continue;
                    return true;
                }
            }
            for (i = 0; i < useItems; ++i) {
                player.m_150109_().f_35977_ = i;
                stack = player.m_21205_();
                if (!this.canDeployItem(stack) || stack.m_41720_().onItemUseFirst(stack, new UseOnContext((Player)player, InteractionHand.MAIN_HAND, new BlockHitResult(new Vec3((double)dx, (double)dy, (double)dz), faceDir, new BlockPos(x, y, z), false))) != InteractionResult.SUCCESS) continue;
                return true;
            }
            for (i = 0; i < useItems; ++i) {
                player.m_150109_().f_35977_ = i;
                if (this.f_58857_.m_46859_(new BlockPos(x, y, z)) || block.m_6227_(this.f_58857_.m_8055_(new BlockPos(x, y, z)), this.f_58857_, new BlockPos(x, y, z), (Player)player, InteractionHand.MAIN_HAND, new BlockHitResult(new Vec3((double)dx, (double)dy, (double)dz), faceDir, new BlockPos(x, y, z), false)) != InteractionResult.SUCCESS) continue;
                return true;
            }
            for (i = 0; i < useItems; ++i) {
                int useZ;
                player.m_150109_().f_35977_ = i;
                stack = player.m_21205_();
                boolean isGoingToShift = false;
                if (!(stack.m_41619_() || stack.m_41720_() != Items.f_41909_ && stack.m_41720_() != Items.f_42451_)) {
                    isGoingToShift = true;
                }
                int useX = isGoingToShift ? this.f_58858_.m_123341_() : x;
                int useY = isGoingToShift ? this.f_58858_.m_123342_() : y;
                int n = useZ = isGoingToShift ? this.f_58858_.m_123343_() : z;
                if (!this.canDeployItem(stack) || stack.m_41720_().m_6225_(new UseOnContext((Player)player, InteractionHand.MAIN_HAND, new BlockHitResult(new Vec3((double)dx, (double)dy, (double)dz), faceDir, new BlockPos(x, y, z), false))) != InteractionResult.SUCCESS) continue;
                return true;
            }
            for (i = 0; i < useItems; ++i) {
                player.m_150109_().f_35977_ = i;
                stack = player.m_21205_();
                if (!this.canDeployItem(stack)) continue;
                ItemStack copy = stack.m_41777_();
                player.m_21008_(InteractionHand.MAIN_HAND, (ItemStack)stack.m_41720_().m_7203_(this.f_58857_, (Player)player, InteractionHand.MAIN_HAND).m_19095_());
                if (copy.m_41656_(stack)) continue;
                return true;
            }
            return false;
        }
        catch (Throwable e) {
            BluePower.log.error("Deployer crashed! Stacktrace: ");
            e.printStackTrace();
            return true;
        }
    }

    @Override
    public void m_142466_(CompoundTag tCompound) {
        super.m_142466_(tCompound);
        for (int i = 0; i < 9; ++i) {
            CompoundTag tc = tCompound.m_128469_("inventory" + i);
            this.inventory.set(i, (Object)ItemStack.m_41712_((CompoundTag)tc));
        }
    }

    @Override
    protected void m_183515_(CompoundTag tCompound) {
        super.m_183515_(tCompound);
        for (int i = 0; i < 9; ++i) {
            CompoundTag tc = new CompoundTag();
            ((ItemStack)this.inventory.get(i)).m_41739_(tc);
            tCompound.m_128365_("inventory" + i, (Tag)tc);
        }
    }

    public int m_6643_() {
        return this.inventory.size();
    }

    public ItemStack m_8020_(int i) {
        return (ItemStack)this.inventory.get(i);
    }

    public ItemStack m_7407_(int slot, int amount) {
        ItemStack itemStack = this.m_8020_(slot);
        if (!itemStack.m_41619_()) {
            if (itemStack.m_41613_() <= amount) {
                this.m_6836_(slot, ItemStack.f_41583_);
            } else if ((itemStack = itemStack.m_41620_(amount)).m_41613_() == 0) {
                this.m_6836_(slot, ItemStack.f_41583_);
            }
        }
        return itemStack;
    }

    public ItemStack m_8016_(int i) {
        return this.m_8020_(i);
    }

    public void m_6836_(int i, ItemStack itemStack) {
        this.inventory.set(i, (Object)itemStack);
    }

    public int m_6893_() {
        return 64;
    }

    public boolean m_6542_(Player player) {
        return player.m_20183_().m_123314_((Vec3i)this.f_58858_, 64.0);
    }

    public void m_5856_(Player player) {
    }

    public void m_5785_(Player player) {
    }

    public boolean m_7013_(int i, ItemStack itemStack) {
        return true;
    }

    @Override
    public NonNullList<ItemStack> getDrops() {
        NonNullList<ItemStack> drops = super.getDrops();
        for (ItemStack stack : this.inventory) {
            if (stack.m_41619_()) continue;
            drops.add((Object)stack);
        }
        return drops;
    }

    public int[] m_7071_(Direction side) {
        Direction direction = this.getFacingDirection();
        if (side == direction) {
            return new int[0];
        }
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    }

    public boolean m_7155_(int index, ItemStack itemStackIn, Direction direction) {
        for (int i : this.m_7071_(direction)) {
            if (index != i) continue;
            return true;
        }
        return false;
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        for (int i : this.m_7071_(direction)) {
            if (index != i) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEjecting() {
        return (Boolean)this.m_58900_().m_61143_((Property)BlockContainerFacingBase.ACTIVE);
    }

    @Override
    public boolean canConnectRedstone() {
        return true;
    }

    public boolean m_7983_() {
        return this.inventory.size() == 0;
    }

    public void m_6211_() {
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"deployer");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player playerEntity) {
        return new ContainerDeployer(id, inventory, (Container)this);
    }

    static {
        blacklistedItems.add(Items.f_42584_);
    }
}

