/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile;

import com.bluepowermod.api.multipart.IBPPartBlock;
import com.bluepowermod.init.BPBlockEntityType;
import com.bluepowermod.tile.tier1.TileWire;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class TileBPMultipart
extends BlockEntity {
    public static final ModelProperty<Map<BlockState, ModelData>> STATE_INFO = new ModelProperty();
    private Map<BlockState, BlockEntity> stateMap = new HashMap<BlockState, BlockEntity>();

    public TileBPMultipart(BlockPos pos, BlockState state) {
        super((BlockEntityType)BPBlockEntityType.MULTIPART.get(), pos, state);
    }

    @Nonnull
    public ModelData getModelData() {
        Map<BlockState, ModelData> modelDataMap = this.stateMap.keySet().stream().filter(BlockBehaviour.BlockStateBase::m_155947_).collect(Collectors.toMap(s -> s, this::getModelData));
        this.stateMap.keySet().stream().filter(s -> !s.m_155947_()).forEach(s -> modelDataMap.put((BlockState)s, (ModelData)null));
        return ModelData.builder().with(STATE_INFO, modelDataMap).build();
    }

    private ModelData getModelData(BlockState state) {
        BlockEntity tileEntity = this.stateMap.get(state);
        if (tileEntity != null) {
            if (tileEntity instanceof TileWire) {
                return ((TileWire)tileEntity).getModelData(state);
            }
            return tileEntity.getModelData();
        }
        return ModelData.EMPTY;
    }

    public void addState(BlockState state) {
        BlockEntity tile = ((EntityBlock)state.m_60734_()).m_142194_(this.f_58858_, state);
        this.stateMap.put(state, tile);
        state.m_60734_().m_6402_(this.f_58857_, this.f_58858_, state, null, new ItemStack((ItemLike)state.m_60734_()));
        this.markDirtyClient();
    }

    public void removeState(BlockState state) {
        if (this.f_58857_ instanceof ServerLevel) {
            NonNullList drops = NonNullList.m_122779_();
            drops.addAll((Collection)Block.m_49869_((BlockState)state, (ServerLevel)((ServerLevel)this.f_58857_), (BlockPos)this.f_58858_, (BlockEntity)this));
            Containers.m_19010_((Level)this.f_58857_, (BlockPos)this.f_58858_, (NonNullList)drops);
        }
        if (this.stateMap.get(state) != null) {
            this.stateMap.get(state).m_7651_();
        }
        this.stateMap.remove(state);
        this.markDirtyClient();
        if (this.stateMap.size() == 1) {
            BlockEntity te = (BlockEntity)this.stateMap.values().toArray()[0];
            if (this.f_58857_ != null) {
                CompoundTag nbt = te != null ? te.m_187482_() : null;
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.stateMap.keySet().toArray()[0]);
                BlockEntity tile = this.f_58857_.m_7702_(this.f_58858_);
                if (tile != null && nbt != null) {
                    tile.m_142466_(nbt);
                }
            }
        } else if (this.stateMap.size() == 0 && this.f_58857_ != null) {
            this.f_58857_.m_7471_(this.f_58858_, false);
        }
        if (this.f_58857_ != null) {
            this.f_58857_.m_8055_(this.f_58858_).m_60690_(this.f_58857_, this.f_58858_, this.m_58900_().m_60734_(), this.f_58858_, false);
        }
    }

    public BlockEntity getTileForState(BlockState state) {
        return this.stateMap.get(state);
    }

    public void m_142339_(Level levelIn) {
        super.m_142339_(levelIn);
        this.stateMap.values().forEach(t -> t.m_142339_(levelIn));
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.isSideBlocked(cap, side).booleanValue()) {
            return LazyOptional.empty();
        }
        List capability = this.stateMap.values().stream().filter(Objects::nonNull).map(t -> t.getCapability(cap, side)).filter(LazyOptional::isPresent).collect(Collectors.toList());
        return capability.size() > 0 ? (LazyOptional)capability.get(0) : LazyOptional.empty();
    }

    public Boolean isSideBlocked(@Nonnull Capability cap, @Nullable Direction side) {
        return this.stateMap.keySet().stream().filter(s -> s.m_60734_() instanceof IBPPartBlock).anyMatch(s -> ((IBPPartBlock)s.m_60734_()).blockCapability((BlockState)s, cap, side));
    }

    public List<BlockState> getStates() {
        return new ArrayList<BlockState>(this.stateMap.keySet());
    }

    private void markDirtyClient() {
        this.m_6596_();
        if (this.m_58904_() != null) {
            BlockState state = this.m_58904_().m_8055_(this.m_58899_());
            this.m_58904_().m_7260_(this.m_58899_(), state, state, 3);
        }
        this.requestModelDataUpdate();
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("size", this.getStates().size());
        for (int i = 0; i < this.getStates().size(); ++i) {
            String stateSave = "state" + i;
            BlockState.f_61039_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.getStates().get(i)).result().ifPresent(nbt -> compound.m_128365_(stateSave, nbt));
            if (this.stateMap.get(this.getStates().get(i)) == null) continue;
            compound.m_128365_("tile" + i, (Tag)this.stateMap.get(this.getStates().get(i)).m_187482_());
        }
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        HashMap<BlockState, BlockEntity> states = new HashMap<BlockState, BlockEntity>();
        int size = compound.m_128451_("size");
        for (int i = 0; i < size; ++i) {
            Optional result = BlockState.f_61039_.decode(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)compound.m_128423_("state" + i))).result();
            if (!result.isPresent()) continue;
            BlockState state = (BlockState)((Pair)result.get()).getFirst();
            BlockEntity tile = ((EntityBlock)state.m_60734_()).m_142194_(this.f_58858_, state);
            if (tile != null) {
                tile.m_142466_(compound.m_128469_("tile" + i));
            }
            states.put(state, tile);
        }
        this.stateMap = states;
        this.markDirtyClient();
    }

    public CompoundTag m_5995_() {
        CompoundTag updateTag = super.m_5995_();
        this.m_183515_(updateTag);
        return updateTag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection networkManager, ClientboundBlockEntityDataPacket packet) {
        List<BlockState> states = this.getStates();
        CompoundTag tagCompound = packet.m_131708_();
        super.onDataPacket(networkManager, packet);
        this.m_142466_(tagCompound);
        if (this.f_58857_.f_46443_ && !this.getStates().equals(states)) {
            this.f_58857_.m_151543_(this.m_58899_());
        }
    }

    public void changeState(BlockState state, BlockState newState) {
        BlockEntity te = this.stateMap.get(state);
        this.stateMap.remove(state);
        this.stateMap.put(newState, te);
        this.markDirtyClient();
    }

    public static void tickMultipart(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        TileBPMultipart multipart = (TileBPMultipart)blockEntity;
        multipart.stateMap.values().stream().filter(t -> t instanceof TickingBlockEntity).forEach(t -> ((TickingBlockEntity)t).m_142224_());
    }
}

