/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.recipe;

import com.bluepowermod.api.recipe.IAlloyFurnaceRecipe;
import com.bluepowermod.init.BPRecipeSerializer;
import com.bluepowermod.init.BPRecipeTypes;
import com.bluepowermod.recipe.AlloyFurnaceRegistry;
import com.google.gson.JsonObject;
import java.util.HashSet;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class AlloyFurnaceRecyclingRecipe
implements IAlloyFurnaceRecipe {
    private final ResourceLocation id;

    public AlloyFurnaceRecyclingRecipe(ResourceLocation idIn) {
        this.id = idIn;
    }

    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)BPRecipeTypes.ALLOY_SMELTING.get();
    }

    public boolean matches(WorldlyContainer inv, Level world) {
        HashSet<Item> blacklist = new HashSet<Item>(AlloyFurnaceRegistry.getInstance().blacklist);
        if (inv.m_18949_(blacklist)) {
            return false;
        }
        return inv.m_18949_(AlloyFurnaceRegistry.getInstance().recyclingRecipes.keySet());
    }

    public ItemStack assemble(WorldlyContainer inv) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)BPRecipeSerializer.ALLOY_RECYCLING.get();
    }

    @Override
    public boolean matches(NonNullList<ItemStack> input) {
        return false;
    }

    @Override
    public boolean useItems(NonNullList<ItemStack> itemStacks, RecipeManager manager) {
        HashSet<Item> blacklist = new HashSet<Item>(AlloyFurnaceRegistry.getInstance().blacklist);
        if (itemStacks.stream().anyMatch(itemStack -> blacklist.contains(itemStack.m_41720_()))) {
            return false;
        }
        for (ItemStack itemStack2 : itemStacks) {
            if (!AlloyFurnaceRegistry.getInstance().recyclingRecipes.containsKey(itemStack2.m_41720_())) continue;
            itemStack2.m_41764_(itemStack2.m_41613_() - 1);
            return true;
        }
        return false;
    }

    @Override
    public ItemStack assemble(NonNullList<ItemStack> itemStacks, RecipeManager manager) {
        HashSet<Item> blacklist = new HashSet<Item>(AlloyFurnaceRegistry.getInstance().blacklist);
        if (itemStacks.stream().anyMatch(itemStack -> blacklist.contains(itemStack.m_41720_()))) {
            return ItemStack.f_41583_;
        }
        for (ItemStack itemStack2 : itemStacks) {
            if (!AlloyFurnaceRegistry.getInstance().recyclingRecipes.containsKey(itemStack2.m_41720_())) continue;
            return AlloyFurnaceRegistry.getInstance().recyclingRecipes.get(itemStack2.m_41720_());
        }
        return ItemStack.f_41583_;
    }

    @Override
    public NonNullList<Ingredient> getRequiredItems() {
        return null;
    }

    @Override
    public NonNullList<Integer> getRequiredCount() {
        return null;
    }

    public static class Serializer
    implements RecipeSerializer<AlloyFurnaceRecyclingRecipe> {
        public AlloyFurnaceRecyclingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            return new AlloyFurnaceRecyclingRecipe(recipeId);
        }

        public AlloyFurnaceRecyclingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            return new AlloyFurnaceRecyclingRecipe(recipeId);
        }

        public void toNetwork(FriendlyByteBuf buffer, AlloyFurnaceRecyclingRecipe recipe) {
        }
    }
}

