/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.helper;

import com.bluepowermod.BluePower;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemStackDatabase {
    private static final String FILE_EXTENSION = ".cdf";
    private static final String DATABASE_FOLDER_NAME = "bluepower" + File.separator + "circuitDatabase" + File.separator;
    private final String saveLocation = BluePower.proxy.getSavePath() + File.separator + DATABASE_FOLDER_NAME;
    private List<ItemStack> cache;

    public void saveItemStack(ItemStack stack) {
        new File(this.saveLocation).mkdirs();
        File targetRegistryName = new File(this.saveLocation + stack.m_41611_() + FILE_EXTENSION);
        CompoundTag tag = new CompoundTag();
        stack.m_41739_(tag);
        ResourceLocation ui = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        tag.m_128359_("owner", ui.m_135827_());
        tag.m_128359_("name", ui.m_135815_());
        try {
            FileOutputStream fos = new FileOutputStream(targetRegistryName);
            DataOutputStream dos = new DataOutputStream(fos);
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            NbtIo.m_128947_((CompoundTag)tag, (OutputStream)byteStream);
            byte[] abyte = byteStream.toByteArray();
            dos.writeShort((short)abyte.length);
            dos.write(abyte);
            dos.close();
        }
        catch (IOException e) {
            BluePower.log.error("IOException when trying to save an ItemStack in the database: " + e);
        }
        this.cache = null;
    }

    public void deleteStack(ItemStack deletingStack) {
        File targetRegistryName = new File(this.saveLocation);
        if (targetRegistryName.exists()) {
            File[] files;
            for (File file : files = targetRegistryName.listFiles()) {
                if (!deletingStack.m_41611_().equals(file.getName().substring(0, file.getName().length() - 4))) continue;
                file.delete();
                this.cache = null;
                return;
            }
        }
    }

    public List<ItemStack> loadItemStacks() {
        if (this.cache == null) {
            File targetRegistryName = new File(this.saveLocation);
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            if (targetRegistryName.exists()) {
                File[] files;
                for (File file : files = targetRegistryName.listFiles()) {
                    try {
                        FileInputStream fos = new FileInputStream(file);
                        DataInputStream dos = new DataInputStream(fos);
                        short short1 = dos.readShort();
                        byte[] abyte = new byte[short1];
                        dos.read(abyte);
                        ByteArrayInputStream byteStream = new ByteArrayInputStream(abyte);
                        CompoundTag tag = NbtIo.m_128939_((InputStream)byteStream);
                        ItemStack stack = ItemStack.m_41712_((CompoundTag)tag);
                        if (stack.m_41720_() != Items.f_41852_) {
                            stacks.add(stack);
                        } else {
                            BluePower.log.error("Couldn't retrieve an itemstack with item id: " + tag.m_128448_("id"));
                            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(tag.m_128461_("owner"), tag.m_128461_("name")));
                            if (item != null && item != Items.f_41852_) {
                                ItemStack backupStack = new ItemStack((ItemLike)item, stack.m_41613_());
                                backupStack.m_41721_((int)tag.m_128448_("Damage"));
                                if (stack.m_41782_()) {
                                    backupStack.m_41751_(stack.m_41783_());
                                }
                                stacks.add(backupStack);
                                BluePower.log.info("Successfully retrieved stack via its name: " + tag.m_128461_("owner") + ":" + tag.m_128461_("name"));
                            } else {
                                BluePower.log.error("Couldn't retrieve the item via its name: " + tag.m_128461_("owner") + ":" + tag.m_128461_("name"));
                            }
                        }
                        dos.close();
                    }
                    catch (IOException e) {
                        BluePower.log.error("Exception : " + e);
                    }
                }
            }
            this.cache = stacks;
        }
        return this.cache;
    }
}

