/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.container.stack;

import com.bluepowermod.api.tube.IPneumaticTube;
import com.bluepowermod.client.render.RenderHelper;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

public class TubeStack {
    public ItemStack stack;
    public final IPneumaticTube.TubeColor color;
    public double progress;
    public double oldProgress;
    public Direction heading;
    public boolean enabled = true;
    public int idleCounter;
    private BlockEntity target;
    private int targetX;
    private int targetY;
    private int targetZ;
    public static final double ITEM_SPEED = 0.0625;
    private double speed = 0.0625;
    public static double tickTimeMultiplier = 1.0;
    @OnlyIn(value=Dist.CLIENT)
    private static ItemRenderer customRenderItem;
    private static ItemEntity renderedItem;
    public static RenderMode renderMode;

    public TubeStack(ItemStack stack, Direction from) {
        this(stack, from, IPneumaticTube.TubeColor.NONE);
    }

    public TubeStack(ItemStack stack, Direction from, IPneumaticTube.TubeColor color) {
        this.heading = from;
        this.stack = stack;
        this.color = color;
    }

    public void setSpeed(double speed) {
        this.speed = speed;
    }

    public double getSpeed() {
        return this.speed;
    }

    public boolean update(Level worldObj) {
        this.oldProgress = this.progress;
        if (this.enabled) {
            boolean isEntering = this.progress < 0.5;
            this.progress += this.speed * (worldObj.f_46443_ ? tickTimeMultiplier : 1.0);
            return this.progress >= 0.5 && isEntering;
        }
        ++this.idleCounter;
        return false;
    }

    public BlockEntity getTarget(Level world) {
        if (this.target == null && (this.targetX != 0 || this.targetY != 0 || this.targetZ != 0)) {
            this.target = world.m_7702_(new BlockPos(this.targetX, this.targetY, this.targetZ));
        }
        return this.target;
    }

    public void setTarget(BlockEntity tileEntity) {
        this.target = tileEntity;
        if (this.target != null) {
            this.targetX = this.target.m_58899_().m_123341_();
            this.targetY = this.target.m_58899_().m_123342_();
            this.targetZ = this.target.m_58899_().m_123343_();
        } else {
            this.targetX = 0;
            this.targetY = 0;
            this.targetZ = 0;
        }
    }

    public TubeStack copy() {
        CompoundTag tag = new CompoundTag();
        this.writeToNBT(tag);
        return TubeStack.loadFromNBT(tag);
    }

    public void writeToNBT(CompoundTag tag) {
        this.stack.m_41739_(tag);
        tag.m_128344_("color", (byte)this.color.ordinal());
        tag.m_128344_("heading", (byte)this.heading.ordinal());
        tag.m_128347_("progress", this.progress);
        tag.m_128347_("speed", this.speed);
        tag.m_128405_("targetX", this.targetX);
        tag.m_128405_("targetY", this.targetY);
        tag.m_128405_("targetZ", this.targetZ);
    }

    public static TubeStack loadFromNBT(CompoundTag tag) {
        TubeStack stack = new TubeStack(ItemStack.m_41712_((CompoundTag)tag), Direction.m_122376_((int)tag.m_128445_("heading")), IPneumaticTube.TubeColor.values()[tag.m_128445_("color")]);
        stack.progress = tag.m_128459_("progress");
        stack.speed = tag.m_128459_("speed");
        stack.targetX = tag.m_128451_("targetX");
        stack.targetY = tag.m_128451_("targetY");
        stack.targetZ = tag.m_128451_("targetZ");
        return stack;
    }

    public void writeToPacket(ByteBuf buf) {
        buf.writeByte(this.heading.ordinal());
        buf.writeByte((int)((byte)this.color.ordinal()));
        buf.writeDouble(this.speed);
        buf.writeDouble(this.progress);
    }

    public static TubeStack loadFromPacket(ByteBuf buf) {
        TubeStack stack = new TubeStack(null, Direction.m_122376_((int)buf.readByte()), IPneumaticTube.TubeColor.values()[buf.readByte()]);
        stack.speed = buf.readDouble();
        stack.progress = buf.readDouble();
        return stack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(float partialTick) {
        float size;
        if (renderMode == RenderMode.AUTO) {
            renderMode = Minecraft.m_91087_().f_91066_.m_232060_().m_231551_() == GraphicsStatus.FANCY ? RenderMode.NORMAL : RenderMode.REDUCED;
        }
        RenderMode finalRenderMode = renderMode;
        if (customRenderItem == null) {
            customRenderItem = Minecraft.m_91087_().m_91291_();
            renderedItem = new ItemEntity((Level)Minecraft.m_91087_().f_91073_, 0.0, 0.0, 0.0, ItemStack.f_41583_);
        }
        double renderProgress = (this.oldProgress + (this.progress - this.oldProgress) * (double)partialTick) * 2.0 - 1.0;
        GL11.glPushMatrix();
        GL11.glTranslated((double)((double)this.heading.m_122429_() * renderProgress * 0.5), (double)((double)this.heading.m_122430_() * renderProgress * 0.5), (double)((double)this.heading.m_122431_() * renderProgress * 0.5));
        if (finalRenderMode != RenderMode.NONE) {
            GL11.glPushMatrix();
            if (this.stack.m_41613_() > 5) {
                GL11.glScaled((double)0.8, (double)0.8, (double)0.8);
            }
            if (!(this.stack.m_41720_() instanceof BlockItem)) {
                GL11.glScaled((double)0.8, (double)0.8, (double)0.8);
                GL11.glTranslated((double)0.0, (double)-0.15, (double)0.0);
            }
            GL11.glPopMatrix();
        } else {
            size = 0.02f;
            GL11.glDisable((int)3553);
            GL11.glBegin((int)7);
            RenderHelper.drawColoredCube(new AABB((double)(-size), (double)(-size), (double)(-size), (double)size, (double)size, (double)size), 1.0, 1.0, 1.0, 1.0, new boolean[0]);
            GL11.glEnd();
            GL11.glEnable((int)3553);
        }
        if (this.color != IPneumaticTube.TubeColor.NONE) {
            size = 0.2f;
            int colorInt = DyeColor.values()[this.color.ordinal()].m_41060_();
            float red = (float)(colorInt >> 16) / 256.0f;
            float green = (float)(colorInt >> 8 & 0xFF) / 256.0f;
            float blue = (float)(colorInt & 0xFF) / 256.0f;
            GL11.glDisable((int)2884);
            GL11.glDisable((int)2896);
            GL11.glColor3f((float)red, (float)green, (float)blue);
            RenderHelper.drawTesselatedTexturedCube(new AABB((double)(-size), (double)(-size), (double)(-size), (double)size, (double)size, (double)size));
            GL11.glEnable((int)2884);
            GL11.glEnable((int)2896);
        }
        GL11.glPopMatrix();
    }

    public static enum RenderMode {
        AUTO,
        NORMAL,
        REDUCED,
        NONE;

    }
}

