/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.client.gui.widget;

import com.bluepowermod.client.gui.widget.IGuiWidget;
import com.bluepowermod.client.gui.widget.IWidgetListener;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Rectangle;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public class BaseWidget
implements IGuiWidget {
    private final int id;
    public int value;
    protected final int x;
    protected final int y;
    protected final int width;
    protected final int height;
    private final int textureU;
    private final int textureV;
    protected final ResourceLocation[] textures;
    protected int textureIndex = 0;
    protected IWidgetListener gui;
    public boolean enabled = true;

    public BaseWidget(int id, int x, int y, int width, int height, String ... textureLocs) {
        this(id, x, y, width, height, 0, 0, textureLocs);
    }

    public BaseWidget(int id, int x, int y, int width, int height, int textureU, int textureV, String ... textureLocs) {
        this.id = id;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.textureU = textureU;
        this.textureV = textureV;
        this.textures = new ResourceLocation[textureLocs.length];
        for (int i = 0; i < this.textures.length; ++i) {
            this.textures[i] = new ResourceLocation(textureLocs[i]);
        }
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public void setListener(IWidgetListener gui) {
        this.gui = gui;
    }

    @Override
    public void render(PoseStack matrixStack, int mouseX, int mouseY, float partialTick) {
        if (this.enabled) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            RenderSystem.m_157429_((float)0.2f, (float)0.2f, (float)0.2f, (float)1.0f);
        }
        if (this.textures.length > 0) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.textures[this.textureIndex]);
        }
        GuiComponent.m_93133_((PoseStack)matrixStack, (int)this.x, (int)this.y, (float)this.getTextureU(), (float)this.getTextureV(), (int)this.width, (int)this.height, (int)this.getTextureWidth(), (int)this.getTextureHeight());
    }

    protected int getTextureU() {
        return this.textureU;
    }

    protected int getTextureV() {
        return this.textureV;
    }

    protected int getTextureWidth() {
        return this.width;
    }

    protected int getTextureHeight() {
        return this.height;
    }

    @Override
    public void onMouseClicked(int mouseX, int mouseY, int button) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
        this.gui.actionPerformed(this);
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    @Override
    public void addTooltip(int mouseX, int mouseY, List<String> curTip, boolean shiftPressed) {
    }

    @Override
    public void update() {
    }
}

