/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.block;

import com.bluepowermod.api.multipart.IBPPartBlock;
import com.bluepowermod.init.BPBlocks;
import com.bluepowermod.tile.TileBPMicroblock;
import com.bluepowermod.tile.TileBPMultipart;
import com.bluepowermod.util.AABBUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockBPMicroblock
extends BaseEntityBlock
implements IBPPartBlock,
SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private final VoxelShape size;

    public BlockBPMicroblock(VoxelShape size) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60955_().m_60978_(2.0f));
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.size = size;
        BPBlocks.blockList.add((Block)this);
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        BlockEntity tileentity = (BlockEntity)builder.m_78970_(LootContextParams.f_81462_);
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        if (tileentity instanceof TileBPMultipart) {
            tileentity = ((TileBPMultipart)tileentity).getTileForState(state);
        }
        if (tileentity instanceof TileBPMicroblock) {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("block", ForgeRegistries.BLOCKS.getKey((Object)((TileBPMicroblock)tileentity).getBlock()).toString());
            ItemStack stack = new ItemStack((ItemLike)this);
            stack.m_41751_(nbt);
            stack.m_41714_((Component)Component.m_237115_((String)((TileBPMicroblock)tileentity).getBlock().m_7705_()).m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)Component.m_237115_((String)this.m_7705_())));
            itemStacks.add(stack);
        }
        return itemStacks;
    }

    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        BlockEntity tileentity = world.m_7702_(pos);
        ItemStack stack = ItemStack.f_41583_;
        if (tileentity instanceof TileBPMultipart) {
            tileentity = ((TileBPMultipart)tileentity).getTileForState(state);
        }
        if (tileentity instanceof TileBPMicroblock) {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("block", ForgeRegistries.BLOCKS.getKey((Object)((TileBPMicroblock)tileentity).getBlock()).toString());
            stack = new ItemStack((ItemLike)this);
            stack.m_41751_(nbt);
            stack.m_41714_((Component)Component.m_237115_((String)((TileBPMicroblock)tileentity).getBlock().m_7705_()).m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)Component.m_237115_((String)this.m_7705_())));
        }
        return stack;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return AABBUtils.rotate(this.size, (Direction)state.m_61143_((Property)FACING));
    }

    public VoxelShape getSize() {
        return this.size;
    }

    @Override
    public Boolean blockCapability(BlockState state, Capability capability, @Nullable Direction side) {
        return side == ((Direction)state.m_61143_((Property)FACING)).m_122424_();
    }

    @Override
    public VoxelShape getOcclusionShape(BlockState state) {
        AABB aabb = this.size.m_83215_();
        return AABBUtils.rotate(Block.m_49796_((double)3.0, (double)(aabb.f_82289_ * 16.0), (double)3.0, (double)13.0, (double)aabb.f_82292_, (double)13.0), (Direction)state.m_61143_((Property)FACING));
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Player player = context.m_43723_();
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        if (player != null && !player.m_6047_()) {
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_43719_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
        }
        Vec3 vec = context.m_43723_().m_20154_();
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.m_122366_((double)vec.f_82479_, (double)vec.f_82480_, (double)vec.f_82481_))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileBPMicroblock(pos, state);
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        BlockEntity tileentity = worldIn.m_7702_(pos);
        if (tileentity instanceof TileBPMicroblock && stack.m_41782_() && stack.m_41783_().m_128441_("block")) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(stack.m_41783_().m_128461_("block")));
            ((TileBPMicroblock)tileentity).setBlock(block);
        } else if (tileentity instanceof TileBPMultipart && stack.m_41782_() && stack.m_41783_().m_128441_("block")) {
            TileBPMicroblock tile = (TileBPMicroblock)((TileBPMultipart)tileentity).getTileForState(state);
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(stack.m_41783_().m_128461_("block")));
            tile.setBlock(block);
        }
    }
}

