/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.common.EventHandler;
import blusunrize.immersiveengineering.mixin.accessors.ExplosionAccess;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class IEExplosion
extends Explosion {
    public float dropChance = 1.0f;
    private int blockDestroyInt = 0;
    public int blocksPerTick = 8;
    public boolean isExplosionFinished = false;
    private final Level world;
    private final float size;
    private final Explosion.BlockInteraction damagesTerrain;

    public IEExplosion(Level world, Entity igniter, double x, double y, double z, float size, boolean isFlaming, Explosion.BlockInteraction damageTerrain) {
        super(world, igniter, null, null, x, y, z, size, isFlaming, damageTerrain);
        this.dropChance = 1.0f / size;
        this.world = world;
        this.damagesTerrain = damageTerrain;
        this.size = size;
    }

    public IEExplosion setDropChance(float chance) {
        this.dropChance = chance;
        return this;
    }

    public void doExplosionTick() {
        ObjectArrayList objectarraylist = new ObjectArrayList();
        int max = Math.min(this.blockDestroyInt + this.blocksPerTick, this.m_46081_().size());
        while (this.blockDestroyInt < max) {
            BlockPos pos = (BlockPos)this.m_46081_().get(this.blockDestroyInt);
            BlockState state = this.world.m_8055_(pos);
            Block block = state.m_60734_();
            double d0 = (float)pos.m_123341_() + ApiUtils.RANDOM.nextFloat();
            double d1 = (float)pos.m_123342_() + ApiUtils.RANDOM.nextFloat();
            double d2 = (float)pos.m_123343_() + ApiUtils.RANDOM.nextFloat();
            double d3 = d0 - this.getPosition().f_82479_;
            double d4 = d1 - this.getPosition().f_82480_;
            double d5 = d2 - this.getPosition().f_82481_;
            double d6 = Mth.m_14116_((float)((float)(d3 * d3 + d4 * d4 + d5 * d5)));
            d3 /= d6;
            d4 /= d6;
            d5 /= d6;
            double d7 = 0.5 / (d6 / (double)this.size + 0.1);
            this.world.m_7106_((ParticleOptions)ParticleTypes.f_123813_, (d0 + this.getPosition().f_82479_ * 1.0) / 2.0, (d1 + this.getPosition().f_82480_ * 1.0) / 2.0, (d2 + this.getPosition().f_82481_ * 1.0) / 2.0, d3 *= (d7 *= (double)(ApiUtils.RANDOM.nextFloat() * ApiUtils.RANDOM.nextFloat() + 0.3f)), d4 *= d7, d5 *= d7);
            this.world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, d3, d4, d5);
            if (!state.m_60795_() && this.world instanceof ServerLevel && state.canDropFromExplosion((BlockGetter)this.world, pos, (Explosion)this)) {
                BlockEntity tile = this.world.m_7702_(pos);
                LootContext.Builder lootCtx = new LootContext.Builder((ServerLevel)this.world).m_230911_(this.world.f_46441_).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_78972_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_78984_(LootContextParams.f_81462_, (Object)tile);
                if (this.damagesTerrain == Explosion.BlockInteraction.DESTROY) {
                    lootCtx.m_78972_(LootContextParams.f_81464_, (Object)Float.valueOf(this.size));
                }
                state.m_60724_(lootCtx).forEach(stack -> ExplosionAccess.callAddBlockDrops((ObjectArrayList<Pair<ItemStack, BlockPos>>)objectarraylist, stack, pos));
                state.onBlockExploded(this.world, pos, (Explosion)this);
            }
            ++this.blockDestroyInt;
        }
        for (Pair pair : objectarraylist) {
            Block.m_49840_((Level)this.world, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
        }
        if (this.blockDestroyInt >= this.m_46081_().size()) {
            this.isExplosionFinished = true;
        }
    }

    public void m_46061_() {
        HashSet set = Sets.newHashSet();
        int i = 16;
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.getPosition().f_82479_;
                    double d6 = this.getPosition().f_82480_;
                    double d8 = this.getPosition().f_82481_;
                    float f1 = 0.3f;
                    for (float f = this.size * (0.7f + ApiUtils.RANDOM.nextFloat() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        BlockPos blockpos = new BlockPos(d4, d6, d8);
                        BlockState iblockstate = this.world.m_8055_(blockpos);
                        FluidState ifluidstate = this.world.m_6425_(blockpos);
                        if (!iblockstate.m_60795_() || !ifluidstate.m_76178_()) {
                            float f2 = Math.max(iblockstate.getExplosionResistance((BlockGetter)this.world, blockpos, (Explosion)this), ifluidstate.getExplosionResistance((BlockGetter)this.world, blockpos, (Explosion)this));
                            if (this.m_46079_() != null) {
                                f2 = this.m_46079_().m_7077_((Explosion)this, (BlockGetter)this.world, blockpos, iblockstate, ifluidstate, f2);
                            }
                            f -= (f2 + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && (this.m_46079_() == null || this.m_46079_().m_7349_((Explosion)this, (BlockGetter)this.world, blockpos, iblockstate, f))) {
                            set.add(blockpos);
                        }
                        d4 += d0 * (double)0.3f;
                        d6 += d1 * (double)0.3f;
                        d8 += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.m_46081_().addAll(set);
        this.m_46081_().sort(Comparator.comparingDouble(pos -> pos.m_203193_((Position)this.getPosition())));
        float f3 = this.size * 2.0f;
        int k1 = Mth.m_14107_((double)(this.getPosition().f_82479_ - (double)f3 - 1.0));
        int l1 = Mth.m_14107_((double)(this.getPosition().f_82479_ + (double)f3 + 1.0));
        int i2 = Mth.m_14107_((double)(this.getPosition().f_82480_ - (double)f3 - 1.0));
        int i1 = Mth.m_14107_((double)(this.getPosition().f_82480_ + (double)f3 + 1.0));
        int j2 = Mth.m_14107_((double)(this.getPosition().f_82481_ - (double)f3 - 1.0));
        int j1 = Mth.m_14107_((double)(this.getPosition().f_82481_ + (double)f3 + 1.0));
        List list = this.world.m_45933_((Entity)this.m_46079_(), new AABB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
        ForgeEventFactory.onExplosionDetonate((Level)this.world, (Explosion)this, (List)list, (double)f3);
        Vec3 vec3 = new Vec3(this.getPosition().f_82479_, this.getPosition().f_82480_, this.getPosition().f_82481_);
        for (int k2 = 0; k2 < list.size(); ++k2) {
            double d9;
            double d7;
            double d5;
            double d13;
            double d12;
            Entity entity = (Entity)list.get(k2);
            if (entity.m_6128_() || !((d12 = entity.m_20182_().m_82531_(this.getPosition().f_82479_, this.getPosition().f_82480_, this.getPosition().f_82481_) / (double)f3) <= 1.0) || (d13 = (double)Mth.m_14116_((float)((float)((d5 = entity.m_20185_() - this.getPosition().f_82479_) * d5 + (d7 = entity.m_20186_() + (double)entity.m_20192_() - this.getPosition().f_82480_) * d7 + (d9 = entity.m_20189_() - this.getPosition().f_82481_) * d9)))) == 0.0) continue;
            d5 /= d13;
            d7 /= d13;
            d9 /= d13;
            double d14 = IEExplosion.m_46064_((Vec3)vec3, (Entity)entity);
            double d10 = (1.0 - d12) * d14;
            entity.m_6469_(DamageSource.m_19358_((Explosion)this), (float)((int)((d10 * d10 + d10) / 2.0 * 8.0 * (double)f3 + 1.0)));
            double d11 = entity instanceof LivingEntity ? ProtectionEnchantment.m_45135_((LivingEntity)((LivingEntity)entity), (double)d10) : d10;
            entity.m_20256_(entity.m_20184_().m_82520_(d5 * d11, d7 * d11, d9 * d11));
            if (!(entity instanceof Player) || ((Player)entity).m_150110_().f_35934_) continue;
            this.m_46078_().put((Player)entity, new Vec3(d5 * d10, d7 * d10, d9 * d10));
        }
    }

    public void m_46075_(boolean spawnParticles) {
        Vec3 pos = this.getPosition();
        if (this.world.f_46443_) {
            this.world.m_7785_(pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_11913_, SoundSource.NEUTRAL, 4.0f, (1.0f + (ApiUtils.RANDOM.nextFloat() - ApiUtils.RANDOM.nextFloat()) * 0.2f) * 0.7f, true);
        }
        if (this.size >= 2.0f && this.damagesTerrain != Explosion.BlockInteraction.NONE) {
            this.world.m_7106_((ParticleOptions)ParticleTypes.f_123812_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 1.0, 0.0, 0.0);
        } else {
            this.world.m_7106_((ParticleOptions)ParticleTypes.f_123813_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 1.0, 0.0, 0.0);
        }
        EventHandler.currentExplosions.add(this);
    }
}

