/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import blusunrize.immersiveengineering.api.multiblocks.TemplateMultiblock;
import blusunrize.immersiveengineering.common.network.MessageMultiblockSync;
import blusunrize.immersiveengineering.common.util.IELogger;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.resource.PathPackResources;
import net.minecraftforge.resource.ResourcePackLoader;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="immersiveengineering")
public class StaticTemplateManager {
    public static ExistingFileHelper EXISTING_HELPER;
    public static Map<ResourceLocation, StructureTemplate> SYNCED_CLIENT_TEMPLATES;

    private static Optional<InputStream> getModResource(PackType type, ResourceLocation name, @Nullable MinecraftServer server) {
        if (EXISTING_HELPER != null) {
            try {
                int slash = name.m_135815_().indexOf(47);
                String prefix = name.m_135815_().substring(0, slash);
                ResourceLocation shortLoc = new ResourceLocation(name.m_135827_(), name.m_135815_().substring(slash + 1));
                return Optional.of(EXISTING_HELPER.getResource(shortLoc, type, "", prefix).m_215507_());
            }
            catch (Exception x) {
                throw new RuntimeException(x);
            }
        }
        if (server != null) {
            try {
                Optional resource = server.m_177941_().m_213713_(name);
                if (resource.isPresent()) {
                    return Optional.of(((Resource)resource.get()).m_215507_());
                }
                return Optional.empty();
            }
            catch (IOException x) {
                return Optional.empty();
            }
        }
        IELogger.error("Falling back to mod resource packs for resource {}", name);
        return ModList.get().getMods().stream().map(IModInfo::getModId).map(ResourcePackLoader::getPackFor).filter(Optional::isPresent).map(Optional::get).filter(mfrp -> mfrp.m_7211_(type, name)).map(mfrp -> StaticTemplateManager.getInputStreamOrThrow(type, name, mfrp)).findAny();
    }

    private static InputStream getInputStreamOrThrow(PackType type, ResourceLocation name, PathPackResources source) {
        try {
            return source.m_8031_(type, name);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static StructureTemplate loadStaticTemplate(ResourceLocation loc, @Nullable MinecraftServer server) throws IOException {
        if (server == null && EXISTING_HELPER == null) {
            return Objects.requireNonNull(SYNCED_CLIENT_TEMPLATES.get(loc));
        }
        String path = "structures/" + loc.m_135815_() + ".nbt";
        Optional<InputStream> optStream = StaticTemplateManager.getModResource(PackType.SERVER_DATA, new ResourceLocation(loc.m_135827_(), path), server);
        if (optStream.isPresent()) {
            return StaticTemplateManager.loadTemplate(optStream.get());
        }
        throw new RuntimeException("Mod resource not found: " + loc);
    }

    private static StructureTemplate loadTemplate(InputStream inputStreamIn) throws IOException {
        CompoundTag compoundnbt = NbtIo.m_128939_((InputStream)inputStreamIn);
        StructureTemplate template = new StructureTemplate();
        template.m_74638_(compoundnbt);
        return template;
    }

    public static void syncMultiblockTemplates(PacketDistributor.PacketTarget target, boolean resetMBs) {
        ArrayList<MessageMultiblockSync.SyncedTemplate> toSync = new ArrayList<MessageMultiblockSync.SyncedTemplate>();
        for (MultiblockHandler.IMultiblock mb : MultiblockHandler.getMultiblocks()) {
            if (!(mb instanceof TemplateMultiblock)) continue;
            TemplateMultiblock templateMB = (TemplateMultiblock)mb;
            if (resetMBs) {
                templateMB.reset();
            }
            StructureTemplate template = templateMB.getTemplate(ServerLifecycleHooks.getCurrentServer());
            ResourceLocation rl = templateMB.getTemplateLocation();
            toSync.add(new MessageMultiblockSync.SyncedTemplate(template, rl));
        }
        ImmersiveEngineering.packetHandler.send(target, (Object)new MessageMultiblockSync(toSync));
    }

    @SubscribeEvent
    public static void onLogin(PlayerEvent.PlayerLoggedInEvent ev) {
        StaticTemplateManager.syncMultiblockTemplates(PacketDistributor.PLAYER.with(() -> (ServerPlayer)ev.getEntity()), false);
    }

    static {
        SYNCED_CLIENT_TEMPLATES = new HashMap<ResourceLocation, StructureTemplate>();
    }
}

