/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.client.IVertexBufferHolder;
import blusunrize.immersiveengineering.api.utils.SafeChunkUtils;
import blusunrize.immersiveengineering.client.render.tile.DynamicModel;
import blusunrize.immersiveengineering.client.render.tile.IEBlockEntityRenderer;
import blusunrize.immersiveengineering.common.blocks.wooden.WatermillBlockEntity;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.util.NonNullSupplier;

public class WatermillRenderer
extends IEBlockEntityRenderer<WatermillBlockEntity> {
    public static final String NAME = "watermill";
    public static DynamicModel MODEL;
    private static final IVertexBufferHolder MODEL_BUFFER;

    public void render(WatermillBlockEntity tile, float partialTicks, PoseStack transform, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!SafeChunkUtils.isChunkSafe((LevelAccessor)tile.getLevelNonnull(), tile.m_58899_())) {
            return;
        }
        transform.m_85836_();
        transform.m_85837_(0.5, 0.5, 0.5);
        float dir = (tile.getFacing().m_122435_() + 180.0f) % 180.0f;
        float wheelRotation = 360.0f * (tile.rotation + partialTicks * (float)tile.perTick);
        transform.m_85845_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), dir, true));
        transform.m_85845_(new Quaternion(new Vector3f(0.0f, 0.0f, 1.0f), wheelRotation, true));
        transform.m_85837_(-0.5, -0.5, -0.5);
        MODEL_BUFFER.render(RenderType.m_110457_(), combinedLightIn, combinedOverlayIn, bufferIn, transform);
        transform.m_85849_();
    }

    public static void reset() {
        MODEL_BUFFER.reset();
    }

    static {
        MODEL_BUFFER = IVertexBufferHolder.create((NonNullSupplier<List<BakedQuad>>)((NonNullSupplier)() -> {
            BlockState state = (BlockState)IEBlocks.WoodenDevices.WATERMILL.defaultBlockState().m_61124_((Property)IEProperties.FACING_HORIZONTAL, (Comparable)Direction.NORTH);
            return MODEL.get().getQuads(state, null, ApiUtils.RANDOM_SOURCE, ModelData.EMPTY, null);
        }));
    }
}

