/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.forge.client;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaForgeClientCapabilities;
import vazkii.botania.api.block.WandHUD;
import vazkii.botania.api.item.TinyPotatoRenderEvent;
import vazkii.botania.forge.CapabilityUtil;
import vazkii.botania.forge.client.ForgePlatformModel;
import vazkii.botania.forge.network.ForgePacketHandler;
import vazkii.botania.network.BotaniaPacket;
import vazkii.botania.xplat.ClientXplatAbstractions;

public class ForgeClientXplatImpl
implements ClientXplatAbstractions {
    @Override
    public void fireRenderTinyPotato(BlockEntity potato, Component name, float tickDelta, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        MinecraftForge.EVENT_BUS.post((Event)new TinyPotatoRenderEvent(potato, name, tickDelta, ms, buffers, light, overlay));
    }

    @Override
    public void sendToServer(BotaniaPacket packet) {
        ForgePacketHandler.CHANNEL.sendToServer((Object)packet);
    }

    @Override
    @Nullable
    public WandHUD findWandHud(Level level, BlockPos pos, BlockState state, @Nullable BlockEntity be) {
        return CapabilityUtil.findCapability(BotaniaForgeClientCapabilities.WAND_HUD, level, pos, state, be);
    }

    @Override
    public BakedModel wrapPlatformModel(BakedModel original) {
        return new ForgePlatformModel(original);
    }

    @Override
    public void setFilterSave(AbstractTexture texture, boolean filter, boolean mipmap) {
        texture.setBlurMipmap(filter, mipmap);
    }

    @Override
    public void restoreLastFilter(AbstractTexture texture) {
        texture.restoreLastBlurMipmap();
    }

    @Override
    public void tessellateBlock(Level level, BlockState state, BlockPos pos, PoseStack ps, MultiBufferSource buffers, int overlay) {
        BlockRenderDispatcher renderer = Minecraft.m_91087_().m_91289_();
        BakedModel model = renderer.m_110910_(state);
        RandomSource rand = RandomSource.m_216327_();
        for (RenderType type : model.getRenderTypes(state, rand, ModelData.EMPTY)) {
            renderer.m_110937_().tesselateBlock((BlockAndTintGetter)level, model, state, pos, ps, buffers.m_6299_(type), false, rand, state.m_60726_(pos), overlay, ModelData.EMPTY, type);
        }
    }
}

