/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.client.core.handler.MiscellaneousModels;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.client.render.AccessoryRenderRegistry;
import vazkii.botania.client.render.AccessoryRenderer;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.equipment.bauble.BaubleItem;
import vazkii.botania.common.proxy.Proxy;

public class SpectatorItem
extends BaubleItem {
    private static final String TAG_ENTITY_POSITIONS = "highlightPositionsEnt";
    private static final String TAG_BLOCK_POSITIONS = "highlightPositionsBlock";

    public SpectatorItem(Item.Properties props) {
        super(props);
        Proxy.INSTANCE.runOnClient(() -> () -> AccessoryRenderRegistry.register(this, new Renderer()));
    }

    @Override
    public void onWornTick(ItemStack stack, LivingEntity living) {
        if (!(living instanceof Player)) {
            return;
        }
        Player player = (Player)living;
        if (living.f_19853_.f_46443_) {
            this.tickClient(stack, player);
        } else {
            this.tickServer(stack, player);
        }
    }

    protected void tickClient(ItemStack stack, Player player) {
        int[] entities;
        if (player != Proxy.INSTANCE.getClientPlayer()) {
            return;
        }
        ListTag blocks = ItemNBTHelper.getList(stack, TAG_BLOCK_POSITIONS, 4, false);
        for (Tag block : blocks) {
            BlockPos pos = BlockPos.m_122022_((long)((LongTag)block).m_7046_());
            float m = 0.02f;
            WispParticleData data = WispParticleData.wisp(0.15f + 0.05f * (float)Math.random(), (float)Math.random(), (float)Math.random(), (float)Math.random(), false);
            player.f_19853_.m_7106_((ParticleOptions)data, (double)((float)pos.m_123341_() + (float)Math.random()), (double)((float)pos.m_123342_() + (float)Math.random()), (double)((float)pos.m_123343_() + (float)Math.random()), (double)(m * (float)(Math.random() - 0.5)), (double)(m * (float)(Math.random() - 0.5)), (double)(m * (float)(Math.random() - 0.5)));
        }
        for (int i : entities = ItemNBTHelper.getIntArray(stack, TAG_ENTITY_POSITIONS)) {
            Entity e = player.f_19853_.m_6815_(i);
            if (e == null || !(Math.random() < 0.6)) continue;
            WispParticleData data = WispParticleData.wisp(0.15f + 0.05f * (float)Math.random(), (float)Math.random(), (float)Math.random(), (float)Math.random(), Math.random() < 0.6);
            player.f_19853_.m_7106_((ParticleOptions)data, e.m_20185_() + (double)((float)(Math.random() * 0.5 - 0.25) * 0.45f), e.m_20186_() + (double)e.m_20206_(), e.m_20189_() + (double)((float)(Math.random() * 0.5 - 0.25) * 0.45f), 0.0, (double)(0.05f + 0.03f * (float)Math.random()), 0.0);
        }
    }

    protected void tickServer(ItemStack stack, Player player) {
        IntArrayList entPosBuilder = new IntArrayList();
        ListTag blockPosBuilder = new ListTag();
        this.scanForStack(player.m_21205_(), player, entPosBuilder, blockPosBuilder);
        this.scanForStack(player.m_21206_(), player, entPosBuilder, blockPosBuilder);
        int[] currentEnts = entPosBuilder.elements();
        ItemNBTHelper.setIntArray(stack, TAG_ENTITY_POSITIONS, currentEnts);
        ItemNBTHelper.setList(stack, TAG_BLOCK_POSITIONS, blockPosBuilder);
    }

    private void scanForStack(ItemStack pstack, Player player, IntArrayList entIdBuilder, ListTag blockPosBuilder) {
        if (!pstack.m_41619_() || player.m_6144_()) {
            int range = 24;
            List entities = player.f_19853_.m_45976_(Entity.class, new AABB(player.m_20185_() - (double)range, player.m_20186_() - (double)range, player.m_20189_() - (double)range, player.m_20185_() + (double)range, player.m_20186_() + (double)range, player.m_20189_() + (double)range));
            for (Entity e : entities) {
                Container inv;
                if (e == player) continue;
                if (e instanceof ItemEntity) {
                    ItemEntity item = (ItemEntity)e;
                    ItemStack istack = item.m_32055_();
                    if (!player.m_6144_() && (!istack.m_41656_(pstack) || !ItemStack.m_41658_((ItemStack)istack, (ItemStack)pstack))) continue;
                    entIdBuilder.add(item.m_19879_());
                    continue;
                }
                if (e instanceof Player) {
                    Player targetPlayer = (Player)e;
                    Container binv = BotaniaAPI.instance().getAccessoriesInventory(targetPlayer);
                    if (!this.scanInventory((Container)targetPlayer.m_150109_(), pstack) && !this.scanInventory(binv, pstack)) continue;
                    entIdBuilder.add(targetPlayer.m_19879_());
                    continue;
                }
                if (e instanceof Merchant) {
                    Merchant villager = (Merchant)e;
                    for (MerchantOffer offer : villager.m_6616_()) {
                        if (!this.equalStacks(pstack, offer.m_45352_()) && !this.equalStacks(pstack, offer.m_45364_()) && !this.equalStacks(pstack, offer.m_45368_())) continue;
                        entIdBuilder.add(e.m_19879_());
                    }
                    continue;
                }
                if (!(e instanceof Container) || !this.scanInventory(inv = (Container)e, pstack)) continue;
                entIdBuilder.add(e.m_19879_());
            }
            if (!pstack.m_41619_()) {
                range = 12;
                BlockPos pos = player.m_20183_();
                for (BlockPos pos_ : BlockPos.m_121940_((BlockPos)pos.m_7918_(-range, -range, -range), (BlockPos)pos.m_7918_(range + 1, range + 1, range + 1))) {
                    Container inv;
                    BlockEntity tile = player.f_19853_.m_7702_(pos_);
                    if (tile == null || !(tile instanceof Container) || !this.scanInventory(inv = (Container)tile, pstack)) continue;
                    blockPosBuilder.add((Object)LongTag.m_128882_((long)pos_.m_121878_()));
                }
            }
        }
    }

    private boolean equalStacks(ItemStack stack1, ItemStack stack2) {
        return stack1.m_41656_(stack2) && ItemStack.m_41658_((ItemStack)stack1, (ItemStack)stack2);
    }

    private boolean scanInventory(Container inv, ItemStack pstack) {
        if (pstack.m_41619_()) {
            return false;
        }
        for (int l = 0; l < inv.m_6643_(); ++l) {
            ItemStack istack = inv.m_8020_(l);
            if (istack == null || istack.m_41619_() || !this.equalStacks(istack, pstack)) continue;
            return true;
        }
        return false;
    }

    public static class Renderer
    implements AccessoryRenderer {
        @Override
        public void doRender(HumanoidModel<?> bipedModel, ItemStack stack, LivingEntity living, PoseStack ms, MultiBufferSource buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            boolean armor = !living.m_6844_(EquipmentSlot.HEAD).m_41619_();
            bipedModel.f_102808_.m_104299_(ms);
            ms.m_85837_(-0.35, -0.2, armor ? 0.05 : 0.1);
            ms.m_85841_(0.75f, -0.75f, -0.75f);
            BakedModel model = MiscellaneousModels.INSTANCE.itemFinderGem;
            VertexConsumer buffer = buffers.m_6299_(Sheets.m_110790_());
            Minecraft.m_91087_().m_91289_().m_110937_().m_111067_(ms.m_85850_(), buffer, null, model, 1.0f, 1.0f, 1.0f, light, OverlayTexture.f_118083_);
        }
    }
}

