/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.handler;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.recipe.OrechidRecipe;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.xplat.XplatAbstractions;

public class OrechidManager
implements ResourceManagerReloadListener {
    private static final Map<RecipeType<? extends OrechidRecipe>, Map<BlockState, List<? extends OrechidRecipe>>> BY_TYPE = new IdentityHashMap<RecipeType<? extends OrechidRecipe>, Map<BlockState, List<? extends OrechidRecipe>>>();

    public static void registerListener() {
        XplatAbstractions.INSTANCE.registerReloadListener(PackType.SERVER_DATA, ResourceLocationHelper.prefix("orechid"), (PreparableReloadListener)new OrechidManager());
    }

    public void m_6213_(@NotNull ResourceManager manager) {
        BY_TYPE.clear();
    }

    public static <T extends OrechidRecipe> Collection<T> getMatchingRecipes(RecipeManager manager, RecipeType<T> type, BlockState state) {
        ImmutableList list;
        Map<BlockState, List<? extends OrechidRecipe>> byState = BY_TYPE.get(type);
        if (byState == null) {
            byState = new IdentityHashMap<BlockState, List<? extends OrechidRecipe>>();
            BY_TYPE.put(type, byState);
        }
        if ((list = byState.get(state)) == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (OrechidRecipe recipe : manager.m_44013_(type)) {
                if (!recipe.getInput().test(state)) continue;
                builder.add((Object)recipe);
            }
            list = builder.build();
            byState.put(state, (List<? extends OrechidRecipe>)list);
        }
        ImmutableList result = list;
        return result;
    }
}

