/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.generating;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.lib.BotaniaTags;

public class RafflowsiaBlockEntity
extends GeneratingFlowerBlockEntity {
    public static final String TAG_LAST_FLOWERS = "lastFlowers";
    public static final String TAG_LAST_FLOWER_TIMES = "lastFlowerTimes";
    public static final String TAG_STREAK_LENGTH = "streakLength";
    private final List<Block> lastFlowers = new LinkedList<Block>();
    private int streakLength = -1;
    private int lastFlowerCount = 0;
    private static final int RANGE = 5;
    private static final int[] STREAK_OUTPUTS = new int[]{2000, 2100, 2200, 2300, 3280, 4033, 4657, 5150, 6622, 7860, 10418, 12600, 14769, 16671, 19000, 25400, 33471, 40900, 47579, 53600, 59057, 64264, 69217, 74483, 79352, 83869, 88059, 92129, 96669, 100940, 105239, 112044, 118442, 124612, 130583, 136228, 141703, 178442, 213959, 247725, 279956, 313671, 345833, 377227, 437689, 495526, 553702, 638554};

    public RafflowsiaBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaFlowerBlocks.RAFFLOWSIA, pos, state);
    }

    private int getMaxStreak() {
        return STREAK_OUTPUTS.length - 1;
    }

    private int getValueForStreak(int index) {
        if (index != 0) {
            this.lastFlowerCount = 0;
        }
        return STREAK_OUTPUTS[index] / ++this.lastFlowerCount;
    }

    private int processFlower(Block flower) {
        ListIterator<Block> it = this.lastFlowers.listIterator();
        while (it.hasNext()) {
            int index = it.nextIndex();
            Block streakFlower = it.next();
            if (streakFlower != flower) continue;
            it.remove();
            this.lastFlowers.add(0, streakFlower);
            return index;
        }
        this.lastFlowers.add(0, flower);
        if (this.lastFlowers.size() >= this.getMaxStreak()) {
            this.lastFlowers.remove(this.lastFlowers.size() - 1);
        }
        return this.getMaxStreak();
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        int mana = 2100;
        if (this.getMaxMana() - this.getMana() >= mana && !this.m_58904_().f_46443_ && this.ticksExisted % 40 == 0) {
            for (int i = 0; i < 11; ++i) {
                for (int j = 0; j < 11; ++j) {
                    for (int k = 0; k < 11; ++k) {
                        BlockPos pos = this.getEffectivePos().m_7918_(i - 5, j - 5, k - 5);
                        BlockState state = this.m_58904_().m_8055_(pos);
                        if (!state.m_204336_(BotaniaTags.Blocks.SPECIAL_FLOWERS) || state.m_60713_(BotaniaFlowerBlocks.rafflowsia)) continue;
                        this.streakLength = Math.min(this.streakLength + 1, this.processFlower(state.m_60734_()));
                        this.m_58904_().m_46961_(pos, false);
                        this.addMana(this.getValueForStreak(this.streakLength));
                        this.sync();
                        return;
                    }
                }
            }
        }
    }

    @Override
    public void writeToPacketNBT(CompoundTag cmp) {
        super.writeToPacketNBT(cmp);
        ListTag flowerList = new ListTag();
        for (Block flower : this.lastFlowers) {
            flowerList.add((Object)StringTag.m_129297_((String)Registry.f_122824_.m_7981_((Object)flower).toString()));
        }
        cmp.m_128365_(TAG_LAST_FLOWERS, (Tag)flowerList);
        cmp.m_128405_(TAG_LAST_FLOWER_TIMES, this.lastFlowerCount);
        cmp.m_128405_(TAG_STREAK_LENGTH, this.streakLength);
    }

    @Override
    public void readFromPacketNBT(CompoundTag cmp) {
        super.readFromPacketNBT(cmp);
        this.lastFlowers.clear();
        ListTag flowerList = cmp.m_128437_(TAG_LAST_FLOWERS, 8);
        for (int i = 0; i < flowerList.size(); ++i) {
            this.lastFlowers.add((Block)Registry.f_122824_.m_7745_(ResourceLocation.m_135820_((String)flowerList.m_128778_(i))));
        }
        this.lastFlowerCount = cmp.m_128451_(TAG_LAST_FLOWER_TIMES);
        this.streakLength = cmp.m_128451_(TAG_STREAK_LENGTH);
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), 5);
    }

    @Override
    public int getColor() {
        return 5254262;
    }

    @Override
    public int getMaxMana() {
        return STREAK_OUTPUTS[STREAK_OUTPUTS.length - 1];
    }
}

