/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity;

import com.google.common.base.Predicates;
import com.google.common.base.Suppliers;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block.WandHUD;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.ManaPool;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.api.mana.spark.ManaSpark;
import vazkii.botania.api.mana.spark.SparkAttachable;
import vazkii.botania.api.mana.spark.SparkHelper;
import vazkii.botania.api.state.BotaniaStateProperties;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntity;
import vazkii.botania.common.block.block_entity.PylonBlockEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.network.EffectType;
import vazkii.botania.network.clientbound.BotaniaEffectPacket;
import vazkii.botania.xplat.XplatAbstractions;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.IStateMatcher;
import vazkii.patchouli.api.PatchouliAPI;

public class ManaEnchanterBlockEntity
extends BotaniaBlockEntity
implements ManaReceiver,
SparkAttachable,
Wandable,
Clearable {
    private static final String TAG_STAGE = "stage";
    private static final String TAG_STAGE_TICKS = "stageTicks";
    private static final String TAG_STAGE_3_END_TICKS = "stage3EndTicks";
    private static final String TAG_MANA_REQUIRED = "manaRequired";
    private static final String TAG_MANA = "mana";
    private static final String TAG_ITEM = "item";
    private static final String TAG_ENCHANTS = "enchantsToApply";
    private static final int CRAFT_EFFECT_EVENT = 0;
    private static final String[][] PATTERN = new String[][]{{"_P_______P_", "___________", "___________", "P_________P", "___________", "___________", "_P_______P_"}, {"_F_______F_", "___________", "____F_F____", "F____L____F", "____F_F____", "___________", "_F_______F_"}, {"___________", "____BBB____", "___B_B_B___", "___BB0BB___", "___B_B_B___", "____BBB____", "___________"}};
    private static final Supplier<IStateMatcher> OBSIDIAN_MATCHER = Suppliers.memoize(() -> PatchouliAPI.get().predicateMatcher(Blocks.f_50080_, state -> state.m_60713_(Blocks.f_50080_) || state.m_60713_(Blocks.f_50723_)));
    public static final Supplier<IMultiblock> MULTIBLOCK = Suppliers.memoize(() -> PatchouliAPI.get().makeMultiblock(PATTERN, new Object[]{Character.valueOf('P'), BotaniaBlocks.manaPylon, Character.valueOf('L'), Blocks.f_50060_, Character.valueOf('B'), OBSIDIAN_MATCHER.get(), Character.valueOf('0'), OBSIDIAN_MATCHER.get(), Character.valueOf('F'), PatchouliAPI.get().tagMatcher(BotaniaTags.Blocks.ENCHANTER_FLOWERS)}));
    private static final Supplier<IMultiblock> FORMED_MULTIBLOCK = Suppliers.memoize(() -> PatchouliAPI.get().makeMultiblock(PATTERN, new Object[]{Character.valueOf('P'), BotaniaBlocks.manaPylon, Character.valueOf('L'), BotaniaBlocks.enchanter, Character.valueOf('B'), OBSIDIAN_MATCHER.get(), Character.valueOf('0'), OBSIDIAN_MATCHER.get(), Character.valueOf('F'), PatchouliAPI.get().predicateMatcher(BotaniaBlocks.whiteFlower, state -> state.m_204336_(BotaniaTags.Blocks.ENCHANTER_FLOWERS))}));
    public State stage = State.IDLE;
    public int stageTicks = 0;
    public int stage3EndTicks = 0;
    private int manaRequired = -1;
    private int mana = 0;
    public ItemStack itemToEnchant = ItemStack.f_41583_;
    private final List<EnchantmentInstance> enchants = new ArrayList<EnchantmentInstance>();
    private static final Map<Direction.Axis, BlockPos[]> PYLON_LOCATIONS = new EnumMap<Direction.Axis, BlockPos[]>(Direction.Axis.class);

    public ManaEnchanterBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.ENCHANTER, pos, state);
    }

    @Override
    public boolean onUsedByWand(@Nullable Player player, ItemStack wand, Direction side) {
        if (this.stage != State.IDLE || this.itemToEnchant.m_41619_() || !this.itemToEnchant.m_41792_()) {
            return false;
        }
        List items = this.f_58857_.m_45976_(ItemEntity.class, new AABB((double)(this.f_58858_.m_123341_() - 2), (double)this.f_58858_.m_123342_(), (double)(this.f_58858_.m_123343_() - 2), (double)(this.f_58858_.m_123341_() + 3), (double)(this.f_58858_.m_123342_() + 1), (double)(this.f_58858_.m_123343_() + 3)));
        int count = items.size();
        if (count > 0 && !this.f_58857_.f_46443_) {
            for (ItemEntity entity : items) {
                Enchantment enchant;
                Map enchants;
                ItemStack item = entity.m_32055_();
                if (!item.m_150930_(Items.f_42690_) || (enchants = EnchantmentHelper.m_44831_((ItemStack)item)).size() <= 0 || !this.isEnchantmentValid(enchant = (Enchantment)enchants.keySet().iterator().next())) continue;
                this.advanceStage();
                return true;
            }
        }
        return false;
    }

    private void gatherEnchants() {
        if (!this.f_58857_.f_46443_ && this.stageTicks % 20 == 0) {
            List items = this.f_58857_.m_45976_(ItemEntity.class, new AABB((double)(this.f_58858_.m_123341_() - 2), (double)this.f_58858_.m_123342_(), (double)(this.f_58858_.m_123343_() - 2), (double)(this.f_58858_.m_123341_() + 3), (double)(this.f_58858_.m_123342_() + 1), (double)(this.f_58858_.m_123343_() + 3)));
            boolean addedEnch = false;
            for (ItemEntity entity : items) {
                Map enchants;
                ItemStack item = entity.m_32055_();
                if (!item.m_150930_(Items.f_42690_) || (enchants = EnchantmentHelper.m_44831_((ItemStack)item)).size() <= 0) continue;
                Map.Entry e = enchants.entrySet().iterator().next();
                Enchantment ench = (Enchantment)e.getKey();
                int enchantLvl = (Integer)e.getValue();
                if (this.hasEnchantAlready(ench) || !this.isEnchantmentValid(ench)) continue;
                this.enchants.add(new EnchantmentInstance(ench, enchantLvl));
                this.f_58857_.m_5594_(null, this.f_58858_, BotaniaSounds.ding, SoundSource.BLOCKS, 1.0f, 1.0f);
                addedEnch = true;
                break;
            }
            if (!addedEnch) {
                if (this.enchants.isEmpty()) {
                    this.stage = State.IDLE;
                } else {
                    this.advanceStage();
                }
            }
        }
    }

    private void gatherMana(Direction.Axis axis) {
        if (this.manaRequired == -1) {
            this.manaRequired = 0;
            for (EnchantmentInstance data : this.enchants) {
                this.manaRequired += (int)(5000.0f * ((float)(15 - Math.min(15, data.f_44947_.m_44699_().m_44716_())) * 1.05f) * ((3.0f + (float)(data.f_44948_ * data.f_44948_)) * 0.25f) * (0.9f + (float)this.enchants.size() * 0.05f) * (data.f_44947_.m_6591_() ? 1.25f : 1.0f));
            }
        } else if (this.mana >= this.manaRequired) {
            this.manaRequired = 0;
            for (BlockPos offset : PYLON_LOCATIONS.get(axis)) {
                BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_121955_((Vec3i)offset));
                if (!(te instanceof PylonBlockEntity)) continue;
                PylonBlockEntity pylon = (PylonBlockEntity)te;
                pylon.activated = false;
            }
            this.advanceStage();
        } else {
            ManaSpark spark = this.getAttachedSpark();
            if (spark != null) {
                List<ManaSpark> otherSparks = SparkHelper.getSparksAround(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, spark.getNetwork());
                for (ManaSpark otherSpark : otherSparks) {
                    if (spark == otherSpark || !(otherSpark.getAttachedManaReceiver() instanceof ManaPool)) continue;
                    otherSpark.registerTransfer(spark);
                }
            }
            if (this.stageTicks % 5 == 0) {
                this.sync();
            }
        }
    }

    public static void commonTick(Level level, BlockPos worldPosition, BlockState state, ManaEnchanterBlockEntity self) {
        Direction.Axis axis = (Direction.Axis)state.m_61143_(BotaniaStateProperties.ENCHANTER_DIRECTION);
        for (BlockPos offset : PYLON_LOCATIONS.get(axis)) {
            BlockEntity tile = level.m_7702_(worldPosition.m_121955_((Vec3i)offset));
            if (!(tile instanceof PylonBlockEntity)) continue;
            PylonBlockEntity pylon = (PylonBlockEntity)tile;
            boolean bl = pylon.activated = self.stage == State.GATHER_MANA;
            if (self.stage != State.GATHER_MANA) continue;
            pylon.centerPos = worldPosition;
        }
        if (self.stage != State.IDLE) {
            ++self.stageTicks;
        }
        if (level.f_46443_) {
            return;
        }
        if (FORMED_MULTIBLOCK.get().validate(level, worldPosition.m_7495_()) == null) {
            level.m_46597_(worldPosition, Blocks.f_50060_.m_49966_());
            XplatAbstractions.INSTANCE.sendToNear(level, worldPosition, new BotaniaEffectPacket(EffectType.ENCHANTER_DESTROY, (double)worldPosition.m_123341_() + 0.5, (double)worldPosition.m_123342_() + 0.5, (double)worldPosition.m_123343_() + 0.5, new int[0]));
            level.m_5594_(null, worldPosition, BotaniaSounds.enchanterFade, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        switch (self.stage) {
            case GATHER_ENCHANTS: {
                self.gatherEnchants();
                break;
            }
            case GATHER_MANA: {
                self.gatherMana(axis);
                break;
            }
            case DO_ENCHANT: {
                if (self.stageTicks < 100) break;
                for (EnchantmentInstance data : self.enchants) {
                    if (EnchantmentHelper.m_44843_((Enchantment)data.f_44947_, (ItemStack)self.itemToEnchant) != 0) continue;
                    self.itemToEnchant.m_41663_(data.f_44947_, data.f_44948_);
                }
                self.enchants.clear();
                self.manaRequired = -1;
                self.mana = 0;
                level.m_7696_(worldPosition, BotaniaBlocks.enchanter, 0, 0);
                self.advanceStage();
                break;
            }
            case RESET: {
                if (self.stageTicks < 20) break;
                self.advanceStage();
                break;
            }
        }
    }

    private void advanceStage() {
        switch (this.stage) {
            case IDLE: {
                this.stage = State.GATHER_ENCHANTS;
                break;
            }
            case GATHER_ENCHANTS: {
                this.stage = State.GATHER_MANA;
                break;
            }
            case GATHER_MANA: {
                this.stage = State.DO_ENCHANT;
                break;
            }
            case DO_ENCHANT: {
                this.stage = State.RESET;
                this.stage3EndTicks = this.stageTicks;
                break;
            }
            case RESET: {
                this.stage = State.IDLE;
                this.stage3EndTicks = 0;
            }
        }
        this.stageTicks = 0;
        this.sync();
    }

    public boolean m_7531_(int event, int param) {
        switch (event) {
            case 0: {
                if (this.f_58857_.f_46443_) {
                    for (int i = 0; i < 25; ++i) {
                        float red = (float)Math.random();
                        float green = (float)Math.random();
                        float blue = (float)Math.random();
                        SparkleParticleData data = SparkleParticleData.sparkle((float)Math.random(), red, green, blue, 10);
                        this.f_58857_.m_7106_((ParticleOptions)data, (double)this.m_58899_().m_123341_() + Math.random() * 0.4 - 0.2, (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_() + Math.random() * 0.4 - 0.2, 0.0, 0.0, 0.0);
                    }
                    this.f_58857_.m_7785_((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), BotaniaSounds.enchanterEnchant, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                }
                return true;
            }
        }
        return super.m_7531_(event, param);
    }

    @Override
    public Level getManaReceiverLevel() {
        return this.m_58904_();
    }

    @Override
    public BlockPos getManaReceiverPos() {
        return this.m_58899_();
    }

    @Override
    public int getCurrentMana() {
        return this.mana;
    }

    @Override
    public boolean isFull() {
        return this.mana >= this.manaRequired;
    }

    @Override
    public void receiveMana(int mana) {
        this.mana = Math.min(this.manaRequired, this.mana + mana);
    }

    @Override
    public boolean canReceiveManaFromBursts() {
        return this.manaRequired > 0;
    }

    public void sync() {
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
    }

    @Override
    public void writePacketNBT(CompoundTag cmp) {
        cmp.m_128405_(TAG_MANA, this.mana);
        cmp.m_128405_(TAG_MANA_REQUIRED, this.manaRequired);
        cmp.m_128405_(TAG_STAGE, this.stage.ordinal());
        cmp.m_128405_(TAG_STAGE_TICKS, this.stageTicks);
        cmp.m_128405_(TAG_STAGE_3_END_TICKS, this.stage3EndTicks);
        CompoundTag itemCmp = new CompoundTag();
        if (!this.itemToEnchant.m_41619_()) {
            cmp.m_128365_(TAG_ITEM, (Tag)this.itemToEnchant.m_41739_(itemCmp));
        }
        String enchStr = this.enchants.stream().map(e -> Registry.f_122825_.m_7981_((Object)e.f_44947_) + "=" + e.f_44948_).collect(Collectors.joining(","));
        cmp.m_128359_(TAG_ENCHANTS, enchStr);
    }

    @Override
    public void readPacketNBT(CompoundTag cmp) {
        this.mana = cmp.m_128451_(TAG_MANA);
        this.manaRequired = cmp.m_128451_(TAG_MANA_REQUIRED);
        this.stage = State.values()[cmp.m_128451_(TAG_STAGE)];
        this.stageTicks = cmp.m_128451_(TAG_STAGE_TICKS);
        this.stage3EndTicks = cmp.m_128451_(TAG_STAGE_3_END_TICKS);
        CompoundTag itemCmp = cmp.m_128469_(TAG_ITEM);
        this.itemToEnchant = ItemStack.m_41712_((CompoundTag)itemCmp);
        this.enchants.clear();
        String enchStr = cmp.m_128461_(TAG_ENCHANTS);
        if (!enchStr.isEmpty()) {
            String[] enchTokens;
            for (String token : enchTokens = enchStr.split(",")) {
                try {
                    String[] entryTokens = token.split("=");
                    int lvl = Integer.parseInt(entryTokens[1]);
                    Registry.f_122825_.m_6612_(new ResourceLocation(entryTokens[0])).ifPresent(ench -> this.enchants.add(new EnchantmentInstance(ench, lvl)));
                }
                catch (ResourceLocationException resourceLocationException) {
                    // empty catch block
                }
            }
        }
    }

    private boolean hasEnchantAlready(Enchantment enchant) {
        for (EnchantmentInstance data : this.enchants) {
            if (data.f_44947_ != enchant) continue;
            return true;
        }
        return false;
    }

    private boolean isEnchantmentValid(@Nullable Enchantment ench) {
        if (ench == null || !ench.m_6081_(this.itemToEnchant)) {
            return false;
        }
        for (EnchantmentInstance data : this.enchants) {
            Enchantment otherEnch = data.f_44947_;
            if (ench.m_44695_(otherEnch)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static Direction.Axis canEnchanterExist(Level world, BlockPos pos) {
        Rotation rot = MULTIBLOCK.get().validate(world, pos.m_7495_());
        if (rot == null) {
            return null;
        }
        return switch (rot) {
            default -> throw new IncompatibleClassChangeError();
            case Rotation.NONE, Rotation.CLOCKWISE_180 -> Direction.Axis.Z;
            case Rotation.CLOCKWISE_90, Rotation.COUNTERCLOCKWISE_90 -> Direction.Axis.X;
        };
    }

    @Override
    public boolean canAttachSpark(ItemStack stack) {
        return true;
    }

    @Override
    public ManaSpark getAttachedSpark() {
        List sparks = this.f_58857_.m_6443_(Entity.class, new AABB((double)this.f_58858_.m_123341_(), (double)(this.f_58858_.m_123342_() + 1), (double)this.f_58858_.m_123343_(), (double)(this.f_58858_.m_123341_() + 1), (double)(this.f_58858_.m_123342_() + 2), (double)(this.f_58858_.m_123343_() + 1)), (Predicate)Predicates.instanceOf(ManaSpark.class));
        if (sparks.size() == 1) {
            Entity e = (Entity)sparks.get(0);
            return (ManaSpark)e;
        }
        return null;
    }

    @Override
    public boolean areIncomingTranfersDone() {
        return this.stage == State.DO_ENCHANT;
    }

    @Override
    public int getAvailableSpaceForMana() {
        return Math.max(0, this.manaRequired - this.getCurrentMana());
    }

    public void m_6211_() {
        this.itemToEnchant = ItemStack.f_41583_;
        this.stage = State.IDLE;
    }

    static {
        PYLON_LOCATIONS.put(Direction.Axis.X, new BlockPos[]{new BlockPos(-5, 1, 0), new BlockPos(5, 1, 0), new BlockPos(-4, 1, 3), new BlockPos(4, 1, 3), new BlockPos(-4, 1, -3), new BlockPos(4, 1, -3)});
        PYLON_LOCATIONS.put(Direction.Axis.Z, new BlockPos[]{new BlockPos(0, 1, -5), new BlockPos(0, 1, 5), new BlockPos(3, 1, -4), new BlockPos(3, 1, 4), new BlockPos(-3, 1, -4), new BlockPos(-3, 1, 4)});
    }

    public static enum State {
        IDLE,
        GATHER_ENCHANTS,
        GATHER_MANA,
        DO_ENCHANT,
        RESET;

    }

    public static class WandHud
    implements WandHUD {
        private final ManaEnchanterBlockEntity enchanter;

        public WandHud(ManaEnchanterBlockEntity enchanter) {
            this.enchanter = enchanter;
        }

        @Override
        public void renderHUD(PoseStack ms, Minecraft mc) {
            if (this.enchanter.manaRequired > 0 && !this.enchanter.itemToEnchant.m_41619_()) {
                int x = mc.m_91268_().m_85445_() / 2 + 20;
                int y = mc.m_91268_().m_85446_() / 2 - 8;
                RenderHelper.renderProgressPie(ms, x, y, (float)this.enchanter.mana / (float)this.enchanter.manaRequired, this.enchanter.itemToEnchant);
            }
        }
    }
}

