/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei.orechid;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.recipe.OrechidRecipe;
import vazkii.botania.common.lib.ResourceLocationHelper;

public abstract class OrechidRecipeCategoryBase<T extends OrechidRecipe>
implements IRecipeCategory<T> {
    private final IDrawableStatic background;
    private final Component localizedName;
    private final IDrawableStatic overlay;
    private final IDrawable icon;
    private final ItemStack iconStack;

    public OrechidRecipeCategoryBase(IGuiHelper guiHelper, ItemStack iconStack, Component localizedName) {
        this.overlay = guiHelper.createDrawable(ResourceLocationHelper.prefix("textures/gui/pure_daisy_overlay.png"), 0, 0, 64, 44);
        this.background = guiHelper.createBlankDrawable(96, 44);
        this.localizedName = localizedName;
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)iconStack);
        this.iconStack = iconStack;
    }

    @NotNull
    public Component getTitle() {
        return this.localizedName;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    protected abstract RecipeType<T> recipeType();

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull OrechidRecipe recipe, @NotNull IFocusGroup focusGroup) {
        builder.addSlot(RecipeIngredientRole.INPUT, 9, 12).addItemStacks(recipe.getInput().getDisplayedStacks());
        builder.addSlot(RecipeIngredientRole.CATALYST, 39, 12).addItemStack(this.iconStack);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 68, 12).addItemStacks(recipe.getOutput().getDisplayedStacks())).addTooltipCallback((view, tooltip) -> tooltip.addAll(recipe.getOutput().descriptionTooltip()));
    }

    public void draw(@NotNull OrechidRecipe recipe, @NotNull IRecipeSlotsView view, @NotNull PoseStack ms, double mouseX, double mouseY) {
        RenderSystem.m_69478_();
        this.overlay.draw(ms, 17, 0);
        RenderSystem.m_69461_();
    }
}

