/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.nyfsspiders.common.entity.movement;

import com.nyfaria.nyfsspiders.CommonClass;
import com.nyfaria.nyfsspiders.common.entity.movement.AdvancedPathFinder;
import com.nyfaria.nyfsspiders.common.entity.movement.AdvancedWalkNodeProcessor;
import com.nyfaria.nyfsspiders.common.entity.movement.IAdvancedPathFindingEntity;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class AdvancedGroundPathNavigator<T extends Mob>
extends GroundPathNavigation {
    protected AdvancedPathFinder f_26512_;
    protected long lastTimeUpdated;
    protected BlockPos f_26509_;
    protected final T advancedPathFindingEntity;
    protected final boolean checkObstructions;
    protected int stuckCheckTicks = 0;
    protected int checkpointRange;

    public AdvancedGroundPathNavigator(T entity, Level worldIn) {
        this(entity, worldIn, true);
    }

    public AdvancedGroundPathNavigator(T entity, Level worldIn, boolean checkObstructions) {
        super(entity, worldIn);
        this.advancedPathFindingEntity = entity;
        this.checkObstructions = checkObstructions;
        if (this.f_26508_ instanceof AdvancedWalkNodeProcessor) {
            AdvancedWalkNodeProcessor processor = (AdvancedWalkNodeProcessor)this.f_26508_;
            processor.setCheckObstructions(checkObstructions);
        }
    }

    public AdvancedPathFinder getAssignedPathFinder() {
        return this.f_26512_;
    }

    protected final PathFinder m_5532_(int maxExpansions) {
        this.f_26512_ = this.createAdvancedPathFinder(maxExpansions);
        this.f_26508_ = this.f_26512_.getNodeProcessor();
        return this.f_26512_;
    }

    protected AdvancedPathFinder createAdvancedPathFinder(int maxExpansions) {
        AdvancedWalkNodeProcessor nodeProcessor = new AdvancedWalkNodeProcessor();
        nodeProcessor.m_77351_(true);
        return new AdvancedPathFinder((NodeEvaluator)nodeProcessor, maxExpansions);
    }

    @Nullable
    protected Path m_26551_(Set<BlockPos> waypoints, int padding, boolean startAbove, int checkpointRange) {
        HashSet<BlockPos> adjustedWaypoints = new HashSet<BlockPos>();
        for (BlockPos pos : waypoints) {
            adjustedWaypoints.add(pos.m_7918_(-Mth.m_14167_((float)this.f_26494_.m_20205_()) + 1, -Mth.m_14167_((float)this.f_26494_.m_20206_()) + 1, -Mth.m_14167_((float)this.f_26494_.m_20205_()) + 1));
        }
        Path path = super.m_26551_(adjustedWaypoints, padding, startAbove, checkpointRange);
        if (path != null && path.m_77406_() != null) {
            this.checkpointRange = checkpointRange;
        }
        return path;
    }

    public void m_26569_() {
        if (this.f_26495_.m_46467_() - this.lastTimeUpdated > 20L) {
            if (this.f_26509_ != null) {
                this.f_26496_ = null;
                this.f_26496_ = this.m_7864_(this.f_26509_, this.checkpointRange);
                this.lastTimeUpdated = this.f_26495_.m_46467_();
                this.f_26506_ = false;
            }
        } else {
            this.f_26506_ = true;
        }
    }

    protected void m_6481_(Vec3 entityPos) {
        super.m_6481_(entityPos);
        if (this.checkObstructions && this.f_26496_ != null && !this.f_26496_.m_77392_()) {
            Vec3 target = this.f_26496_.m_77382_(this.advancedPathFindingEntity, Math.min(this.f_26496_.m_77398_() - 1, this.f_26496_.m_77399_() + 0));
            Vec3 diff = target.m_82546_(entityPos);
            int axis = 0;
            double maxDiff = 0.0;
            for (int i = 0; i < 3; ++i) {
                double d = switch (i) {
                    default -> Math.abs(diff.f_82479_);
                    case 1 -> Math.abs(diff.f_82480_);
                    case 2 -> Math.abs(diff.f_82481_);
                };
                if (!(d > maxDiff)) continue;
                axis = i;
                maxDiff = d;
            }
            int height = Mth.m_14143_((float)(this.advancedPathFindingEntity.m_20206_() + 1.0f));
            int ceilHalfWidth = Mth.m_14167_((float)(this.advancedPathFindingEntity.m_20205_() / 2.0f + 0.05f));
            Vec3 facingDiff = (switch (axis) {
                default -> new Vec3(entityPos.f_82479_ + Math.signum(diff.f_82479_) * (double)ceilHalfWidth, entityPos.f_82480_, target.f_82481_);
                case 1 -> new Vec3(entityPos.f_82479_, entityPos.f_82480_ + (double)(diff.f_82480_ > 0.0 ? height + 1 : -1), target.f_82481_);
                case 2 -> new Vec3(target.f_82479_, entityPos.f_82480_, entityPos.f_82481_ + Math.signum(diff.f_82481_) * (double)ceilHalfWidth);
            }).m_82546_(entityPos.m_82520_(0.0, axis == 1 ? (double)(this.f_26494_.m_20206_() / 2.0f) : 0.0, 0.0));
            Direction facing = Direction.m_122372_((float)((float)facingDiff.f_82479_), (float)((float)facingDiff.f_82480_), (float)((float)facingDiff.f_82481_));
            boolean blocked = false;
            AABB checkBox = this.advancedPathFindingEntity.m_20191_().m_82363_(Math.signum(diff.f_82479_) * 0.2, Math.signum(diff.f_82480_) * 0.2, Math.signum(diff.f_82481_) * 0.2);
            block9: for (int yo = 0; yo < height; ++yo) {
                for (int xzo = -ceilHalfWidth; xzo <= ceilHalfWidth; ++xzo) {
                    VoxelShape collisionShape;
                    BlockPathTypes nodeType;
                    BlockPos pos = CommonClass.blockPos(checkPos.f_82479_ + (double)(axis != 0 ? xzo : 0), checkPos.f_82480_ + (double)(axis != 1 ? yo : 0), checkPos.f_82481_ + (double)(axis != 2 ? xzo : 0));
                    BlockState state = this.advancedPathFindingEntity.m_9236_().m_8055_(pos);
                    BlockPathTypes blockPathTypes = nodeType = state.m_60647_((BlockGetter)this.advancedPathFindingEntity.m_9236_(), pos, PathComputationType.LAND) ? BlockPathTypes.OPEN : BlockPathTypes.BLOCKED;
                    if (nodeType != BlockPathTypes.BLOCKED || (collisionShape = state.m_60651_((BlockGetter)this.advancedPathFindingEntity.m_9236_(), pos, CollisionContext.m_82750_(this.advancedPathFindingEntity)).m_83216_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_())) == null || !collisionShape.m_83299_().stream().anyMatch(aabb -> aabb.m_82381_(checkBox))) continue;
                    blocked = true;
                    break block9;
                }
            }
            if (blocked) {
                ++this.stuckCheckTicks;
                if (this.stuckCheckTicks > ((IAdvancedPathFindingEntity)this.advancedPathFindingEntity).getMaxStuckCheckTicks()) {
                    ((IAdvancedPathFindingEntity)this.advancedPathFindingEntity).onPathingObstructed(facing);
                    this.stuckCheckTicks = 0;
                }
            } else {
                this.stuckCheckTicks = Math.max(this.stuckCheckTicks - 2, 0);
            }
        } else {
            this.stuckCheckTicks = Math.max(this.stuckCheckTicks - 4, 0);
        }
    }
}

