/*
 * Decompiled with CFR 0.152.
 */
package net.wizards.villager;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import net.fabric_extras.structure_pool.api.StructurePoolAPI;
import net.fabric_extras.structure_pool.api.StructurePoolConfig;
import net.fabricmc.fabric.api.object.builder.v1.trade.TradeOfferHelper;
import net.fabricmc.fabric.api.object.builder.v1.world.poi.PointOfInterestHelper;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.runes.api.RuneItems;
import net.runes.crafting.RuneCraftingBlock;
import net.wizards.WizardsMod;
import net.wizards.item.Armors;
import net.wizards.item.Weapons;
import net.wizards.item.WizardArmor;

public class WizardVillagers {
    public static final String WIZARD_MERCHANT = "wizard_merchant";

    public static PoiType registerPOI(String name, Block block) {
        return PointOfInterestHelper.register((ResourceLocation)new ResourceLocation("wizards", name), (int)1, (int)10, (Iterable)ImmutableSet.copyOf((Collection)block.m_49965_().m_61056_()));
    }

    public static VillagerProfession registerProfession(String name, ResourceKey<PoiType> workStation) {
        ResourceLocation id = new ResourceLocation("wizards", name);
        return (VillagerProfession)Registry.m_122965_((Registry)BuiltInRegistries.f_256735_, (ResourceLocation)new ResourceLocation("wizards", name), (Object)new VillagerProfession(id.toString(), entry -> entry.m_203565_(workStation), entry -> entry.m_203565_(workStation), ImmutableSet.of(), ImmutableSet.of(), WizardArmor.equipSound));
    }

    public static void register() {
        StructurePoolAPI.injectAll((StructurePoolConfig)((StructurePoolConfig)WizardsMod.villageConfig.value));
        PoiType poi = WizardVillagers.registerPOI(WIZARD_MERCHANT, (Block)RuneCraftingBlock.INSTANCE);
        VillagerProfession profession = WizardVillagers.registerProfession(WIZARD_MERCHANT, (ResourceKey<PoiType>)ResourceKey.m_135785_((ResourceKey)BuiltInRegistries.f_256941_.m_123023_(), (ResourceLocation)new ResourceLocation("wizards", WIZARD_MERCHANT)));
        List<Offer> wizardMerchantOffers = List.of(Offer.sell(1, new ItemStack((ItemLike)RuneItems.get((RuneItems.RuneType)RuneItems.RuneType.ARCANE), 8), 2, 128, 1, 0.01f), Offer.sell(1, new ItemStack((ItemLike)RuneItems.get((RuneItems.RuneType)RuneItems.RuneType.FIRE), 8), 2, 128, 1, 0.01f), Offer.sell(1, new ItemStack((ItemLike)RuneItems.get((RuneItems.RuneType)RuneItems.RuneType.FROST), 8), 2, 128, 1, 0.01f), Offer.sell(2, Weapons.wizardStaff.item().m_7968_(), 4, 12, 5, 0.1f), Offer.sell(2, Weapons.noviceWand.item().m_7968_(), 4, 12, 5, 0.1f), Offer.sell(2, Weapons.arcaneWand.item().m_7968_(), 18, 12, 8, 0.1f), Offer.sell(2, Weapons.fireWand.item().m_7968_(), 18, 12, 8, 0.1f), Offer.sell(2, Weapons.frostWand.item().m_7968_(), 18, 12, 8, 0.1f), Offer.buy(2, new ItemStack((ItemLike)Items.f_41870_, 5), 8, 12, 10, 0.05f), Offer.buy(2, new ItemStack((ItemLike)Items.f_42534_, 6), 12, 3, 10, 0.05f), Offer.sell(3, Armors.wizardRobeSet.head.m_7968_(), 15, 12, 13, 0.05f), Offer.sell(3, Armors.wizardRobeSet.feet.m_7968_(), 15, 12, 13, 0.05f), Offer.sell(4, Armors.wizardRobeSet.chest.m_7968_(), 20, 12, 15, 0.05f), Offer.sell(4, Armors.wizardRobeSet.legs.m_7968_(), 20, 12, 15, 0.05f));
        for (Offer offer : wizardMerchantOffers) {
            TradeOfferHelper.registerVillagerOffers((VillagerProfession)profession, (int)offer.level, factories -> factories.add((entity, random) -> new MerchantOffer(offer.input, offer.output, offer.maxUses, offer.experience, offer.priceMultiplier)));
        }
        TradeOfferHelper.registerVillagerOffers((VillagerProfession)profession, (int)5, factories -> {
            factories.add((entity, random) -> new VillagerTrades.EnchantedItemForEmeralds(Weapons.arcaneStaff.item(), 40, 3, 30, 0.0f).m_213663_(entity, random));
            factories.add((entity, random) -> new VillagerTrades.EnchantedItemForEmeralds(Weapons.fireStaff.item(), 40, 3, 30, 0.0f).m_213663_(entity, random));
            factories.add((entity, random) -> new VillagerTrades.EnchantedItemForEmeralds(Weapons.frostStaff.item(), 40, 3, 30, 0.0f).m_213663_(entity, random));
        });
    }

    private static class Offer {
        int level;
        ItemStack input;
        ItemStack output;
        int maxUses;
        int experience;
        float priceMultiplier;

        public Offer(int level, ItemStack input, ItemStack output, int maxUses, int experience, float priceMultiplier) {
            this.level = level;
            this.input = input;
            this.output = output;
            this.maxUses = maxUses;
            this.experience = experience;
            this.priceMultiplier = priceMultiplier;
        }

        public static Offer buy(int level, ItemStack item, int price, int maxUses, int experience, float priceMultiplier) {
            return new Offer(level, item, new ItemStack((ItemLike)Items.f_42616_, price), maxUses, experience, priceMultiplier);
        }

        public static Offer sell(int level, ItemStack item, int price, int maxUses, int experience, float priceMultiplier) {
            return new Offer(level, new ItemStack((ItemLike)Items.f_42616_, price), item, maxUses, experience, priceMultiplier);
        }
    }
}

