/*
 * Decompiled with CFR 0.152.
 */
package net.wizards.util;

import java.util.List;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.wizards.effect.FrostShieldStatusEffect;
import net.wizards.item.WizardArmor;

public class SoundHelper {
    public static List<String> soundKeys = List.of("arcane_missile_release", "arcane_missile_impact", "arcane_blast_release", "arcane_blast_impact", "arcane_beam_start", "arcane_beam_casting", "arcane_beam_impact", "arcane_beam_release", "fire_scorch_impact", "fireball_impact", "fire_breath_start", "fire_breath_casting", "fire_breath_release", "fire_breath_impact", "fire_meteor_release", "fire_meteor_impact", "fire_wall_ignite", "frost_shard_impact", "frost_nova_release", "frost_nova_damage_impact", "frost_nova_effect_impact", "frost_shield_release", "frost_blizzard_casting");
    public static Map<String, Float> soundDistances = Map.of("fire_meteor_impact", Float.valueOf(48.0f));

    public static void registerSounds() {
        for (String soundKey : soundKeys) {
            ResourceLocation soundId = new ResourceLocation("wizards", soundKey);
            Float customTravelDistance = soundDistances.get(soundKey);
            SoundEvent soundEvent = customTravelDistance == null ? SoundEvent.m_262824_((ResourceLocation)soundId) : SoundEvent.m_262856_((ResourceLocation)soundId, (float)customTravelDistance.floatValue());
            Registry.m_122965_((Registry)BuiltInRegistries.f_256894_, (ResourceLocation)soundId, (Object)soundEvent);
        }
        Registry.m_122965_((Registry)BuiltInRegistries.f_256894_, (ResourceLocation)FrostShieldStatusEffect.soundId, (Object)FrostShieldStatusEffect.sound);
        Registry.m_122965_((Registry)BuiltInRegistries.f_256894_, (ResourceLocation)WizardArmor.equipSoundId, (Object)WizardArmor.equipSound);
    }

    public static void playSoundEvent(Level world, Entity entity, SoundEvent soundEvent) {
        SoundHelper.playSoundEvent(world, entity, soundEvent, 1.0f, 1.0f);
    }

    public static void playSoundEvent(Level world, Entity entity, SoundEvent soundEvent, float volume, float pitch) {
        world.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), soundEvent, SoundSource.PLAYERS, volume, pitch);
    }
}

