/*
 * Decompiled with CFR 0.152.
 */
package net.wizards.item;

import java.util.ArrayList;
import java.util.Map;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.spell_engine.api.item.ItemConfig;
import net.spell_engine.api.item.weapon.StaffItem;
import net.spell_engine.api.item.weapon.Weapon;
import net.spell_power.api.SpellSchools;
import net.wizards.WizardsMod;
import net.wizards.config.TweaksConfig;
import net.wizards.item.Group;

public class Weapons {
    public static final ArrayList<Weapon.Entry> entries = new ArrayList();
    private static final String BETTER_END = "betterend";
    private static final String BETTER_NETHER = "betternether";
    private static final float wandAttackDamage = 2.0f;
    private static final float wandAttackSpeed = -2.4f;
    public static final Weapon.Entry noviceWand = Weapons.wand("wand_novice", Weapon.CustomMaterial.matching((Tiers)Tiers.WOOD, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42398_}))).attribute(ItemConfig.Attribute.bonus((ResourceLocation)SpellSchools.FIRE.id, (float)1.0f));
    public static final Weapon.Entry arcaneWand = Weapons.wand("wand_arcane", Weapon.CustomMaterial.matching((Tiers)Tiers.IRON, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42417_}))).attribute(ItemConfig.Attribute.bonus((ResourceLocation)SpellSchools.ARCANE.id, (float)2.0f));
    public static final Weapon.Entry fireWand = Weapons.wand("wand_fire", Weapon.CustomMaterial.matching((Tiers)Tiers.IRON, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42417_}))).attribute(ItemConfig.Attribute.bonus((ResourceLocation)SpellSchools.FIRE.id, (float)2.0f));
    public static final Weapon.Entry frostWand = Weapons.wand("wand_frost", Weapon.CustomMaterial.matching((Tiers)Tiers.IRON, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42416_}))).attribute(ItemConfig.Attribute.bonus((ResourceLocation)SpellSchools.FROST.id, (float)2.0f));
    public static final Weapon.Entry netheriteArcaneWand = Weapons.wand("wand_netherite_arcane", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42418_}))).attribute(ItemConfig.Attribute.bonus((ResourceLocation)SpellSchools.ARCANE.id, (float)3.0f));
    public static final Weapon.Entry netheriteFireWand = Weapons.wand("wand_netherite_fire", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42418_}))).attribute(ItemConfig.Attribute.bonus((ResourceLocation)SpellSchools.FIRE.id, (float)3.0f));
    public static final Weapon.Entry netheriteFrostWand = Weapons.wand("wand_netherite_frost", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42418_}))).attribute(ItemConfig.Attribute.bonus((ResourceLocation)SpellSchools.FROST.id, (float)3.0f));
    private static final float staffAttackDamage = 4.0f;
    private static final float staffAttackSpeed = -3.0f;
    public static final Weapon.Entry wizardStaff = Weapons.staff("staff_wizard", Weapon.CustomMaterial.matching((Tiers)Tiers.IRON, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42398_}))).attribute(ItemConfig.Attribute.bonus((ResourceLocation)SpellSchools.ARCANE.id, (float)3.0f)).attribute(ItemConfig.Attribute.bonus((ResourceLocation)SpellSchools.FIRE.id, (float)3.0f)).attribute(ItemConfig.Attribute.bonus((ResourceLocation)SpellSchools.FROST.id, (float)3.0f));
    public static final Weapon.Entry arcaneStaff = Weapons.staff("staff_arcane", Weapon.CustomMaterial.matching((Tiers)Tiers.DIAMOND, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42417_}))).attribute(ItemConfig.Attribute.bonus((ResourceLocation)SpellSchools.ARCANE.id, (float)4.0f));
    public static final Weapon.Entry fireStaff = Weapons.staff("staff_fire", Weapon.CustomMaterial.matching((Tiers)Tiers.DIAMOND, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42417_}))).attribute(ItemConfig.Attribute.bonus((ResourceLocation)SpellSchools.FIRE.id, (float)4.0f));
    public static final Weapon.Entry frostStaff = Weapons.staff("staff_frost", Weapon.CustomMaterial.matching((Tiers)Tiers.DIAMOND, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42416_}))).attribute(ItemConfig.Attribute.bonus((ResourceLocation)SpellSchools.FROST.id, (float)4.0f));
    public static final Weapon.Entry netheriteArcaneStaff = Weapons.staff("staff_netherite_arcane", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42418_}))).attribute(ItemConfig.Attribute.bonus((ResourceLocation)SpellSchools.ARCANE.id, (float)5.0f));
    public static final Weapon.Entry netheriteFireStaff = Weapons.staff("staff_netherite_fire", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42418_}))).attribute(ItemConfig.Attribute.bonus((ResourceLocation)SpellSchools.FIRE.id, (float)5.0f));
    public static final Weapon.Entry netheriteFrostStaff = Weapons.staff("staff_netherite_frost", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42418_}))).attribute(ItemConfig.Attribute.bonus((ResourceLocation)SpellSchools.FROST.id, (float)5.0f));

    private static Weapon.Entry entry(String name, Weapon.CustomMaterial material, Item item, ItemConfig.Weapon defaults) {
        return Weapons.entry(null, name, material, item, defaults);
    }

    private static Weapon.Entry entry(String requiredMod, String name, Weapon.CustomMaterial material, Item item, ItemConfig.Weapon defaults) {
        Weapon.Entry entry = new Weapon.Entry("wizards", name, material, item, defaults, null);
        if (entry.isRequiredModInstalled()) {
            entries.add(entry);
        }
        return entry;
    }

    private static Supplier<Ingredient> ingredient(String idString, boolean requirement, Item fallback) {
        ResourceLocation id = new ResourceLocation(idString);
        if (requirement) {
            return () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{fallback});
        }
        return () -> {
            Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(id);
            Item ingredient = item != null ? item : fallback;
            return Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient});
        };
    }

    private static Weapon.Entry wand(String name, Weapon.CustomMaterial material) {
        Item.Properties settings = new Item.Properties();
        StaffItem item = new StaffItem((Tier)material, settings);
        return Weapons.entry(name, material, (Item)item, new ItemConfig.Weapon(2.0f, -2.4f));
    }

    private static Weapon.Entry staff(String name, Weapon.CustomMaterial material) {
        return Weapons.staff(null, name, material);
    }

    private static Weapon.Entry staff(String requiredMod, String name, Weapon.CustomMaterial material) {
        Item.Properties settings = new Item.Properties();
        StaffItem item = new StaffItem((Tier)material, settings);
        return Weapons.entry(requiredMod, name, material, (Item)item, new ItemConfig.Weapon(4.0f, -3.0f));
    }

    public static void register(Map<String, ItemConfig.Weapon> configs) {
        Supplier<Ingredient> repair;
        if (((TweaksConfig)WizardsMod.tweaksConfig.value).ignore_items_required_mods || FabricLoader.getInstance().isModLoaded(BETTER_NETHER)) {
            repair = Weapons.ingredient("betternether:nether_ruby", FabricLoader.getInstance().isModLoaded(BETTER_NETHER), Items.f_42418_);
            Weapons.staff("staff_ruby_fire", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair)).attribute(ItemConfig.Attribute.bonus((ResourceLocation)SpellSchools.FIRE.id, (float)6.0f));
        }
        if (((TweaksConfig)WizardsMod.tweaksConfig.value).ignore_items_required_mods || FabricLoader.getInstance().isModLoaded(BETTER_END)) {
            repair = Weapons.ingredient("betterend:aeternium_ingot", FabricLoader.getInstance().isModLoaded(BETTER_END), Items.f_42418_);
            Weapons.staff("staff_crystal_arcane", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair)).attribute(ItemConfig.Attribute.bonus((ResourceLocation)SpellSchools.ARCANE.id, (float)6.0f));
            Weapons.staff("staff_smaragdant_frost", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair)).attribute(ItemConfig.Attribute.bonus((ResourceLocation)SpellSchools.FROST.id, (float)6.0f));
        }
        Weapon.register(configs, entries, Group.KEY);
    }
}

