/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import vazkii.botania.common.helper.EthicalTntHelper;
import vazkii.botania.common.helper.ForcePushHelper;

@Mixin(value={PistonBaseBlock.class}, priority=999)
public abstract class PistonBaseBlockMixin {
    @Inject(at={@At(value="HEAD")}, method={"moveBlocks(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;Z)Z"})
    private void preMoveBlocks(Level level, BlockPos pos, Direction dir, boolean extending, CallbackInfoReturnable<Boolean> cir) {
        if (!level.m_5776_()) {
            EthicalTntHelper.startTrackingTntEntities();
            ForcePushHelper.pushMovementTypeContext(extending);
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"moveBlocks(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;Z)Z"})
    private void postMoveBlocks(Level level, BlockPos pos, Direction dir, boolean extending, CallbackInfoReturnable<Boolean> cir) {
        if (!level.m_5776_()) {
            ForcePushHelper.popMovementTypeContext();
            EthicalTntHelper.endTrackingTntEntitiesAndCheck();
        }
    }

    @ModifyVariable(method={"moveBlocks"}, at=@At(value="LOAD", ordinal=4), ordinal=0, argsOnly=true)
    private boolean isExtendingNonForcePusher(boolean extending) {
        return !ForcePushHelper.isForcePush() && extending;
    }
}

