/*
 * Decompiled with CFR 0.152.
 */
package com.philip.philipsruins.configs;

import java.util.ArrayList;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;

public class PhilipRuinsCommonConfigs {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec FORGE_SPEC;
    public static final ForgeConfigSpec.ConfigValue<Integer> STRUCTURE_SEPARATION;
    public static final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_CONFIGS;
    public static final ForgeConfigSpec.ConfigValue<Long> STRUCTURE_SPAWN_SEED;
    public static final ForgeConfigSpec.ConfigValue<Integer> STRUCTURE_DENSITY;
    public static final ForgeConfigSpec.ConfigValue<Boolean> AncientLandRuins;
    public static final ForgeConfigSpec.ConfigValue<Boolean> OceanRuins;
    public static final ForgeConfigSpec.ConfigValue<Boolean> UndergroundRuins;
    private static final ArrayList<String> DISABLE_COMMANDS;

    public static void onLoad(ModConfigEvent.Loading event) {
        if (((Boolean)AncientLandRuins.get()).booleanValue()) {
            DISABLE_COMMANDS.add("locate structure philipsruins:ancient_ruins");
            DISABLE_COMMANDS.add("locate structure philipsruins:ancient_crypt");
            DISABLE_COMMANDS.add("locate structure philipsruins:antiquus_crypta");
            DISABLE_COMMANDS.add("locate structure philipsruins:level_one_ruins");
            DISABLE_COMMANDS.add("locate structure philipsruins:level_two_ruins");
            DISABLE_COMMANDS.add("locate structure philipsruins:level_three_ruins");
            DISABLE_COMMANDS.add("locate structure philipsruins:desert_structures");
            DISABLE_COMMANDS.add("locate structure philipsruins:badlands_start_dungeon");
            DISABLE_COMMANDS.add("locate structure philipsruins:badlands_structures");
            DISABLE_COMMANDS.add("locate structure philipsruins:field_stone_ruins");
            DISABLE_COMMANDS.add("locate structure philipsruins:field_stone_ruins_rocks");
            DISABLE_COMMANDS.add("locate structure philipsruins:level_two_ruins_pool");
            DISABLE_COMMANDS.add("locate structure philipsruins:pumpkin_ruins");
        }
        if (((Boolean)OceanRuins.get()).booleanValue()) {
            DISABLE_COMMANDS.add("locate structure philipsruins:ocean_fortress");
            DISABLE_COMMANDS.add("locate structure philipsruins:ocean_ruins");
        }
        if (((Boolean)UndergroundRuins.get()).booleanValue()) {
            DISABLE_COMMANDS.add("locate structure philipsruins:lost_soul_city");
            DISABLE_COMMANDS.add("locate structure philipsruins:lost_soul_dungeon");
            DISABLE_COMMANDS.add("locate structure philipsruins:underground_structures");
        }
    }

    public static boolean isCommandDisabled(String command) {
        for (String value : DISABLE_COMMANDS) {
            if (!command.equalsIgnoreCase(value)) continue;
            return true;
        }
        return false;
    }

    public static void registerConfigs(ModConfig.Type configType) {
        ModLoadingContext.get().registerConfig(configType, (IConfigSpec)FORGE_SPEC, "philips-ruins-common-configs.toml");
    }

    static {
        DISABLE_COMMANDS = new ArrayList();
        String builder = "Tell the game if to use configs for the ruins.\nBy default it is disable, you need to enable it. Make sure you restart the game after editing.\nPlease note that if you use this config file it will override the default spawn weights.\nSettings apply for most structures. ";
        BUILDER.push("Philip's Ruins");
        ENABLE_CONFIGS = BUILDER.comment(builder).define("Enable Configs", false);
        STRUCTURE_SEPARATION = BUILDER.comment("The structure spawn Separation. The larger the value less of the structure will spawn. Max is 100").define("Structure Separation", (Object)10);
        STRUCTURE_DENSITY = BUILDER.comment("Controls the density.\nThe larger the value the more structures will spawn.\n(Must be less than separation)").define("Structure Density", (Object)9);
        STRUCTURE_SPAWN_SEED = BUILDER.comment("Seed for structures.").define("Structure Spawn Seed", (Object)1L);
        AncientLandRuins = BUILDER.comment("Set true to disable ruins.\nThis will disable the following\nstructure philipsruins:ancient_ruins\nstructure philipsruins:ancient_crypt\nstructure philipsruins:level_one_ruins\nstructure philipsruins:level_two_ruins\nstructure philipsruins:level_three_ruins\nstructure philipsruins:desert_structures\nstructure philipsruins:badlands_start_dungeon\nstructure philipsruins:badlands_structures\nstructure philipsruins:field_stone_ruins\nstructure philipsruins:field_stone_ruins_rocks\nstructure philipsruins:level_two_ruins_pool\nstructure philipsruins:pumpkin_ruins").define("AncientLandRuins", false);
        OceanRuins = BUILDER.comment("Set true to disable ruins.\nThis will disable the following\nstructure philipsruins:ocean_fortress\nstructure philipsruins:ocean_ruins").define("OceanRuins", false);
        UndergroundRuins = BUILDER.comment("Set true to disable ruins.\nThis will disable the following\nstructure philipsruins:lost_soul_city\nstructure philipsruins:lost_soul_dungeon\nstructure philipsruins:underground_structures").define("UndergroundRuins", false);
        FORGE_SPEC = BUILDER.pop().build();
    }
}

