/*
 * Decompiled with CFR 0.152.
 */
package net.jewelry.village;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import net.fabricmc.fabric.api.object.builder.v1.trade.TradeOfferHelper;
import net.fabricmc.fabric.api.object.builder.v1.world.poi.PointOfInterestHelper;
import net.jewelry.blocks.JewelryBlocks;
import net.jewelry.items.JewelryItems;
import net.jewelry.util.SoundHelper;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class JewelryVillagers {
    public static final String JEWELER = "jeweler";

    public static PoiType registerPOI(String name, Block block) {
        return PointOfInterestHelper.register((ResourceLocation)new ResourceLocation("jewelry", name), (int)1, (int)10, (Iterable)ImmutableSet.copyOf((Collection)block.m_49965_().m_61056_()));
    }

    public static VillagerProfession registerProfession(String name, ResourceKey<PoiType> workStation) {
        ResourceLocation id = new ResourceLocation("jewelry", name);
        return (VillagerProfession)Registry.m_122965_((Registry)BuiltInRegistries.f_256735_, (ResourceLocation)new ResourceLocation("jewelry", name), (Object)new VillagerProfession(id.toString(), entry -> entry.m_203565_(workStation), entry -> entry.m_203565_(workStation), ImmutableSet.of(), ImmutableSet.of(), SoundHelper.JEWELRY_WORKBENCH));
    }

    public static void register() {
        PoiType wizardPOI = JewelryVillagers.registerPOI(JEWELER, JewelryBlocks.JEWELERS_KIT.block());
        VillagerProfession wizardMerchantProfession = JewelryVillagers.registerProfession(JEWELER, (ResourceKey<PoiType>)ResourceKey.m_135785_((ResourceKey)BuiltInRegistries.f_256941_.m_123023_(), (ResourceLocation)new ResourceLocation("jewelry", JEWELER)));
        List<Offer> wizardMerchantOffers = List.of(Offer.buy(1, new ItemStack((ItemLike)Items.f_151052_, 8), 2, 8, 2, 0.1f), Offer.buy(1, new ItemStack((ItemLike)Items.f_42401_, 7), 1, 6, 2, 0.1f), Offer.sell(1, JewelryItems.copper_ring.item().m_7968_(), 4, 12, 3, 0.2f), Offer.buy(2, new ItemStack((ItemLike)Items.f_42417_, 7), 2, 8, 5, 0.1f), Offer.sell(2, JewelryItems.iron_ring.item().m_7968_(), 4, 4, 4, 0.2f), Offer.sell(2, JewelryItems.gold_ring.item().m_7968_(), 18, 4, 5, 0.2f), Offer.buy(3, new ItemStack((ItemLike)Items.f_42415_, 1), 4, 12, 10, 0.05f), Offer.sell(3, JewelryItems.emerald_necklace.item().m_7968_(), 20, 8, 10, 0.2f), Offer.sell(3, JewelryItems.diamond_necklace.item().m_7968_(), 25, 8, 10, 0.2f), Offer.sell(4, JewelryItems.ruby_ring.item().m_7968_(), 35, 5, 13, 0.1f), Offer.sell(4, JewelryItems.topaz_ring.item().m_7968_(), 35, 5, 13, 0.1f), Offer.sell(4, JewelryItems.citrine_ring.item().m_7968_(), 35, 5, 13, 0.1f), Offer.sell(4, JewelryItems.jade_ring.item().m_7968_(), 35, 5, 13, 0.1f), Offer.sell(4, JewelryItems.sapphire_ring.item().m_7968_(), 35, 5, 13, 0.1f), Offer.sell(4, JewelryItems.tanzanite_ring.item().m_7968_(), 35, 5, 13, 0.1f), Offer.sell(5, JewelryItems.ruby_necklace.item().m_7968_(), 45, 3, 13, 0.1f), Offer.sell(5, JewelryItems.topaz_necklace.item().m_7968_(), 45, 3, 13, 0.1f), Offer.sell(5, JewelryItems.citrine_necklace.item().m_7968_(), 45, 3, 13, 0.1f), Offer.sell(5, JewelryItems.jade_necklace.item().m_7968_(), 45, 3, 13, 0.1f), Offer.sell(5, JewelryItems.sapphire_necklace.item().m_7968_(), 45, 3, 13, 0.1f), Offer.sell(5, JewelryItems.tanzanite_necklace.item().m_7968_(), 45, 3, 13, 0.1f));
        for (Offer offer : wizardMerchantOffers) {
            TradeOfferHelper.registerVillagerOffers((VillagerProfession)wizardMerchantProfession, (int)offer.level, factories -> factories.add((entity, random) -> new MerchantOffer(offer.input, offer.output, offer.maxUses, offer.experience, offer.priceMultiplier)));
        }
    }

    private static class Offer {
        int level;
        ItemStack input;
        ItemStack output;
        int maxUses;
        int experience;
        float priceMultiplier;

        public Offer(int level, ItemStack input, ItemStack output, int maxUses, int experience, float priceMultiplier) {
            this.level = level;
            this.input = input;
            this.output = output;
            this.maxUses = maxUses;
            this.experience = experience;
            this.priceMultiplier = priceMultiplier;
        }

        public static Offer buy(int level, ItemStack item, int price, int maxUses, int experience, float priceMultiplier) {
            return new Offer(level, item, new ItemStack((ItemLike)Items.f_42616_, price), maxUses, experience, priceMultiplier);
        }

        public static Offer sell(int level, ItemStack item, int price, int maxUses, int experience, float priceMultiplier) {
            return new Offer(level, new ItemStack((ItemLike)Items.f_42616_, price), item, maxUses, experience, priceMultiplier);
        }
    }
}

