/*
 * Decompiled with CFR 0.152.
 */
package net.jewelry.util;

import java.util.List;
import java.util.Map;
import net.jewelry.config.LootConfig;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.EnchantWithLevelsFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.providers.number.BinomialDistributionGenerator;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class LootHelper {
    public static void configure(ResourceLocation id, LootTable.Builder tableBuilder, LootConfig config, Map<String, Item> entries) {
        List<String> groups = config.loot_tables.get(id.toString());
        if (groups != null) {
            for (String groupName : groups) {
                LootConfig.ItemGroup group = config.item_groups.get(groupName);
                if (group == null || group.ids.isEmpty() || group.weight <= 0) continue;
                float chance = group.chance > 0.0f ? group.chance : 1.0f;
                LootPool.Builder lootPoolBuilder = LootPool.m_79043_();
                lootPoolBuilder.m_165133_((NumberProvider)BinomialDistributionGenerator.m_165659_((int)1, (float)chance));
                lootPoolBuilder.m_165135_((NumberProvider)ConstantValue.m_165692_((float)group.bonus_roll_chance));
                for (String entryId : group.ids) {
                    Item item = entries.get(entryId);
                    if (item == null) continue;
                    LootPoolSingletonContainer.Builder itemEntry = LootItem.m_79579_((ItemLike)item).m_79707_(group.weight);
                    if (group.enchant != null && group.enchant.isValid()) {
                        EnchantWithLevelsFunction.Builder enchantFunction = EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)group.enchant.min_power, (float)group.enchant.max_power));
                        if (group.enchant.allow_treasure) {
                            enchantFunction.m_80499_();
                        }
                        itemEntry.m_79078_((LootItemFunction.Builder)enchantFunction);
                    }
                    lootPoolBuilder.m_79076_((LootPoolEntryContainer.Builder)itemEntry);
                }
                tableBuilder.pool(lootPoolBuilder.m_79082_());
            }
        }
    }
}

