/*
 * Decompiled with CFR 0.152.
 */
package net.jewelry.items;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabric_extras.ranged_weapon.api.EntityAttributes_RangedWeapon;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.jewelry.api.AttributeResolver;
import net.jewelry.api.JewelryItem;
import net.jewelry.config.ItemConfig;
import net.jewelry.items.Group;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.spell_power.api.SpellPowerMechanics;
import net.spell_power.api.SpellSchools;

public class JewelryItems {
    public static final ArrayList<Entry> all = new ArrayList();
    public static final Map<String, Item> entryMap = new HashMap<String, Item>();
    private static final float tier_1_multiplier = 0.04f;
    private static final ItemConfig.Bonus tier_1_bonus = new ItemConfig.Bonus(0.04f, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final float tier_2_multiplier = 0.08f;
    private static final ItemConfig.Bonus tier_2_bonus = new ItemConfig.Bonus(0.08f, AttributeModifier.Operation.MULTIPLY_BASE);
    public static final String GENERIC_ARMOR = "generic.armor";
    public static final String GENERIC_LUCK = "generic.luck";
    public static final String GENERIC_MOVEMENT_SPEED = "generic.movement_speed";
    public static final String GENERIC_ATTACK_DAMAGE = "generic.attack_damage";
    public static final String GENERIC_MAX_HEALTH = "generic.max_health";
    public static final String GENERIC_ATTACK_SPEED = "generic.attack_speed";
    public static final String GENERIC_ARMOR_TOUGHNESS = "generic.armor_toughness";
    public static final String GENERIC_KNOCKBACK_RESISTANCE = "generic.knockback_resistance";
    public static final String COMBATROLL_RECHARGE = "combatroll:recharge";
    public static final String COMBATROLL_COUNT = "combatroll:count";
    public static Entry copper_ring = JewelryItems.add(new ResourceLocation("jewelry", "copper_ring"), new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier("generic.armor", 0.5f, AttributeModifier.Operation.ADDITION))));
    public static Entry iron_ring = JewelryItems.add(new ResourceLocation("jewelry", "iron_ring"), new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier("generic.armor", 1.0f, AttributeModifier.Operation.ADDITION))));
    public static Entry gold_ring = JewelryItems.add(new ResourceLocation("jewelry", "gold_ring"), new ItemConfig.Item(List.of()));
    public static Entry emerald_necklace = JewelryItems.add(new ResourceLocation("jewelry", "emerald_necklace"), new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier("generic.luck", 1.0f, AttributeModifier.Operation.ADDITION))));
    public static Entry diamond_necklace = JewelryItems.add(new ResourceLocation("jewelry", "diamond_necklace"), new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier("generic.movement_speed", 0.1f, AttributeModifier.Operation.MULTIPLY_BASE))));
    public static Entry ruby_ring = JewelryItems.add(new ResourceLocation("jewelry", "ruby_ring"), Rarity.UNCOMMON, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier("generic.attack_damage", 0.04f, AttributeModifier.Operation.MULTIPLY_BASE))));
    public static Entry topaz_ring = JewelryItems.add(new ResourceLocation("jewelry", "topaz_ring"), Rarity.UNCOMMON, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(SpellSchools.ARCANE.id, tier_1_bonus), new ItemConfig.AttributeModifier(SpellSchools.FIRE.id, tier_1_bonus))));
    public static Entry citrine_ring = JewelryItems.add(new ResourceLocation("jewelry", "citrine_ring"), Rarity.UNCOMMON, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(SpellSchools.HEALING.id, tier_1_bonus), new ItemConfig.AttributeModifier(SpellSchools.LIGHTNING.id, tier_1_bonus))));
    public static Entry jade_ring = JewelryItems.add(new ResourceLocation("jewelry", "jade_ring"), Rarity.UNCOMMON, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(EntityAttributes_RangedWeapon.DAMAGE.id, 0.04f, AttributeModifier.Operation.MULTIPLY_BASE))));
    public static Entry sapphire_ring = JewelryItems.add(new ResourceLocation("jewelry", "sapphire_ring"), Rarity.UNCOMMON, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier("generic.max_health", 2.0f, AttributeModifier.Operation.ADDITION))));
    public static Entry tanzanite_ring = JewelryItems.add(new ResourceLocation("jewelry", "tanzanite_ring"), Rarity.UNCOMMON, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(SpellSchools.FROST.id, tier_1_bonus), new ItemConfig.AttributeModifier(SpellSchools.SOUL.id, tier_1_bonus))));
    public static Entry ruby_necklace = JewelryItems.add(new ResourceLocation("jewelry", "ruby_necklace"), Rarity.UNCOMMON, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier("generic.attack_damage", tier_1_bonus))));
    public static Entry topaz_necklace = JewelryItems.add(new ResourceLocation("jewelry", "topaz_necklace"), Rarity.UNCOMMON, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(SpellSchools.ARCANE.id, tier_1_bonus), new ItemConfig.AttributeModifier(SpellSchools.FIRE.id, tier_1_bonus))));
    public static Entry citrine_necklace = JewelryItems.add(new ResourceLocation("jewelry", "citrine_necklace"), Rarity.UNCOMMON, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(SpellSchools.HEALING.id, tier_1_bonus), new ItemConfig.AttributeModifier(SpellSchools.LIGHTNING.id, tier_1_bonus))));
    public static Entry jade_necklace = JewelryItems.add(new ResourceLocation("jewelry", "jade_necklace"), Rarity.UNCOMMON, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(EntityAttributes_RangedWeapon.DAMAGE.id, 0.04f, AttributeModifier.Operation.MULTIPLY_BASE))));
    public static Entry sapphire_necklace = JewelryItems.add(new ResourceLocation("jewelry", "sapphire_necklace"), Rarity.UNCOMMON, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier("generic.max_health", 2.0f, AttributeModifier.Operation.ADDITION))));
    public static Entry tanzanite_necklace = JewelryItems.add(new ResourceLocation("jewelry", "tanzanite_necklace"), Rarity.UNCOMMON, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(SpellSchools.FROST.id, tier_1_bonus), new ItemConfig.AttributeModifier(SpellSchools.SOUL.id, tier_1_bonus))));
    public static Entry netherite_ruby_ring = JewelryItems.add(new ResourceLocation("jewelry", "netherite_ruby_ring"), Rarity.UNCOMMON, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier("generic.attack_damage", tier_2_bonus))));
    public static Entry netherite_topaz_ring = JewelryItems.add(new ResourceLocation("jewelry", "netherite_topaz_ring"), Rarity.UNCOMMON, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(SpellSchools.ARCANE.id, tier_2_bonus), new ItemConfig.AttributeModifier(SpellSchools.FIRE.id, tier_2_bonus))));
    public static Entry netherite_citrine_ring = JewelryItems.add(new ResourceLocation("jewelry", "netherite_citrine_ring"), Rarity.UNCOMMON, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(SpellSchools.HEALING.id, tier_2_bonus), new ItemConfig.AttributeModifier(SpellSchools.LIGHTNING.id, tier_2_bonus))));
    public static Entry netherite_jade_ring = JewelryItems.add(new ResourceLocation("jewelry", "netherite_jade_ring"), Rarity.UNCOMMON, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(EntityAttributes_RangedWeapon.DAMAGE.id, tier_2_bonus))));
    public static Entry netherite_sapphire_ring = JewelryItems.add(new ResourceLocation("jewelry", "netherite_sapphire_ring"), Rarity.UNCOMMON, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier("generic.max_health", 4.0f, AttributeModifier.Operation.ADDITION))));
    public static Entry netherite_tanzanite_ring = JewelryItems.add(new ResourceLocation("jewelry", "netherite_tanzanite_ring"), Rarity.UNCOMMON, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(SpellSchools.FROST.id, tier_2_bonus), new ItemConfig.AttributeModifier(SpellSchools.SOUL.id, tier_2_bonus))));
    public static Entry netherite_ruby_necklace = JewelryItems.add(new ResourceLocation("jewelry", "netherite_ruby_necklace"), Rarity.UNCOMMON, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier("generic.attack_damage", 0.08f, AttributeModifier.Operation.MULTIPLY_BASE))));
    public static Entry netherite_topaz_necklace = JewelryItems.add(new ResourceLocation("jewelry", "netherite_topaz_necklace"), Rarity.UNCOMMON, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(SpellSchools.ARCANE.id, tier_2_bonus), new ItemConfig.AttributeModifier(SpellSchools.FIRE.id, tier_2_bonus))));
    public static Entry netherite_citrine_necklace = JewelryItems.add(new ResourceLocation("jewelry", "netherite_citrine_necklace"), Rarity.UNCOMMON, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(SpellSchools.HEALING.id, tier_2_bonus), new ItemConfig.AttributeModifier(SpellSchools.LIGHTNING.id, tier_2_bonus))));
    public static Entry netherite_jade_necklace = JewelryItems.add(new ResourceLocation("jewelry", "netherite_jade_necklace"), Rarity.UNCOMMON, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(EntityAttributes_RangedWeapon.DAMAGE.id, tier_2_bonus))));
    public static Entry netherite_sapphire_necklace = JewelryItems.add(new ResourceLocation("jewelry", "netherite_sapphire_necklace"), Rarity.UNCOMMON, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier("generic.max_health", 4.0f, AttributeModifier.Operation.ADDITION))));
    public static Entry netherite_tanzanite_necklace = JewelryItems.add(new ResourceLocation("jewelry", "netherite_tanzanite_necklace"), Rarity.UNCOMMON, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(SpellSchools.FROST.id, tier_2_bonus), new ItemConfig.AttributeModifier(SpellSchools.SOUL.id, tier_2_bonus))));
    private static final float tier_3_physical_multiplier = 0.12f;
    private static final ItemConfig.Bonus tier_3_primary_bonus = new ItemConfig.Bonus(0.12f, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final float tier_3_spell_multiplier = 0.08f;
    private static final float tier_3_ranged_multiplier = 0.08f;
    private static final float tier_3_secondary_multiplier = 0.03f;
    private static final ItemConfig.Bonus tier_3_spell_bonus = new ItemConfig.Bonus(0.08f, AttributeModifier.Operation.MULTIPLY_BASE);
    public static Entry unique_attack_ring = JewelryItems.add(new ResourceLocation("jewelry", "unique_attack_ring"), Rarity.RARE, true, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier("generic.attack_damage", tier_3_primary_bonus), new ItemConfig.AttributeModifier("generic.knockback_resistance", 0.1f, AttributeModifier.Operation.MULTIPLY_BASE))));
    public static Entry unique_attack_necklace = JewelryItems.add(new ResourceLocation("jewelry", "unique_attack_necklace"), Rarity.RARE, true, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier("generic.attack_damage", tier_3_primary_bonus), new ItemConfig.AttributeModifier("generic.knockback_resistance", 0.1f, AttributeModifier.Operation.MULTIPLY_BASE))));
    public static Entry unique_dex_ring = JewelryItems.add(new ResourceLocation("jewelry", "unique_dex_ring"), Rarity.RARE, true, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier("generic.attack_speed", 0.06f, AttributeModifier.Operation.MULTIPLY_BASE), new ItemConfig.AttributeModifier("generic.attack_damage", 0.06f, AttributeModifier.Operation.MULTIPLY_BASE), new ItemConfig.AttributeModifier("combatroll:recharge", 0.1f, AttributeModifier.Operation.MULTIPLY_BASE))));
    public static Entry unique_dex_necklace = JewelryItems.add(new ResourceLocation("jewelry", "unique_dex_necklace"), Rarity.RARE, true, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier("generic.attack_speed", 0.06f, AttributeModifier.Operation.MULTIPLY_BASE), new ItemConfig.AttributeModifier("generic.attack_damage", 0.06f, AttributeModifier.Operation.MULTIPLY_BASE), new ItemConfig.AttributeModifier("combatroll:count", 1.0f, AttributeModifier.Operation.ADDITION))));
    public static Entry unique_tank_ring = JewelryItems.add(new ResourceLocation("jewelry", "unique_tank_ring"), Rarity.RARE, true, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier("generic.max_health", 6.0f, AttributeModifier.Operation.ADDITION), new ItemConfig.AttributeModifier("generic.armor_toughness", 1.0f, AttributeModifier.Operation.ADDITION))));
    public static Entry unique_tank_necklace = JewelryItems.add(new ResourceLocation("jewelry", "unique_tank_necklace"), Rarity.RARE, true, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier("generic.max_health", 6.0f, AttributeModifier.Operation.ADDITION), new ItemConfig.AttributeModifier("generic.armor_toughness", 1.0f, AttributeModifier.Operation.ADDITION))));
    public static Entry unique_archer_ring = JewelryItems.add(new ResourceLocation("jewelry", "unique_archer_ring"), Rarity.RARE, true, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(EntityAttributes_RangedWeapon.DAMAGE.id, 0.08f, AttributeModifier.Operation.MULTIPLY_BASE), new ItemConfig.AttributeModifier("combatroll:recharge", 0.1f, AttributeModifier.Operation.MULTIPLY_BASE), new ItemConfig.AttributeModifier(EntityAttributes_RangedWeapon.HASTE.id, 0.04f, AttributeModifier.Operation.MULTIPLY_BASE))));
    public static Entry unique_archer_necklace = JewelryItems.add(new ResourceLocation("jewelry", "unique_archer_necklace"), Rarity.RARE, true, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(EntityAttributes_RangedWeapon.DAMAGE.id, 0.08f, AttributeModifier.Operation.MULTIPLY_BASE), new ItemConfig.AttributeModifier("combatroll:count", 1.0f, AttributeModifier.Operation.ADDITION), new ItemConfig.AttributeModifier(EntityAttributes_RangedWeapon.HASTE.id, 0.04f, AttributeModifier.Operation.MULTIPLY_BASE))));
    public static Entry unique_arcane_ring = JewelryItems.add(new ResourceLocation("jewelry", "unique_arcane_ring"), Rarity.RARE, true, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(SpellSchools.ARCANE.id, 0.08f, AttributeModifier.Operation.MULTIPLY_BASE), new ItemConfig.AttributeModifier(SpellPowerMechanics.CRITICAL_CHANCE.id, 0.03f, AttributeModifier.Operation.MULTIPLY_BASE), new ItemConfig.AttributeModifier(SpellPowerMechanics.HASTE.id, 0.03f, AttributeModifier.Operation.MULTIPLY_BASE))));
    public static Entry unique_arcane_necklace = JewelryItems.add(new ResourceLocation("jewelry", "unique_arcane_necklace"), Rarity.RARE, true, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(SpellSchools.ARCANE.id, 0.08f, AttributeModifier.Operation.MULTIPLY_BASE), new ItemConfig.AttributeModifier(SpellPowerMechanics.CRITICAL_CHANCE.id, 0.03f, AttributeModifier.Operation.MULTIPLY_BASE), new ItemConfig.AttributeModifier(SpellPowerMechanics.HASTE.id, 0.03f, AttributeModifier.Operation.MULTIPLY_BASE))));
    public static Entry unique_fire_ring = JewelryItems.add(new ResourceLocation("jewelry", "unique_fire_ring"), Rarity.RARE, true, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(SpellSchools.FIRE.id, 0.08f, AttributeModifier.Operation.MULTIPLY_BASE), new ItemConfig.AttributeModifier(SpellPowerMechanics.CRITICAL_CHANCE.id, 0.03f, AttributeModifier.Operation.MULTIPLY_BASE), new ItemConfig.AttributeModifier(SpellPowerMechanics.CRITICAL_DAMAGE.id, 0.1f, AttributeModifier.Operation.MULTIPLY_BASE))));
    public static Entry unique_fire_necklace = JewelryItems.add(new ResourceLocation("jewelry", "unique_fire_necklace"), Rarity.RARE, true, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(SpellSchools.FIRE.id, 0.08f, AttributeModifier.Operation.MULTIPLY_BASE), new ItemConfig.AttributeModifier(SpellPowerMechanics.CRITICAL_CHANCE.id, 0.03f, AttributeModifier.Operation.MULTIPLY_BASE), new ItemConfig.AttributeModifier(SpellPowerMechanics.CRITICAL_DAMAGE.id, 0.1f, AttributeModifier.Operation.MULTIPLY_BASE))));
    public static Entry unique_frost_ring = JewelryItems.add(new ResourceLocation("jewelry", "unique_frost_ring"), Rarity.RARE, true, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(SpellSchools.FROST.id, 0.08f, AttributeModifier.Operation.MULTIPLY_BASE), new ItemConfig.AttributeModifier(SpellPowerMechanics.HASTE.id, 0.03f, AttributeModifier.Operation.MULTIPLY_BASE), new ItemConfig.AttributeModifier(SpellPowerMechanics.CRITICAL_DAMAGE.id, 0.1f, AttributeModifier.Operation.MULTIPLY_BASE))));
    public static Entry unique_frost_necklace = JewelryItems.add(new ResourceLocation("jewelry", "unique_frost_necklace"), Rarity.RARE, true, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(SpellSchools.FROST.id, 0.08f, AttributeModifier.Operation.MULTIPLY_BASE), new ItemConfig.AttributeModifier(SpellPowerMechanics.HASTE.id, 0.03f, AttributeModifier.Operation.MULTIPLY_BASE), new ItemConfig.AttributeModifier(SpellPowerMechanics.CRITICAL_DAMAGE.id, 0.1f, AttributeModifier.Operation.MULTIPLY_BASE))));
    public static Entry unique_healing_ring = JewelryItems.add(new ResourceLocation("jewelry", "unique_healing_ring"), Rarity.RARE, true, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(SpellSchools.HEALING.id, 0.08f, AttributeModifier.Operation.MULTIPLY_BASE), new ItemConfig.AttributeModifier(SpellPowerMechanics.HASTE.id, 0.06f, AttributeModifier.Operation.MULTIPLY_BASE))));
    public static Entry unique_healing_necklace = JewelryItems.add(new ResourceLocation("jewelry", "unique_healing_necklace"), Rarity.RARE, true, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(SpellSchools.HEALING.id, 0.08f, AttributeModifier.Operation.MULTIPLY_BASE), new ItemConfig.AttributeModifier(SpellPowerMechanics.HASTE.id, 0.06f, AttributeModifier.Operation.MULTIPLY_BASE))));
    private static final UUID placeHolderUUID = UUID.randomUUID();

    public static Entry add(ResourceLocation id, ItemConfig.Item config) {
        return JewelryItems.add(id, Rarity.COMMON, config, null);
    }

    public static Entry add(ResourceLocation id, Rarity rarity, ItemConfig.Item config) {
        return JewelryItems.add(id, rarity, config, null);
    }

    public static Entry add(ResourceLocation id, Rarity rarity, boolean addLore, ItemConfig.Item config) {
        return JewelryItems.add(id, rarity, config, addLore ? "item." + id.m_135827_() + "." + id.m_135815_() + ".lore" : null);
    }

    public static Entry add(ResourceLocation id, Rarity rarity, ItemConfig.Item config, String lore) {
        Entry entry = new Entry(id, new JewelryItem((Item.Properties)new FabricItemSettings().rarity(rarity), lore), config);
        all.add(entry);
        entryMap.put(id.toString(), (Item)entry.item());
        return entry;
    }

    public static void register(ItemConfig allConfigs) {
        for (Entry entry : all) {
            ItemConfig.Item itemConfig = allConfigs.items.get(entry.id.toString());
            if (itemConfig == null) {
                itemConfig = entry.config;
                allConfigs.items.put(entry.id.toString(), entry.config);
            }
            ArrayList<JewelryItem.Modifier> modifiers = new ArrayList<JewelryItem.Modifier>();
            for (ItemConfig.AttributeModifier modifier : itemConfig.attributes) {
                Attribute attribute = AttributeResolver.get(new ResourceLocation(modifier.id));
                if (attribute == null) {
                    System.err.println("Failed to resolve EntityAttribute with id: " + modifier.id);
                    continue;
                }
                modifiers.add(new JewelryItem.Modifier(attribute, "Jewelry modifier", modifier.value, modifier.operation));
            }
            entry.item().setConfigurableModifiers(modifiers);
            Registry.m_122965_((Registry)BuiltInRegistries.f_257033_, (ResourceLocation)entry.id(), (Object)((Object)entry.item()));
        }
        ItemGroupEvents.modifyEntriesEvent(Group.KEY).register(content -> {
            for (Entry entry : all) {
                content.m_246326_((ItemLike)entry.item());
            }
        });
    }

    public record Entry(ResourceLocation id, JewelryItem item, ItemConfig.Item config) {
    }
}

