/*
 * Decompiled with CFR 0.152.
 */
package net.jewelry.api;

import com.google.common.collect.Multimap;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.TrinketItem;
import java.util.List;
import java.util.UUID;
import net.jewelry.util.SoundHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class JewelryItem
extends TrinketItem {
    private List<Modifier> configurableModifiers = List.of();
    private final String lore;

    public JewelryItem(Item.Properties settings, String lore) {
        super(settings.m_41487_(1));
        this.lore = lore;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        super.m_7373_(stack, world, tooltip, context);
        if (this.lore != null && !this.lore.isEmpty()) {
            tooltip.add((Component)Component.m_237115_((String)this.lore).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GOLD}));
        }
    }

    public Multimap<Attribute, AttributeModifier> getModifiers(ItemStack stack, SlotReference slot, LivingEntity entity, UUID uuid) {
        Multimap modifiers = super.getModifiers(stack, slot, entity, uuid);
        for (Modifier modifier : this.configurableModifiers) {
            modifiers.put((Object)modifier.attribute, (Object)new AttributeModifier(uuid, modifier.name, (double)modifier.value, modifier.operation));
        }
        return modifiers;
    }

    public void setConfigurableModifiers(List<Modifier> configurableModifiers) {
        this.configurableModifiers = configurableModifiers;
    }

    public void onEquip(ItemStack stack, SlotReference slot, LivingEntity entity) {
        super.onEquip(stack, slot, entity);
        if (entity.m_9236_().m_5776_() && entity.f_19797_ > 100) {
            entity.m_5496_(SoundHelper.JEWELRY_EQUIP, 1.0f, 1.0f);
        }
    }

    public record Modifier(Attribute attribute, String name, float value, AttributeModifier.Operation operation) {
    }
}

