/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity.animal.dweller;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ItemSteerable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import quek.undergarden.entity.animal.dweller.DwellerItemBasedSteering;
import quek.undergarden.entity.animal.dweller.DwellerJumpGoal;
import quek.undergarden.entity.rotspawn.RotspawnMonster;
import quek.undergarden.registry.UGEntityTypes;
import quek.undergarden.registry.UGItems;
import quek.undergarden.registry.UGSoundEvents;

@Mod.EventBusSubscriber(modid="undergarden", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class Dweller
extends Animal
implements ItemSteerable,
Saddleable,
PlayerRideableJumping {
    private static final EntityDataAccessor<Boolean> SADDLE = SynchedEntityData.m_135353_(Dweller.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> BOOST_TIME = SynchedEntityData.m_135353_(Dweller.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final DwellerItemBasedSteering steering = new DwellerItemBasedSteering(this.m_20088_(), BOOST_TIME, SADDLE);
    private float playerJumpPendingScale;
    private boolean isJumping;
    private int wildJumpCooldown;
    @Nullable
    private PanicGoal panicGoal;
    @Nullable
    private DwellerAvoidEntityGoal<?> avoidGoal;

    public Dweller(EntityType<? extends Dweller> type, Level level) {
        super(type, level);
        this.m_274367_(1.0f);
        this.wildJumpCooldown = 300 + this.m_217043_().m_188503_(500);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.panicGoal = new PanicGoal((PathfinderMob)this, 2.5);
        this.f_21345_.m_25352_(1, (Goal)this.panicGoal);
        this.f_21345_.m_25352_(1, (Goal)new TemptGoal((PathfinderMob)this, 1.5, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)UGItems.UNDERBEANS.get(), (ItemLike)UGItems.UNDERBEAN_STICK.get()}), false));
        this.f_21345_.m_25352_(1, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.avoidGoal = new DwellerAvoidEntityGoal<RotspawnMonster>((PathfinderMob)this, RotspawnMonster.class, 12.0f, 2.0, 2.5);
        this.f_21345_.m_25352_(2, this.avoidGoal);
        this.f_21345_.m_25352_(2, (Goal)new DwellerJumpGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, 15.0).m_22268_(Attributes.f_22279_, 0.2);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)UGSoundEvents.DWELLER_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)UGSoundEvents.DWELLER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)UGSoundEvents.DWELLER_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_((SoundEvent)UGSoundEvents.DWELLER_STEP.get(), 0.15f, 1.0f);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob mob) {
        return (AgeableMob)((EntityType)UGEntityTypes.DWELLER.get()).m_20615_(this.m_9236_());
    }

    public boolean m_6898_(ItemStack stack) {
        return Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)UGItems.UNDERBEANS.get()}).test(stack);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        this.steering.addAdditionalSaveData(tag);
        tag.m_128405_("JumpCooldown", this.getWildJumpCooldown());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.steering.readAdditionalSaveData(tag);
        this.setWildJumpCooldown(tag.m_128451_("JumpCooldown"));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(SADDLE, (Object)false);
        this.m_20088_().m_135372_(BOOST_TIME, (Object)0);
    }

    public void m_7350_(EntityDataAccessor<?> data) {
        if (BOOST_TIME.equals(data) && this.m_9236_().m_5776_()) {
            this.steering.onSynced();
        }
        super.m_7350_(data);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.wildJumpCooldown > 0 && !this.m_7132_() && !this.m_20160_()) {
            --this.wildJumpCooldown;
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        boolean isFood = this.m_6898_(player.m_21120_(hand));
        if (!isFood && this.m_6254_() && !this.m_20160_() && !player.m_36341_()) {
            if (!this.m_9236_().m_5776_()) {
                player.m_20329_((Entity)this);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        if (this.m_6254_() && player.m_36341_() && player.m_21120_(hand).m_41619_()) {
            this.m_19998_((ItemLike)Items.f_42450_);
            this.m_216990_((SoundEvent)UGSoundEvents.DWELLER_SADDLE_REMOVE.get());
            this.steering.setSaddle(false);
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        InteractionResult result = super.m_6071_(player, hand);
        if (!result.m_19077_()) {
            ItemStack itemstack = player.m_21120_(hand);
            return itemstack.m_150930_(Items.f_42450_) ? itemstack.m_41647_(player, (LivingEntity)this, hand) : InteractionResult.PASS;
        }
        return result;
    }

    public boolean m_6741_() {
        return this.m_6084_() && !this.m_6162_();
    }

    public void m_5853_(@Nullable SoundSource source) {
        this.steering.setSaddle(true);
        if (source != null) {
            this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12236_, source, 0.5f, 1.0f);
        }
    }

    public boolean m_6254_() {
        return this.steering.hasSaddle();
    }

    public boolean m_6746_() {
        return this.steering.boost(this.m_217043_());
    }

    protected float m_245547_(Player player) {
        return (float)this.m_21133_(Attributes.f_22279_) * this.steering.boostFactor();
    }

    @Nullable
    public LivingEntity m_6688_() {
        LivingEntity living;
        Entity entity = this.m_146895_();
        return entity != null && this.canBeControlledBy(entity) && entity instanceof LivingEntity ? (living = (LivingEntity)entity) : null;
    }

    protected int m_5639_(float distance, float multiplier) {
        return super.m_5639_(distance, multiplier) - 10;
    }

    @SubscribeEvent
    public static void cancelPlayerFallDamage(LivingAttackEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).m_20202_() instanceof Dweller && event.getSource().m_269533_(DamageTypeTags.f_268549_)) {
            event.setCanceled(true);
        }
    }

    private boolean canBeControlledBy(Entity entity) {
        if (this.m_6254_() && entity instanceof Player) {
            Player player = (Player)entity;
            return player.m_21205_().m_150930_((Item)UGItems.UNDERBEAN_STICK.get()) || player.m_21206_().m_150930_((Item)UGItems.UNDERBEAN_STICK.get());
        }
        return false;
    }

    public Vec3 m_20272_(Vec3 vec) {
        AABB aabb = this.m_20197_().isEmpty() ? this.m_20191_() : EntityDimensions.m_20395_((float)1.2f, (float)2.65f).m_20393_(this.m_20182_());
        List list = this.m_9236_().m_183134_((Entity)this, aabb.m_82369_(vec));
        Vec3 vec3 = vec.m_82556_() == 0.0 ? vec : Dweller.m_198894_((Entity)this, (Vec3)vec, (AABB)aabb, (Level)this.m_9236_(), (List)list);
        boolean flag = vec.m_7096_() != vec3.m_7096_();
        boolean flag1 = vec.m_7098_() != vec3.m_7098_();
        boolean flag2 = vec.m_7094_() != vec3.m_7094_();
        boolean flag3 = this.m_20096_() || flag1 && vec.m_7098_() < 0.0;
        float stepHeight = this.getStepHeight();
        if (stepHeight > 0.0f && flag3 && (flag || flag2)) {
            Vec3 vec33;
            Vec3 vec31 = Dweller.m_198894_((Entity)this, (Vec3)new Vec3(vec.m_7096_(), (double)stepHeight, vec.m_7094_()), (AABB)aabb, (Level)this.m_9236_(), (List)list);
            Vec3 vec32 = Dweller.m_198894_((Entity)this, (Vec3)new Vec3(0.0, (double)stepHeight, 0.0), (AABB)aabb.m_82363_(vec.m_7096_(), 0.0, vec.m_7094_()), (Level)this.m_9236_(), (List)list);
            if (vec32.m_7098_() < (double)stepHeight && (vec33 = Dweller.m_198894_((Entity)this, (Vec3)new Vec3(vec.m_7096_(), 0.0, vec.m_7094_()), (AABB)aabb.m_82383_(vec32), (Level)this.m_9236_(), (List)list).m_82549_(vec32)).m_165925_() > vec31.m_165925_()) {
                vec31 = vec33;
            }
            if (vec31.m_165925_() > vec3.m_165925_()) {
                return vec31.m_82549_(Dweller.m_198894_((Entity)this, (Vec3)new Vec3(0.0, -vec31.m_7098_() + vec.m_7098_(), 0.0), (AABB)aabb.m_82383_(vec31), (Level)this.m_9236_(), (List)list));
            }
        }
        return vec3;
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.m_6254_()) {
            this.m_19998_((ItemLike)Items.f_42450_);
        }
    }

    public void m_19956_(Entity passenger, Entity.MoveFunction callback) {
        float ySin = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        float yCos = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        callback.m_20372_(passenger, this.m_20185_() + (double)(0.5f * ySin), this.m_20186_() + this.m_6048_() + passenger.m_6049_() - (double)0.1f, this.m_20189_() - (double)(0.5f * yCos));
    }

    public boolean isJumping() {
        return this.isJumping;
    }

    public void setIsJumping(boolean jumping) {
        this.isJumping = jumping;
    }

    protected void m_274498_(Player player, Vec3 vec) {
        super.m_274498_(player, vec);
        this.steering.tickBoost();
        Vec2 vec2 = this.getRiddenRotation((LivingEntity)player);
        this.m_19915_(vec2.f_82471_, vec2.f_82470_);
        this.f_20883_ = this.f_20885_ = this.m_146908_();
        this.f_19859_ = this.f_20885_;
        if (this.m_6109_() && this.m_20096_()) {
            this.setIsJumping(false);
            if (this.playerJumpPendingScale > 0.0f && !this.isJumping()) {
                this.jump(vec.m_7094_() > 0.0);
            }
            this.playerJumpPendingScale = 0.0f;
        }
    }

    protected Vec2 getRiddenRotation(LivingEntity entity) {
        return new Vec2(entity.m_146909_() * 0.5f, entity.m_146908_());
    }

    public void jump(boolean moveHorizontally) {
        double d0 = this.m_20098_();
        double d1 = d0 + (double)this.m_285755_();
        Vec3 vec3 = this.m_20184_();
        this.m_20334_(vec3.m_7096_(), d1, vec3.m_7094_());
        this.setIsJumping(true);
        this.f_19812_ = true;
        ForgeHooks.onLivingJump((LivingEntity)this);
        if (moveHorizontally) {
            float f = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            float f1 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            this.m_20256_(this.m_20184_().m_82520_((double)(-0.4f * f), 0.0, (double)(0.4f * f1)));
        }
    }

    public void m_7888_(int power) {
        if (this.m_6254_() && this.m_20096_()) {
            this.playerJumpPendingScale = 1.0f;
        }
    }

    public boolean m_7132_() {
        return this.m_6254_() && this.m_6688_() != null;
    }

    public void m_7199_(int pJumpPower) {
        if (this.m_20096_()) {
            this.m_5496_((SoundEvent)UGSoundEvents.DWELLER_JUMP.get(), this.m_6121_(), this.m_6100_());
            this.f_21363_ = -30;
        }
    }

    public void m_8012_() {
    }

    @Nullable
    public PanicGoal getPanicGoal() {
        return this.panicGoal;
    }

    @Nullable
    public DwellerAvoidEntityGoal<?> getAvoidGoal() {
        return this.avoidGoal;
    }

    public int getWildJumpCooldown() {
        return this.wildJumpCooldown;
    }

    public void setWildJumpCooldown(int cooldown) {
        this.wildJumpCooldown = cooldown;
    }

    public static class DwellerAvoidEntityGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        private boolean running;

        public DwellerAvoidEntityGoal(PathfinderMob pMob, Class<T> pEntityClassToAvoid, float pMaxDistance, double pWalkSpeedModifier, double pSprintSpeedModifier) {
            super(pMob, pEntityClassToAvoid, pMaxDistance, pWalkSpeedModifier, pSprintSpeedModifier);
        }

        public void m_8056_() {
            super.m_8056_();
            this.running = true;
        }

        public void m_8041_() {
            super.m_8041_();
            this.running = false;
        }

        public boolean isRunning() {
            return this.running;
        }
    }
}

