/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigDefaultValues;
import net.sweenus.simplyswords.item.custom.LichbladeSwordItem;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class AbilityMethods {
    public static void tickAbilityStormJolt(ItemStack stack, Level world, LivingEntity user, int ability_timer, int skillCooldown, int radius) {
        if (!user.m_9236_().m_5776_()) {
            if (ability_timer == 12 || ability_timer == 13 && user.m_6844_(EquipmentSlot.MAINHAND) == stack) {
                user.m_20256_(user.m_20154_().m_82490_(4.0));
                user.m_20334_(user.m_20184_().f_82479_, 0.0, user.m_20184_().f_82481_);
                user.f_19864_ = true;
                world.m_6269_(null, (Entity)user, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_THUNDER_SHOOT_FLYBY_03.get(), user.m_5720_(), 0.3f, 1.6f);
                user.m_147207_(new MobEffectInstance(MobEffects.f_19596_, 80, 1), (Entity)user);
                user.m_147207_(new MobEffectInstance(MobEffects.f_19599_, 10, 5), (Entity)user);
                if (user instanceof Player) {
                    Player player = (Player)user;
                    player.m_36335_().m_41524_(stack.m_41720_(), skillCooldown);
                }
            }
            if (ability_timer < 5 && user.m_6844_(EquipmentSlot.MAINHAND) == stack) {
                user.m_20334_(0.0, 0.0, 0.0);
                user.f_19864_ = true;
                user.m_147207_(new MobEffectInstance(MobEffects.f_19598_, 80, 1), (Entity)user);
            }
            if (user.f_19797_ % 2 == 0 && user.m_6844_(EquipmentSlot.MAINHAND) == stack) {
                double xpos = user.m_20185_() - (double)(radius + 1);
                double ypos = user.m_20186_();
                double zpos = user.m_20189_() - (double)(radius + 1);
                for (int i = radius * 2; i > 0; --i) {
                    for (int j = radius * 2; j > 0; --j) {
                        float choose = (float)(Math.random() * 1.0);
                        HelperMethods.spawnParticle(world, (ParticleOptions)ParticleTypes.f_175830_, xpos + (double)i + (double)choose, ypos + 0.4, zpos + (double)j + (double)choose, 0.0, 0.1, 0.0);
                        HelperMethods.spawnParticle(world, (ParticleOptions)ParticleTypes.f_123796_, xpos + (double)i + (double)choose, ypos + 0.1, zpos + (double)j + (double)choose, 0.0, 0.0, 0.0);
                        HelperMethods.spawnParticle(world, (ParticleOptions)ParticleTypes.f_123785_, xpos + (double)i + (double)choose, ypos, zpos + (double)j + (double)choose, 0.0, 0.1, 0.0);
                    }
                }
            }
        }
    }

    public static void tickAbilityStorm(ItemStack stack, Level world, LivingEntity user, int ability_timer, int skillCooldown, int radius) {
        if (!user.m_9236_().m_5776_()) {
            int frequency = (int)Config.getFloat("stormFrequency", "UniqueEffects", ConfigDefaultValues.stormFrequency);
            if (user.f_19797_ % frequency == 0) {
                double x = user.m_20185_();
                double y = user.m_20186_();
                double z = user.m_20189_();
                user.m_147207_(new MobEffectInstance(MobEffects.f_19606_, frequency + 5, 5), (Entity)user);
                AABB box = new AABB(x + (double)radius, y + (double)radius, z + (double)radius, x - (double)radius, y - (double)radius, z - (double)radius);
                ServerLevel sworld = (ServerLevel)user.m_9236_();
                for (Entity entity : world.m_6249_((Entity)user, box, EntitySelector.f_20403_)) {
                    LivingEntity ee;
                    float choose = (float)(Math.random() * 1.0);
                    if (!(entity instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(ee = (LivingEntity)entity, user) || !((double)choose > 0.7)) continue;
                    BlockPos stormtarget = ee.m_20183_();
                    ee.m_147207_(new MobEffectInstance((MobEffect)EffectRegistry.FREEZE.get(), frequency + 5, 0), (Entity)user);
                    LightningBolt storm = (LightningBolt)EntityType.f_20465_.m_262496_(sworld, stormtarget, MobSpawnType.TRIGGERED);
                    if (storm != null) {
                        storm.m_20874_(true);
                    }
                    ee.m_6469_(user.m_269291_().m_269104_((Entity)user, (Entity)user), 5.0f);
                }
            }
            if (user.f_19797_ % 5 == 0) {
                double xpos = user.m_20185_() - (double)(radius + 1);
                double ypos = user.m_20186_();
                double zpos = user.m_20189_() - (double)(radius + 1);
                for (int i = radius * 2; i > 0; --i) {
                    for (int j = radius * 2; j > 0; --j) {
                        float choose = (float)(Math.random() * 1.0);
                        HelperMethods.spawnParticle(world, (ParticleOptions)ParticleTypes.f_123796_, xpos + (double)i + (double)choose, ypos + 10.0, zpos + (double)j + (double)choose, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
    }

    public static void tickAbilityThunderBlitz(ItemStack stack, Level world, LivingEntity user, int ability_timer, int ability_timer_max, float abilityDamage, int skillCooldown, int radius) {
        if (!user.m_9236_().m_5776_()) {
            if (ability_timer > ability_timer_max - 42 && ability_timer < ability_timer_max - 40) {
                user.m_20256_(user.m_20154_().m_82490_(6.0));
                user.m_20334_(user.m_20184_().f_82479_, 0.0, user.m_20184_().f_82481_);
                user.f_19864_ = true;
                if (user instanceof Player) {
                    Player player = (Player)user;
                    player.m_36335_().m_41524_(stack.m_41720_(), skillCooldown);
                }
                world.m_6269_(null, (Entity)user, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_THUNDER_SHOOT_IMPACT_02.get(), user.m_5720_(), 0.3f, 1.6f);
            }
            if (ability_timer < 5) {
                user.m_20334_(0.0, 0.0, 0.0);
                user.f_19864_ = true;
                user.m_147207_(new MobEffectInstance(MobEffects.f_19598_, 80, 2), (Entity)user);
            }
            if (user.f_19797_ % 3 == 0 && user.m_6844_(EquipmentSlot.MAINHAND) == stack) {
                AABB box = new AABB(user.m_20185_() + (double)radius, user.m_20186_() + (double)(radius * 2), user.m_20189_() + (double)radius, user.m_20185_() - (double)radius, user.m_20186_() - (double)radius, user.m_20189_() - (double)radius);
                for (Entity entity : world.m_6249_((Entity)user, box, EntitySelector.f_20403_)) {
                    LivingEntity le;
                    if (!(entity instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entity, user)) continue;
                    float choose = (float)(Math.random() * 1.0);
                    if (ability_timer > ability_timer_max - 40) {
                        le.m_6469_(world.m_269111_().m_269104_((Entity)user, (Entity)user), abilityDamage);
                        world.m_6269_(null, (Entity)le, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_POISON_ATTACK_02.get(), le.m_5720_(), 0.1f, choose);
                        continue;
                    }
                    if (ability_timer >= ability_timer_max - 40) continue;
                    le.m_6469_(world.m_269111_().m_269104_((Entity)user, (Entity)user), abilityDamage * 3.0f);
                    world.m_6269_(null, (Entity)le, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_POISON_ATTACK_01.get(), le.m_5720_(), 0.1f, choose);
                }
                double xpos = user.m_20185_() - (double)(radius + 1);
                double ypos = user.m_20186_();
                double zpos = user.m_20189_() - (double)(radius + 1);
                for (int i = radius * 2; i > 0; --i) {
                    for (int j = radius * 2; j > 0; --j) {
                        float choose = (float)(Math.random() * 1.0);
                        HelperMethods.spawnParticle(world, (ParticleOptions)ParticleTypes.f_175830_, xpos + (double)i + (double)choose, ypos + 0.4, zpos + (double)j + (double)choose, 0.0, 0.1, 0.0);
                        HelperMethods.spawnParticle(world, (ParticleOptions)ParticleTypes.f_123796_, xpos + (double)i + (double)choose, ypos + 0.1, zpos + (double)j + (double)choose, 0.0, 0.0, 0.0);
                        HelperMethods.spawnParticle(world, (ParticleOptions)ParticleTypes.f_123785_, xpos + (double)i + (double)choose, ypos, zpos + (double)j + (double)choose, 0.0, 0.1, 0.0);
                    }
                }
            }
        }
    }

    public static void tickAbilitySoulAnguish(ItemStack stack, Level world, LivingEntity user, float abilityDamage, int radius, double lastX, double lastY, double lastZ, float healAmount, LivingEntity abilityTarget) {
        if (!user.m_9236_().m_5776_() && abilityTarget != null) {
            float soundDistance = 0.2f - (float)user.m_20275_(lastX, lastY, lastZ) / 800.0f;
            if (user.f_19797_ % 5 == 0 && user.m_6844_(EquipmentSlot.MAINHAND) == stack) {
                AABB box = new AABB(lastX + (double)radius, lastY + (double)radius, lastZ + (double)radius, lastX - (double)radius, lastY - (double)radius, lastZ - (double)radius);
                for (Entity entity : world.m_6249_((Entity)user, box, EntitySelector.f_20403_)) {
                    if (!(entity instanceof LivingEntity)) continue;
                    LivingEntity le = (LivingEntity)entity;
                    if (!HelperMethods.checkFriendlyFire((LivingEntity)entity, user)) continue;
                    float choose = (float)(Math.random() * 1.0);
                    if (user.m_217043_().m_188503_(100) <= 8) {
                        world.m_6269_(null, (Entity)le, (SoundEvent)SoundRegistry.DARK_SWORD_BREAKS.get(), le.m_5720_(), soundDistance, choose);
                        user.m_5634_(healAmount);
                    }
                    ++((LichbladeSwordItem)stack.m_41720_()).damageTracker;
                    le.m_6469_(user.m_269291_().m_269104_((Entity)user, (Entity)user), abilityDamage);
                }
                world.m_214150_(null, lastX, lastY, lastZ, (SoundEvent)SoundRegistry.DARK_SWORD_BLOCK.get(), user.m_5720_(), soundDistance, 0.3f, 100L);
                double xpos = lastX - (double)(radius + 1);
                double ypos = lastY;
                double zpos = lastZ - (double)(radius + 1);
                world.m_7785_(xpos, ypos, zpos, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_ICE_SHOOT_IMPACT_03.get(), user.m_5720_(), 0.1f, 0.2f, true);
                for (int i = radius * 2; i > 0; --i) {
                    for (int j = radius * 2; j > 0; --j) {
                        float choose = (float)(Math.random() * 1.0);
                        HelperMethods.spawnParticle(world, (ParticleOptions)ParticleTypes.f_123757_, xpos + (double)i + (double)choose, ypos, zpos + (double)j + (double)choose, choose / 3.0f, -0.3, choose / 3.0f);
                        choose = (float)(Math.random() * 1.0);
                        HelperMethods.spawnParticle(world, (ParticleOptions)ParticleTypes.f_123746_, xpos + (double)i + (double)choose, ypos, zpos + (double)j + (double)choose, choose / 3.0f, 0.0, choose / 3.0f);
                    }
                }
            }
        }
    }

    public static void tickAbilityPermafrost(ItemStack stack, Level world, LivingEntity user, int ability_timer, int ability_timer_max, float abilityDamage, int skillCooldown, int radius, double lastX, double lastY, double lastZ) {
        if (!user.m_9236_().m_5776_()) {
            int rradius = radius * 2;
            if (ability_timer < 5) {
                user.m_21253_();
            }
            if (user.f_19797_ % 10 == 0 && user.m_6844_(EquipmentSlot.MAINHAND) == stack) {
                if (user instanceof Player) {
                    Player player = (Player)user;
                    player.m_36324_().m_38703_(0.8f);
                }
                AABB box = new AABB(user.m_20185_() + (double)rradius, user.m_20186_() + (double)radius, user.m_20189_() + (double)rradius, user.m_20185_() - (double)rradius, user.m_20186_() - (double)radius, user.m_20189_() - (double)rradius);
                for (Entity entity : world.m_6249_((Entity)user, box, EntitySelector.f_20403_)) {
                    LivingEntity le;
                    if (!(entity instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entity, user)) continue;
                    if (le.m_21023_(MobEffects.f_19597_)) {
                        int a = le.m_21124_(MobEffects.f_19597_).m_19564_() + 1;
                        if (a < 4) {
                            le.m_147207_(new MobEffectInstance(MobEffects.f_19597_, 120, a), (Entity)user);
                        } else {
                            le.m_147207_(new MobEffectInstance(MobEffects.f_19597_, 120, a - 1), (Entity)user);
                        }
                    } else {
                        le.m_147207_(new MobEffectInstance(MobEffects.f_19597_, 120, 0), (Entity)user);
                    }
                    float choose = (float)(Math.random() * 1.0);
                    world.m_6269_(null, (Entity)le, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_ICE_SHOOT_IMPACT_03.get(), user.m_5720_(), 0.1f, choose);
                    le.m_6469_(world.m_269111_().m_269104_((Entity)user, (Entity)user), abilityDamage * 3.0f);
                }
                double xpos = lastX - (double)(rradius + 1);
                double ypos = lastY;
                double zpos = lastZ - (double)(rradius + 1);
                world.m_7785_(xpos, ypos, zpos, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_ICE_SHOOT_IMPACT_03.get(), user.m_5720_(), 0.1f, 0.2f, true);
                for (int i = rradius * 2; i > 0; --i) {
                    for (int j = rradius * 2; j > 0; --j) {
                        float choose = (float)(Math.random() * 1.0);
                        HelperMethods.spawnParticle(world, (ParticleOptions)ParticleTypes.f_175821_, xpos + (double)i + (double)choose, ypos + 6.0, zpos + (double)j + (double)choose, choose / 3.0f, -0.3, choose / 3.0f);
                        choose = (float)(Math.random() * 1.0);
                        HelperMethods.spawnParticle(world, (ParticleOptions)ParticleTypes.f_123790_, xpos + (double)i + (double)choose, ypos + 6.0, zpos + (double)j + (double)choose, choose / 3.0f, 0.0, choose / 3.0f);
                    }
                }
            }
        }
    }

    public static void tickAbilityArcaneAssault(ItemStack stack, Level world, LivingEntity user, int ability_timer, int ability_timer_max, float abilityDamage, int skillCooldown, int radius) {
        if (!user.m_9236_().m_5776_()) {
            if (ability_timer < 5) {
                user.m_21253_();
            }
            if (user.f_19797_ % 10 == 0 && user.m_6844_(EquipmentSlot.MAINHAND) == stack) {
                AABB box = new AABB(user.m_20185_() + (double)radius, user.m_20186_() + (double)(radius * 2), user.m_20189_() + (double)radius, user.m_20185_() - (double)radius, user.m_20186_() - (double)radius, user.m_20189_() - (double)radius);
                for (Entity entity : world.m_6249_((Entity)user, box, EntitySelector.f_20403_)) {
                    LivingEntity le;
                    if (!(entity instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entity, user)) continue;
                    float choose = (float)(Math.random() * 1.0);
                    if (!le.m_21023_(MobEffects.f_19620_) && ability_timer > 30) {
                        le.m_147207_(new MobEffectInstance(MobEffects.f_19620_, 20, 1), (Entity)user);
                        world.m_6269_(null, (Entity)le, (SoundEvent)SoundRegistry.MAGIC_BOW_SHOOT_IMPACT_03.get(), le.m_5720_(), 0.1f, choose);
                    }
                    le.m_6469_(world.m_269111_().m_269104_((Entity)user, (Entity)user), abilityDamage);
                    if (ability_timer >= 10) continue;
                    le.m_21195_(MobEffects.f_19620_);
                    le.m_6469_(world.m_269111_().m_269104_((Entity)user, (Entity)user), abilityDamage * 3.0f);
                    le.m_20334_(0.0, -10.0, 0.0);
                    user.m_21253_();
                    world.m_6269_(null, (Entity)le, (SoundEvent)SoundRegistry.ELEMENTAL_SWORD_SCIFI_ATTACK_03.get(), le.m_5720_(), 0.3f, choose);
                }
                world.m_6269_(null, (Entity)user, (SoundEvent)SoundRegistry.MAGIC_BOW_CHARGE_SHORT_VERSION.get(), user.m_5720_(), 0.1f, 0.6f);
                double xpos = user.m_20185_() - (double)(radius + 1);
                double ypos = user.m_20186_();
                double zpos = user.m_20189_() - (double)(radius + 1);
                for (int i = radius * 2; i > 0; --i) {
                    for (int j = radius * 2; j > 0; --j) {
                        float choose = (float)(Math.random() * 1.0);
                        HelperMethods.spawnParticle(world, (ParticleOptions)ParticleTypes.f_123799_, xpos + (double)i + (double)choose, ypos + 0.4, zpos + (double)j + (double)choose, 0.0, 0.1, 0.0);
                        HelperMethods.spawnParticle(world, (ParticleOptions)ParticleTypes.f_123760_, xpos + (double)i + (double)choose, ypos + 0.1, zpos + (double)j + (double)choose, 0.0, 0.0, 0.0);
                        HelperMethods.spawnParticle(world, (ParticleOptions)ParticleTypes.f_123789_, xpos + (double)i + (double)choose, ypos + 1.0, zpos + (double)j + (double)choose, 0.0, 0.1, 0.0);
                    }
                }
            }
        }
    }

    public static void tickAbilityVolcanicFury(ItemStack stack, Level world, LivingEntity user, int ability_timer, int ability_timer_max, float abilityDamage, int skillCooldown, int radius, int chargePower) {
        if (!user.m_9236_().m_5776_()) {
            if (ability_timer < 5) {
                user.m_21253_();
            }
            if (user.f_19797_ % 20 == 0 && user.m_6844_(EquipmentSlot.MAINHAND) == stack) {
                if (ability_timer > 10) {
                    Player player;
                    user.m_147207_(new MobEffectInstance(MobEffects.f_19597_, 20, 5), (Entity)user);
                    user.m_147207_(new MobEffectInstance(MobEffects.f_19599_, 20, 5), (Entity)user);
                    user.m_147207_(new MobEffectInstance(MobEffects.f_19606_, 20, 5), (Entity)user);
                    world.m_6269_(null, (Entity)user, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_EARTH_SHOOT_IMPACT_02.get(), user.m_5720_(), 0.8f, 0.1f * (float)chargePower);
                    if (!(!(user.m_21223_() > 2.0f) || user instanceof Player && (player = (Player)user).m_7500_())) {
                        user.m_21153_(user.m_21223_() - 1.0f);
                    }
                }
                AABB box = new AABB(user.m_20185_() + (double)(radius * 8), user.m_20186_() + (double)radius, user.m_20189_() + (double)(radius * 8), user.m_20185_() - (double)(radius * 8), user.m_20186_() - (double)radius, user.m_20189_() - (double)(radius * 8));
                for (Entity entity : world.m_6249_((Entity)user, box, EntitySelector.f_20403_)) {
                    LivingEntity le;
                    if (!(entity instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entity, user) || ability_timer <= 12) continue;
                    le.m_6469_(world.m_269111_().m_269104_((Entity)user, (Entity)user), abilityDamage);
                    le.m_20334_((user.m_20185_() - le.m_20185_()) / 10.0, (user.m_20186_() - le.m_20186_()) / 10.0, (user.m_20189_() - le.m_20189_()) / 10.0);
                    le.m_147207_(new MobEffectInstance(MobEffects.f_19597_, 40, 3), (Entity)user);
                }
                double xpos = user.m_20185_() - (double)(radius + 1);
                double ypos = user.m_20186_();
                double zpos = user.m_20189_() - (double)(radius + 1);
                for (int i = radius * 2; i > 0; --i) {
                    for (int j = radius * 2; j > 0; --j) {
                        float choose = (float)(Math.random() * 1.0);
                        HelperMethods.spawnParticle(world, (ParticleOptions)ParticleTypes.f_123785_, xpos + (double)i + (double)choose, ypos + 0.4, zpos + (double)j + (double)choose, 0.0, 0.1, 0.0);
                        HelperMethods.spawnParticle(world, (ParticleOptions)ParticleTypes.f_123777_, xpos + (double)i + (double)choose, ypos + 0.1, zpos + (double)j + (double)choose, 0.0, 0.0, 0.0);
                        HelperMethods.spawnParticle(world, (ParticleOptions)ParticleTypes.f_123756_, xpos + (double)i + (double)choose, ypos, zpos + (double)j + (double)choose, 0.0, 0.1, 0.0);
                    }
                }
            }
        }
    }
}

