/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigDefaultValues;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.util.HelperMethods;

public class WaxweaverSwordItem
extends UniqueSwordItem {
    private static int stepMod = 0;

    public WaxweaverSwordItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    @Override
    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.m_9236_().m_5776_()) {
            int maximum_stacks = (int)Config.getFloat("waxweaveMaxStacks", "UniqueEffects", ConfigDefaultValues.waxweaveMaxStacks);
            HelperMethods.playHitSounds(attacker, target);
            if (target.m_6060_()) {
                HelperMethods.incrementStatusEffect(attacker, MobEffects.f_19600_, 60, 1, maximum_stacks + 1);
                HelperMethods.incrementStatusEffect(attacker, MobEffects.f_19598_, 60, 1, maximum_stacks + 1);
            }
        }
        return super.m_7579_(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        return super.m_7203_(world, user, hand);
    }

    @Override
    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (stepMod > 0) {
            --stepMod;
        }
        if (stepMod <= 0) {
            stepMod = 7;
        }
        HelperMethods.createFootfalls(entity, stack, world, stepMod, ParticleTypes.f_123790_, ParticleTypes.f_123790_, ParticleTypes.f_123790_, true);
        super.m_6883_(stack, world, entity, slot, selected);
    }

    @Override
    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        Style RIGHTCLICK = HelperMethods.getStyle("rightclick");
        Style ABILITY = HelperMethods.getStyle("ability");
        Style TEXT = HelperMethods.getStyle("text");
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.waxweaversworditem.tooltip1").m_6270_(ABILITY));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.waxweaversworditem.tooltip2").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.waxweaversworditem.tooltip3").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.waxweaversworditem.tooltip4").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.waxweaversworditem.tooltip5").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.waxweaversworditem.tooltip6").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.waxweaversworditem.tooltip7").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.waxweaversworditem.tooltip8").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237110_((String)"item.simplyswords.waxweaversworditem.tooltip9", (Object[])new Object[]{Float.valueOf(Config.getFloat("waxweaveCooldown", "UniqueEffects", ConfigDefaultValues.waxweaveCooldown) / 20.0f)}).m_6270_(TEXT));
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
    }
}

