/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import dev.architectury.platform.Platform;
import java.util.List;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigDefaultValues;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class RibboncleaverSwordItem
extends UniqueSwordItem {
    private static int stepMod = 0;

    public RibboncleaverSwordItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    @Override
    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.m_9236_().m_5776_()) {
            HelperMethods.playHitSounds(attacker, target);
        }
        return super.m_7579_(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        int skillCooldown = (int)Config.getFloat("ribbonwrathCooldown", "UniqueEffects", ConfigDefaultValues.ribbonwrathCooldown);
        int resilienceAmplifier = (int)Config.getFloat("ribbonwrathResilienceAmplifier", "UniqueEffects", ConfigDefaultValues.ribbonwrathResilienceAmplifier);
        world.m_5594_(null, user.m_20183_(), (SoundEvent)SoundRegistry.ELEMENTAL_BOW_EARTH_SHOOT_IMPACT_03.get(), user.m_5720_(), 0.4f, 1.3f);
        if (user.m_20096_()) {
            world.m_5594_(null, user.m_20183_(), (SoundEvent)SoundRegistry.OBJECT_IMPACT_THUD_REPEAT.get(), user.m_5720_(), 0.5f, 1.2f);
        }
        user.m_20256_(user.m_20154_().m_82490_(1.7));
        user.m_20334_(user.m_20184_().f_82479_, 0.0, user.m_20184_().f_82481_);
        user.f_19864_ = true;
        user.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.RIBBONCLEAVE.get(), 60, 0, false, false, true));
        user.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.RESILIENCE.get(), 60, resilienceAmplifier, false, false, true));
        user.m_36335_().m_41524_((Item)this, skillCooldown);
        return super.m_7203_(world, user, hand);
    }

    @Override
    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        Player player;
        if (stepMod > 0) {
            --stepMod;
        }
        if (stepMod <= 0) {
            stepMod = 7;
        }
        if (entity.m_20096_() && Platform.isModLoaded((String)"bettercombat") && HelperMethods.isWalking(entity) && entity instanceof Player && (player = (Player)entity).m_21205_().m_150930_((Item)ItemsRegistry.RIBBONCLEAVER.get())) {
            BlockState blockState = entity.m_20075_();
            BlockParticleOption particleEffect = new BlockParticleOption(ParticleTypes.f_123794_, blockState);
            double bodyRadians = Math.toRadians(entity.m_213816_() + 180.0f);
            Vec3 backwardDirection = new Vec3(-Math.sin(bodyRadians), 0.0, Math.cos(bodyRadians)).m_82490_(1.1);
            double strafeRadians = Math.toRadians(entity.m_213816_() + 90.0f);
            Vec3 strafeDirection = new Vec3(-Math.sin(strafeRadians), 0.0, Math.cos(strafeRadians));
            Vec3 movementVector = entity.m_20184_();
            double strafeMagnitude = movementVector.m_82526_(strafeDirection.m_82541_());
            double pivotOffsetFactor = 3.0;
            Vec3 pivotOffset = strafeDirection.m_82490_(strafeMagnitude * pivotOffsetFactor);
            Vec3 adjustedBackwardDirection = backwardDirection.m_82546_(pivotOffset);
            Vec3 handPosOffset = entity.m_204034_(stack.m_41720_());
            double particleX = entity.m_20185_() + adjustedBackwardDirection.f_82479_ + handPosOffset.m_7096_();
            double particleY = entity.m_20186_() + handPosOffset.m_7098_();
            double particleZ = entity.m_20189_() + adjustedBackwardDirection.f_82481_ + handPosOffset.m_7094_();
            particleY = entity.m_20096_() ? entity.m_20186_() : particleY;
            world.m_7106_((ParticleOptions)particleEffect, particleX, particleY, particleZ, 0.0, 0.0, 0.0);
            world.m_7106_((ParticleOptions)ParticleTypes.f_123759_, particleX, particleY, particleZ, 0.0, 0.0, 0.0);
        }
        super.m_6883_(stack, world, entity, slot, selected);
    }

    @Override
    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        Style RIGHTCLICK = HelperMethods.getStyle("rightclick");
        Style ABILITY = HelperMethods.getStyle("ability");
        Style TEXT = HelperMethods.getStyle("text");
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.ribboncleaversworditem.tooltip1").m_6270_(ABILITY));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.ribboncleaversworditem.tooltip2").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.ribboncleaversworditem.tooltip3").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.ribboncleaversworditem.tooltip4").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.onrightclick").m_6270_(RIGHTCLICK));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.ribboncleaversworditem.tooltip5").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.ribboncleaversworditem.tooltip6").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.ribboncleaversworditem.tooltip7").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.ribboncleaversworditem.tooltip8").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.ribboncleaversworditem.tooltip9").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.ribboncleaversworditem.tooltip10").m_6270_(TEXT));
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
    }
}

