/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigDefaultValues;
import net.sweenus.simplyswords.entity.SimplySwordsBeeEntity;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.EntityRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class HiveheartSwordItem
extends UniqueSwordItem {
    private static int stepMod = 0;

    public HiveheartSwordItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    @Override
    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.m_9236_().m_5776_()) {
            SimplySwordsBeeEntity beeEntity;
            Player player;
            ServerLevel serverWorld = (ServerLevel)attacker.m_9236_();
            int skillCooldown = (int)Config.getFloat("hivemindCooldown", "UniqueEffects", ConfigDefaultValues.hivemindCooldown);
            float skillDamage = Config.getFloat("hivemindDamage", "UniqueEffects", ConfigDefaultValues.hivemindDamage);
            HelperMethods.playHitSounds(attacker, target);
            if (attacker instanceof Player && !(player = (Player)attacker).m_36335_().m_41519_(stack.m_41720_()) && (beeEntity = (SimplySwordsBeeEntity)((EntityType)EntityRegistry.SIMPLYBEEENTITY.get()).m_262496_(serverWorld, attacker.m_20183_().m_6630_(4).m_5484_(attacker.m_6374_(), 3), MobSpawnType.MOB_SUMMONED)) != null && target != null) {
                beeEntity.m_6710_(target);
                beeEntity.m_6925_(target.m_20148_());
                beeEntity.m_7870_(200);
                beeEntity.m_21674_(target);
                beeEntity.m_20331_(true);
                beeEntity.setOwner(attacker);
                double attackDamage = 1.0f + skillDamage * this.m_43299_();
                AttributeInstance attackAttribute = beeEntity.m_21051_(Attributes.f_22281_);
                if (attackAttribute != null) {
                    attackAttribute.m_22100_(attackDamage);
                }
                player.m_36335_().m_41524_(stack.m_41720_(), skillCooldown);
            }
        }
        return super.m_7579_(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        int regenDuration = (int)Config.getFloat("hivemindDuration", "UniqueEffects", ConfigDefaultValues.hivemindDuration);
        int skillCooldown = (int)Config.getFloat("hivemindCooldown", "UniqueEffects", ConfigDefaultValues.hivemindCooldown);
        HelperMethods.incrementStatusEffect((LivingEntity)user, MobEffects.f_19605_, regenDuration, 1, 3);
        ItemStack stack = user.m_21205_();
        world.m_5594_(null, user.m_20183_(), (SoundEvent)SoundRegistry.SPELL_MISC_02.get(), user.m_5720_(), 0.8f, 1.0f);
        user.m_36335_().m_41524_(stack.m_41720_(), skillCooldown * 10);
        return super.m_7203_(world, user, hand);
    }

    @Override
    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (stepMod > 0) {
            --stepMod;
        }
        if (stepMod <= 0) {
            stepMod = 7;
        }
        HelperMethods.createFootfalls(entity, stack, world, stepMod, ParticleTypes.f_123780_, ParticleTypes.f_123781_, ParticleTypes.f_123781_, true);
        super.m_6883_(stack, world, entity, slot, selected);
    }

    @Override
    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        Style RIGHTCLICK = HelperMethods.getStyle("rightclick");
        Style ABILITY = HelperMethods.getStyle("ability");
        Style TEXT = HelperMethods.getStyle("text");
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.hiveheartsworditem.tooltip1").m_6270_(ABILITY));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.hiveheartsworditem.tooltip2").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.hiveheartsworditem.tooltip3").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.hiveheartsworditem.tooltip4").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.hiveheartsworditem.tooltip5").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237110_((String)"item.simplyswords.hiveheartsworditem.tooltip6", (Object[])new Object[]{Float.valueOf(Config.getFloat("hivemindCooldown", "UniqueEffects", ConfigDefaultValues.hivemindCooldown) / 20.0f)}).m_6270_(TEXT));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.hiveheartsworditem.tooltip7").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.hiveheartsworditem.tooltip8").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.hiveheartsworditem.tooltip9").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.hiveheartsworditem.tooltip10").m_6270_(TEXT));
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
    }
}

