/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigDefaultValues;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class HasteSwordItem
extends UniqueSwordItem {
    private static int stepMod = 0;

    public HasteSwordItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    @Override
    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.m_9236_().m_5776_()) {
            ServerLevel world = (ServerLevel)attacker.m_9236_();
            int fhitchance = (int)Config.getFloat("ferocityChance", "UniqueEffects", ConfigDefaultValues.ferocityChance);
            int fduration = (int)Config.getFloat("ferocityDuration", "UniqueEffects", ConfigDefaultValues.ferocityDuration);
            int maximum_stacks = (int)Config.getFloat("ferocityMaxStacks", "UniqueEffects", ConfigDefaultValues.ferocityMaxStacks);
            HelperMethods.playHitSounds(attacker, target);
            if (attacker.m_217043_().m_188503_(100) <= fhitchance) {
                if (attacker.m_21023_(MobEffects.f_19598_)) {
                    int a = attacker.m_21124_(MobEffects.f_19598_).m_19564_() + 1;
                    world.m_6269_(null, (Entity)attacker, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_HOLY_SHOOT_IMPACT_02.get(), attacker.m_5720_(), 0.3f, 1.0f + (float)a / 10.0f);
                    if (attacker.m_21124_(MobEffects.f_19598_).m_19564_() < maximum_stacks) {
                        attacker.m_147207_(new MobEffectInstance(MobEffects.f_19598_, fduration, a), (Entity)attacker);
                    } else {
                        attacker.m_147207_(new MobEffectInstance(MobEffects.f_19598_, fduration, a - 1), (Entity)attacker);
                    }
                } else {
                    attacker.m_147207_(new MobEffectInstance(MobEffects.f_19598_, fduration, 1), (Entity)attacker);
                }
            }
        }
        return super.m_7579_(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        if (user.m_21023_(MobEffects.f_19598_)) {
            int strength_tier = (int)Config.getFloat("ferocityStrengthTier", "UniqueEffects", ConfigDefaultValues.ferocityStrengthTier);
            int a = user.m_21124_(MobEffects.f_19598_).m_19564_() * 20;
            user.m_147207_(new MobEffectInstance(MobEffects.f_19600_, a, strength_tier), (Entity)user);
            user.m_6674_(hand);
            user.m_21195_(MobEffects.f_19598_);
            world.m_5594_(null, user.m_20183_(), (SoundEvent)SoundRegistry.ELEMENTAL_BOW_SCIFI_SHOOT_IMPACT_03.get(), user.m_5720_(), 0.5f, 1.5f);
        }
        return super.m_7203_(world, user, hand);
    }

    @Override
    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (stepMod > 0) {
            --stepMod;
        }
        if (stepMod <= 0) {
            stepMod = 7;
        }
        HelperMethods.createFootfalls(entity, stack, world, stepMod, ParticleTypes.f_123811_, ParticleTypes.f_123811_, ParticleTypes.f_123811_, false);
        super.m_6883_(stack, world, entity, slot, selected);
    }

    @Override
    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        Style RIGHTCLICK = HelperMethods.getStyle("rightclick");
        Style ABILITY = HelperMethods.getStyle("ability");
        Style TEXT = HelperMethods.getStyle("text");
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.ferocitysworditem.tooltip1").m_6270_(ABILITY));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.ferocitysworditem.tooltip2").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.ferocitysworditem.tooltip3").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.onrightclick").m_6270_(RIGHTCLICK));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.ferocitysworditem.tooltip4").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.ferocitysworditem.tooltip5").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.ferocitysworditem.tooltip6").m_6270_(TEXT));
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
    }
}

