/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.entity;

import com.google.common.base.Suppliers;
import java.util.Comparator;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigDefaultValues;
import net.sweenus.simplyswords.effect.instance.SimplySwordsStatusEffectInstance;
import net.sweenus.simplyswords.entity.BattleStandardEntity;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class BattleStandardDarkEntity
extends PathfinderMob {
    public static final Supplier<EntityType<BattleStandardDarkEntity>> TYPE = Suppliers.memoize(() -> EntityType.Builder.m_20704_(BattleStandardDarkEntity::new, (MobCategory)MobCategory.MISC).m_20712_("battlestandarddark"));
    float abilityDamage = Config.getFloat("abyssalStandardDamage", "UniqueEffects", ConfigDefaultValues.abyssalStandardDamage);
    float spellScalingModifier = Config.getFloat("abyssalStandardSpellScaling", "UniqueEffects", ConfigDefaultValues.abyssalStandardSpellScaling);
    public Player ownerEntity;
    public String standardType;
    public int decayRate;

    public static AttributeSupplier.Builder createBattleStandardDarkAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 150.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22278_, 100.0);
    }

    public BattleStandardDarkEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
        this.m_6842_(true);
    }

    protected boolean m_6107_() {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return this.ownerEntity == null;
    }

    public void m_6075_() {
        if (!this.m_9236_().m_5776_()) {
            if (this.f_19797_ % 10 == 0) {
                this.m_21153_(this.m_21223_() - (float)this.decayRate);
                if (this.ownerEntity == null) {
                    this.m_21153_(this.m_21223_() - 1000.0f);
                }
                HelperMethods.spawnOrbitParticles((ServerLevel)this.m_9236_(), this.m_20182_(), (ParticleOptions)ParticleTypes.f_123777_, 0.5, 6);
                if (this.ownerEntity != null && this.m_20270_((Entity)this.ownerEntity) < 3.0f) {
                    HelperMethods.incrementStatusEffect((LivingEntity)this.ownerEntity, MobEffects.f_19598_, 60, 1, 7);
                }
            }
            if (this.ownerEntity != null && this.standardType != null) {
                LivingEntity le;
                int radius = 6;
                if (HelperMethods.commonSpellAttributeScaling(this.spellScalingModifier, (Entity)this.ownerEntity, "soul") > 0.0f) {
                    this.abilityDamage = HelperMethods.commonSpellAttributeScaling(this.spellScalingModifier, (Entity)this.ownerEntity, "soul");
                }
                if (this.standardType.equals("enigma") && !this.m_20145_()) {
                    this.m_6842_(true);
                }
                if (this.standardType.equals("enigma")) {
                    radius = 2;
                    this.m_274367_(3.0f);
                    int moveRadius = (int)Config.getFloat("enigmaChaseRadius", "UniqueEffects", ConfigDefaultValues.enigmaChaseRadius);
                    this.abilityDamage = 1.0f;
                    AABB box = HelperMethods.createBox((Entity)this, moveRadius);
                    Entity closestEntity = this.m_9236_().m_6249_((Entity)this, box, EntitySelector.f_20403_).stream().filter(entity -> {
                        if (entity instanceof LivingEntity) {
                            LivingEntity livingEntity = (LivingEntity)entity;
                            return HelperMethods.checkFriendlyFire(livingEntity, (LivingEntity)this.ownerEntity);
                        }
                        return false;
                    }).min(Comparator.comparingDouble(entity -> entity.m_20280_((Entity)this))).orElse(null);
                    if (closestEntity != null && closestEntity instanceof LivingEntity && !((le = (LivingEntity)closestEntity) instanceof BattleStandardEntity) && !(le instanceof BattleStandardDarkEntity) && le.m_20270_((Entity)this) > 1.0f && this.m_20096_()) {
                        this.m_20334_((le.m_20185_() - this.m_20185_()) / 20.0, 0.0, (le.m_20189_() - this.m_20189_()) / 20.0);
                    }
                }
                if (this.f_19797_ % 10 == 0) {
                    AABB box = new AABB(this.m_20185_() + (double)radius, this.m_20186_() + (double)((float)radius / 3.0f), this.m_20189_() + (double)radius, this.m_20185_() - (double)radius, this.m_20186_() - (double)((float)radius / 3.0f), this.m_20189_() - (double)radius);
                    for (Entity entities : this.m_9236_().m_6249_((Entity)this, box, EntitySelector.f_20403_)) {
                        if (!(entities instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entities, (LivingEntity)this.ownerEntity) || le == this.ownerEntity || le instanceof BattleStandardEntity || le instanceof BattleStandardDarkEntity) continue;
                        le.f_19802_ = 0;
                        le.m_6469_(this.m_269291_().m_269104_((Entity)this.ownerEntity, (Entity)this.ownerEntity), this.abilityDamage);
                        le.f_19802_ = 0;
                        if (le.m_20270_((Entity)this) > (float)(radius - 1)) {
                            le.m_20334_((this.m_20185_() - le.m_20185_()) / 4.0, (this.m_20186_() - le.m_20186_()) / 4.0, (this.m_20189_() - le.m_20189_()) / 4.0);
                        }
                        le.m_147207_(new MobEffectInstance(MobEffects.f_19597_, 120, 0), (Entity)this);
                        if (!this.standardType.equals("enigma")) continue;
                        SimplySwordsStatusEffectInstance effect = HelperMethods.incrementSimplySwordsStatusEffect(le, (MobEffect)EffectRegistry.PAIN.get(), 60, 1, 49);
                        effect.setSourceEntity((LivingEntity)this.ownerEntity);
                        effect.setAdditionalData(0);
                        le.m_7292_((MobEffectInstance)effect);
                    }
                    if (!this.standardType.equals("enigma")) {
                        HelperMethods.spawnParticle(this.m_9236_(), (ParticleOptions)ParticleTypes.f_235898_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                    }
                }
                if (this.m_21223_() > this.m_21233_() - 2.0f && this.m_20096_()) {
                    if (!this.standardType.equals("enigma")) {
                        HelperMethods.spawnParticle(this.m_9236_(), (ParticleOptions)ParticleTypes.f_123745_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.3, 0.0);
                        HelperMethods.spawnParticle(this.m_9236_(), (ParticleOptions)ParticleTypes.f_123777_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                    }
                    AABB box = new AABB(this.m_20185_() + 1.0, this.m_20186_() + 1.0, this.m_20189_() + 1.0, this.m_20185_() - 1.0, this.m_20186_() - 1.0, this.m_20189_() - 1.0);
                    for (Entity entity2 : this.m_9236_().m_6249_((Entity)this, box, EntitySelector.f_20403_)) {
                        if (!(entity2 instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entity2, (LivingEntity)this.ownerEntity) || le == this.ownerEntity) continue;
                        le.m_6469_(this.m_269291_().m_269104_((Entity)this.ownerEntity, (Entity)this.ownerEntity), this.abilityDamage * 3.0f);
                        le.m_20334_((le.m_20185_() - this.m_20185_()) / 4.0, 0.5, (le.m_20189_() - this.m_20189_()) / 4.0);
                    }
                }
                if (this.f_19797_ % 80 == 0 && !this.standardType.equals("enigma")) {
                    AABB box = new AABB(this.m_20185_() + (double)radius, this.m_20186_() + (double)((float)radius / 3.0f), this.m_20189_() + (double)radius, this.m_20185_() - (double)radius, this.m_20186_() - (double)((float)radius / 3.0f), this.m_20189_() - (double)radius);
                    for (Entity entity2 : this.m_9236_().m_6249_((Entity)this, box, EntitySelector.f_20403_)) {
                        if (!(entity2 instanceof LivingEntity) || HelperMethods.checkFriendlyFire(le = (LivingEntity)entity2, (LivingEntity)this.ownerEntity)) continue;
                        le.m_147207_(new MobEffectInstance(MobEffects.f_19598_, 90, 2), (Entity)this);
                    }
                    this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)SoundRegistry.DARK_SWORD_WHOOSH_01.get(), this.m_5720_(), 0.1f, 0.6f);
                    double xpos = this.m_20185_() - (double)(radius + 1);
                    double ypos = this.m_20186_();
                    double zpos = this.m_20189_() - (double)(radius + 1);
                    for (int i = radius * 2; i > 0; --i) {
                        for (int j = radius * 2; j > 0; --j) {
                            float choose = (float)(Math.random() * 1.0);
                            if (!((double)choose > 0.5)) continue;
                            HelperMethods.spawnParticle(this.m_9236_(), (ParticleOptions)ParticleTypes.f_123746_, xpos + (double)i + (double)choose, ypos + 0.1, zpos + (double)j + (double)choose, 0.0, -0.1, 0.0);
                        }
                    }
                }
            }
        }
        super.m_6075_();
    }
}

