/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.init;

import com.teammetallurgy.aquaculture.entity.AquaFishingBobberEntity;
import com.teammetallurgy.aquaculture.entity.SpectralWaterArrowEntity;
import com.teammetallurgy.aquaculture.entity.TurtleLandEntity;
import com.teammetallurgy.aquaculture.entity.WaterArrowEntity;
import com.teammetallurgy.aquaculture.init.AquaItems;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="aquaculture", bus=Mod.EventBusSubscriber.Bus.MOD)
public class AquaEntities {
    public static final DeferredRegister<EntityType<?>> ENTITY_DEFERRED = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"aquaculture");
    public static final RegistryObject<EntityType<AquaFishingBobberEntity>> BOBBER = AquaEntities.register("bobber", () -> EntityType.Builder.m_20710_((MobCategory)MobCategory.MISC).m_20716_().m_20698_().m_20699_(0.25f, 0.25f).setTrackingRange(4).setUpdateInterval(5).setCustomClientFactory(AquaFishingBobberEntity::new));
    public static final RegistryObject<EntityType<WaterArrowEntity>> WATER_ARROW = AquaEntities.register("water_arrow", () -> EntityType.Builder.m_20704_(WaterArrowEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).setCustomClientFactory(WaterArrowEntity::new));
    public static final RegistryObject<EntityType<SpectralWaterArrowEntity>> SPECTRAL_WATER_ARROW = AquaEntities.register("spectral_water_arrow", () -> EntityType.Builder.m_20704_(SpectralWaterArrowEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).setCustomClientFactory(SpectralWaterArrowEntity::new));
    public static final RegistryObject<EntityType<TurtleLandEntity>> BOX_TURTLE = AquaEntities.registerMob("box_turtle", 8356921, 6119722, () -> EntityType.Builder.m_20704_(TurtleLandEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.5f, 0.25f));
    public static final RegistryObject<EntityType<TurtleLandEntity>> ARRAU_TURTLE = AquaEntities.registerMob("arrau_turtle", 7439738, 5202520, () -> EntityType.Builder.m_20704_(TurtleLandEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.5f, 0.25f));
    public static final RegistryObject<EntityType<TurtleLandEntity>> STARSHELL_TURTLE = AquaEntities.registerMob("starshell_turtle", 14476005, 0x464645, () -> EntityType.Builder.m_20704_(TurtleLandEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.5f, 0.25f));

    private static <T extends Mob> RegistryObject<EntityType<T>> registerMob(String name, int eggPrimary, int eggSecondary, Supplier<EntityType.Builder<T>> builder) {
        RegistryObject entityType = AquaEntities.register(name, builder);
        RegistryObject<Item> spawnEggItem = AquaItems.register(() -> new ForgeSpawnEggItem((Supplier)entityType, eggPrimary, eggSecondary, new Item.Properties()), name + "_spawn_egg");
        AquaItems.SPAWN_EGGS.add(spawnEggItem);
        return entityType;
    }

    public static <T extends Entity> RegistryObject<EntityType<T>> register(String name, Supplier<EntityType.Builder<T>> builder) {
        ResourceLocation location = new ResourceLocation("aquaculture", name);
        return ENTITY_DEFERRED.register(name, () -> ((EntityType.Builder)builder.get()).m_20712_(location.toString()));
    }

    public static void setSpawnPlacement() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)BOX_TURTLE.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_218104_);
        SpawnPlacements.m_21754_((EntityType)((EntityType)ARRAU_TURTLE.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_218104_);
        SpawnPlacements.m_21754_((EntityType)((EntityType)STARSHELL_TURTLE.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_218104_);
    }

    @SubscribeEvent
    public static void addEntityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)BOX_TURTLE.get(), TurtleLandEntity.createAttributes().m_22265_());
        event.put((EntityType)ARRAU_TURTLE.get(), TurtleLandEntity.createAttributes().m_22265_());
        event.put((EntityType)STARSHELL_TURTLE.get(), TurtleLandEntity.createAttributes().m_22265_());
    }
}

