/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enhancedcelestials.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.datafixers.util.Pair;
import corgitaco.enhancedcelestials.EnhancedCelestialsWorldData;
import corgitaco.enhancedcelestials.api.EnhancedCelestialsRegistry;
import corgitaco.enhancedcelestials.api.lunarevent.LunarDimensionSettings;
import corgitaco.enhancedcelestials.api.lunarevent.LunarEvent;
import corgitaco.enhancedcelestials.core.EnhancedCelestialsContext;
import corgitaco.enhancedcelestials.lunarevent.LunarForecast;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceOrTagKeyArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;

public class SetLunarEventCommand {
    private static final DynamicCommandExceptionType ERROR_LUNAR_EVENT_INVALID = new DynamicCommandExceptionType(obj -> Component.m_237110_((String)"enhancedcelestials.commands.setlunarevent.invalid", (Object[])new Object[]{obj}));

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return Commands.m_82127_((String)"setLunarEvent").then(Commands.m_82129_((String)"lunarEvent", (ArgumentType)ResourceOrTagKeyArgument.m_247494_(EnhancedCelestialsRegistry.LUNAR_EVENT_KEY)).executes(cs -> SetLunarEventCommand.setLunarEvent((CommandSourceStack)cs.getSource(), (ResourceOrTagKeyArgument.Result<LunarEvent>)ResourceOrTagKeyArgument.m_246379_((CommandContext)cs, (String)"lunarEvent", EnhancedCelestialsRegistry.LUNAR_EVENT_KEY, (DynamicCommandExceptionType)ERROR_LUNAR_EVENT_INVALID))));
    }

    public static int setLunarEvent(CommandSourceStack source, ResourceOrTagKeyArgument.Result<LunarEvent> lunarEventResult) {
        ServerLevel world = source.m_81372_();
        EnhancedCelestialsContext enhancedCelestialsContext = ((EnhancedCelestialsWorldData)world).getLunarContext();
        if (enhancedCelestialsContext == null) {
            source.m_81352_((Component)Component.m_237115_((String)"enhancedcelestials.commands.disabled"));
            return 0;
        }
        LunarForecast forecast = enhancedCelestialsContext.getLunarForecast();
        long dayLength = ((LunarDimensionSettings)forecast.getDimensionSettingsHolder().m_203334_()).dayLength();
        long currentDay = world.m_46468_() / dayLength;
        Pair<Component, Boolean> component = forecast.setOrReplaceEventWithResponse(lunarEventResult, currentDay, source.m_81372_().m_213780_());
        if (((Boolean)component.getSecond()).booleanValue()) {
            if (!world.m_46462_()) {
                world.m_8615_(currentDay * dayLength + 13000L);
            }
            source.m_288197_(() -> component.getFirst(), true);
            return 1;
        }
        source.m_81352_((Component)component.getFirst());
        return 0;
    }
}

