/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enhancedcelestials.lunarevent;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.enhancedcelestials.EnhancedCelestials;
import corgitaco.enhancedcelestials.api.lunarevent.LunarDimensionSettings;
import corgitaco.enhancedcelestials.api.lunarevent.LunarEvent;
import corgitaco.enhancedcelestials.api.lunarevent.LunarTextComponents;
import corgitaco.enhancedcelestials.lunarevent.LunarEventInstance;
import corgitaco.enhancedcelestials.network.LunarForecastChangedPacket;
import corgitaco.enhancedcelestials.platform.Services;
import corgitaco.enhancedcelestials.util.CustomTranslationTextComponent;
import it.unimi.dsi.fastutil.longs.Long2LongFunction;
import it.unimi.dsi.fastutil.objects.Object2LongArrayMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.arguments.ResourceOrTagKeyArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;

public class LunarForecast {
    private final Holder<LunarDimensionSettings> dimensionSettingsHolder;
    private final List<LunarEventInstance> forecast;
    private final List<LunarEventInstance> pastEvents;
    private final Registry<LunarEvent> lunarEventRegistry;
    private final List<Holder<LunarEvent>> scrambledKeys;
    private Holder<LunarEvent> currentEvent;
    private Holder<LunarEvent> mostRecentEvent;
    private final Holder<LunarEvent> defaultEvent;
    private float blend = 1.0f;
    private long lastCheckedGameTime;

    public LunarForecast(Holder<LunarDimensionSettings> dimensionSettingsHolder, Registry<LunarEvent> lunarEventRegistry, long currentDayTime, Data savedData) {
        this(dimensionSettingsHolder, lunarEventRegistry, currentDayTime, savedData.forecast(), savedData.pastEvents(), savedData.lastCheckedGameTime());
    }

    public LunarForecast(Holder<LunarDimensionSettings> dimensionSettingsHolder, Registry<LunarEvent> lunarEventRegistry, long currentDayTime) {
        this(dimensionSettingsHolder, lunarEventRegistry, currentDayTime, new ArrayList<LunarEventInstance>(), new ArrayList<LunarEventInstance>(), -1L);
    }

    public LunarForecast(Holder<LunarDimensionSettings> dimensionSettingsHolder, Registry<LunarEvent> lunarEventRegistry, long currentDayTime, List<LunarEventInstance> forecast, List<LunarEventInstance> pastEvents, long lastCheckedGameTime) {
        this.lunarEventRegistry = lunarEventRegistry;
        LunarDimensionSettings lunarDimensionSettings = (LunarDimensionSettings)dimensionSettingsHolder.m_203334_();
        HashSet<Holder.Reference> possibleEvents = new HashSet<Holder.Reference>();
        for (Map.Entry resourceKeyLunarEventEntry : lunarEventRegistry.m_6579_()) {
            Holder.Reference lunarEventHolder = lunarEventRegistry.m_246971_((ResourceKey)resourceKeyLunarEventEntry.getKey());
            ResourceKey levelResourceKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)((ResourceKey)dimensionSettingsHolder.m_203543_().orElseThrow()).m_135782_());
            if (!((LunarEvent)lunarEventHolder.m_203334_()).getEventChancesByDimension().containsKey(levelResourceKey)) continue;
            possibleEvents.add(lunarEventHolder);
        }
        this.dimensionSettingsHolder = dimensionSettingsHolder;
        this.forecast = new ArrayList<LunarEventInstance>(forecast);
        this.pastEvents = new ArrayList<LunarEventInstance>(pastEvents);
        Set possibleEventResourceKeys = possibleEvents.stream().map(Holder::m_203543_).map(Optional::orElseThrow).collect(Collectors.toSet());
        for (int i = 0; i < forecast.size(); ++i) {
            LunarEventInstance lunarEventInstance = forecast.get(i);
            ResourceKey<LunarEvent> lunarEventKey = lunarEventInstance.getLunarEventKey();
            if (possibleEventResourceKeys.contains(lunarEventKey)) continue;
            EnhancedCelestials.LOGGER.error(String.format("\"%s\" is not a valid lunar event key, removing....", lunarEventKey.m_135782_()));
            this.forecast.remove(i);
        }
        this.lastCheckedGameTime = lastCheckedGameTime;
        this.scrambledKeys = new ArrayList<Holder<LunarEvent>>(possibleEvents);
        this.defaultEvent = lunarEventRegistry.m_246971_(lunarDimensionSettings.defaultEvent());
        this.currentEvent = !forecast.isEmpty() && forecast.get(0).active(currentDayTime / lunarDimensionSettings.dayLength()) ? forecast.get(0).getEvent(lunarEventRegistry) : this.defaultEvent;
        this.mostRecentEvent = pastEvents.isEmpty() ? this.defaultEvent : pastEvents.get(0).getEvent(lunarEventRegistry);
    }

    public Data data() {
        return new Data(this.forecast, this.pastEvents, this.lastCheckedGameTime);
    }

    public void recompute(ServerLevel level) {
        this.forecast.clear();
        this.lastCheckedGameTime = Long.MIN_VALUE;
        if (LunarForecast.updateForecast(level, (LunarDimensionSettings)this.dimensionSettingsHolder.m_203334_(), this)) {
            List players = level.m_6907_();
            Services.PLATFORM.sendToAllClients(players, new LunarForecastChangedPacket(this, level.m_46462_()));
        }
    }

    public Pair<Component, Boolean> setOrReplaceEventWithResponse(ResourceOrTagKeyArgument.Result<LunarEvent> result, long currentDay, RandomSource randomSource) {
        if (result.test(this.currentEvent)) {
            return Pair.of((Object)Component.m_237115_((String)"Event is already active"), (Object)false);
        }
        Either unwrappedResult = result.m_245276_();
        Optional left = unwrappedResult.left();
        if (left.isPresent()) {
            ResourceKey resourceKey = (ResourceKey)left.orElseThrow();
            this.removeIfActive(currentDay);
            this.forecast.add(0, new LunarEventInstance((ResourceKey<LunarEvent>)resourceKey, currentDay, true));
            return Pair.of((Object)Component.m_237110_((String)"Set lunar event to \"%s\"", (Object[])new Object[]{resourceKey.m_135782_()}), (Object)true);
        }
        Optional right = unwrappedResult.right();
        TagKey lunarEventTagKey = (TagKey)right.orElseThrow();
        Optional tag = this.lunarEventRegistry.m_203431_(lunarEventTagKey);
        if (tag.isPresent()) {
            Holder randomElement = (Holder)((HolderSet.Named)tag.get()).m_213653_(randomSource).orElseThrow();
            this.removeIfActive(currentDay);
            this.forecast.add(0, new LunarEventInstance((ResourceKey<LunarEvent>)((ResourceKey)randomElement.m_203543_().orElseThrow()), currentDay, true));
            return Pair.of((Object)Component.m_237110_((String)"Set lunar event to \"%s\" from tag \"%s\"", (Object[])new Object[]{lunarEventTagKey.f_203868_(), lunarEventTagKey.f_203868_()}), (Object)true);
        }
        return Pair.of((Object)Component.m_237110_((String)"Could not set lunar event for result:\n\"%s\"", (Object[])new Object[]{result.toString()}), (Object)false);
    }

    public Component getForecastComponent(long currentDayTime) {
        long currentDay = currentDayTime / ((LunarDimensionSettings)this.dimensionSettingsHolder.m_203334_()).dayLength();
        MutableComponent textComponent = null;
        for (int i = Math.min(100, this.getForecast().size() - 1); i >= 0; --i) {
            LunarEventInstance lunarEventInstance = this.getForecast().get(i);
            Holder<LunarEvent> event = lunarEventInstance.getEvent(this.lunarEventRegistry);
            CustomTranslationTextComponent name = ((LunarEvent)event.m_203334_()).getTextComponents().name();
            TextColor color = name.getStyle().m_131135_();
            if (textComponent == null) {
                textComponent = Component.m_237115_((String)name.getKey()).m_130948_(Style.f_131099_.m_131148_(color));
            } else {
                textComponent.m_7220_((Component)Component.m_237113_((String)", ").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.WHITE))).m_7220_((Component)Component.m_237115_((String)name.getKey()).m_130948_(Style.f_131099_.m_131148_(color)));
            }
            textComponent.m_7220_((Component)Component.m_237110_((String)"enhancedcelestials.lunarforecast.days_left", (Object[])new Object[]{lunarEventInstance.getDaysUntil(currentDay)}).m_130948_(Style.f_131099_.m_131148_(color)));
        }
        if (textComponent != null) {
            return Component.m_237110_((String)"enhancedcelestials.lunarforecast.header", (Object[])new Object[]{textComponent.m_7220_((Component)Component.m_237113_((String)".").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.WHITE)))});
        }
        return Component.m_237110_((String)"enhancedcelestials.lunarforecast.empty", (Object[])new Object[]{textComponent}).m_130940_(ChatFormatting.YELLOW);
    }

    private void removeIfActive(long currentDay) {
        if (!this.forecast.isEmpty() && this.forecast.get(0).active(currentDay)) {
            this.forecast.remove(0);
        }
    }

    public void tick(Level level) {
        LunarDimensionSettings lunarDimensionSettings = (LunarDimensionSettings)this.dimensionSettingsHolder.m_203334_();
        Holder<LunarEvent> lastCurrentEvent = this.currentEvent;
        long dayTime = level.m_46468_();
        long dayLength = lunarDimensionSettings.dayLength();
        long currentDay = dayTime / dayLength;
        if (!level.f_46443_) {
            this.serverTick((ServerLevel)level, lastCurrentEvent, lunarDimensionSettings, currentDay);
        }
        this.blend = Mth.m_14036_((float)(this.blend + 0.01f), (float)0.0f, (float)1.0f);
    }

    private void serverTick(ServerLevel level, Holder<LunarEvent> lastCurrentEvent, LunarDimensionSettings lunarDimensionSettings, long currentDay) {
        List players = level.m_6907_();
        if (LunarForecast.updateForecast(level, lunarDimensionSettings, this)) {
            Services.PLATFORM.sendToAllClients(players, new LunarForecastChangedPacket(this, level.m_46462_()));
        }
        LunarForecast.updatePastEventsAndRecentAndCurrentEvents(this, currentDay, lunarDimensionSettings.trackedPastEventsMaxCount());
        LunarEventInstance lunarEventInstance = this.forecast.get(0);
        this.currentEvent = lunarEventInstance.active(currentDay) && level.m_46462_() ? lunarEventInstance.getEvent(this.lunarEventRegistry) : this.defaultEvent;
        if (level.m_46461_()) {
            this.currentEvent = this.defaultEvent;
        }
        if (lastCurrentEvent != this.currentEvent) {
            this.onLunarEventChange(lastCurrentEvent, players, level.m_46462_());
        }
        if (level.m_46467_() % 6000L == 0L) {
            Services.PLATFORM.sendToAllClients(players, new LunarForecastChangedPacket(this, level.m_46462_()));
        }
    }

    private void onLunarEventChange(Holder<LunarEvent> lastCurrentEvent, List<ServerPlayer> players, boolean isNight) {
        this.blend = 0.0f;
        Services.PLATFORM.sendToAllClients(players, new LunarForecastChangedPacket(this, isNight));
        this.notifyPlayers(lastCurrentEvent, players);
    }

    private void notifyPlayers(Holder<LunarEvent> lastCurrentEvent, List<ServerPlayer> players) {
        this.sendNotificationToPlayers(players, ((LunarEvent)lastCurrentEvent.m_203334_()).endNotification());
        this.sendNotificationToPlayers(players, ((LunarEvent)this.currentEvent.m_203334_()).startNotification());
    }

    private void sendNotificationToPlayers(List<ServerPlayer> players, @Nullable LunarTextComponents.Notification notification) {
        LunarTextComponents.NotificationType notificationType;
        if (notification != null && (notificationType = notification.notificationType()) != LunarTextComponents.NotificationType.NONE) {
            boolean hotBar = notificationType == LunarTextComponents.NotificationType.HOT_BAR;
            for (ServerPlayer player : players) {
                player.m_5661_(notification.customTranslationTextComponent().getComponent(), hotBar);
            }
        }
    }

    public void setLastCheckedGameTime(long lastCheckedGameTime) {
        this.lastCheckedGameTime = lastCheckedGameTime;
    }

    public void setCurrentEvent(ResourceKey<LunarEvent> key) {
        this.setCurrentEvent((Holder<LunarEvent>)this.lunarEventRegistry.m_246971_(key));
    }

    public void setCurrentEvent(Holder<LunarEvent> currentEvent) {
        if (currentEvent != this.currentEvent) {
            this.mostRecentEvent = this.currentEvent;
            this.currentEvent = currentEvent;
            this.blend = 0.0f;
        }
    }

    public Holder<LunarDimensionSettings> getDimensionSettingsHolder() {
        return this.dimensionSettingsHolder;
    }

    public List<LunarEventInstance> getForecast() {
        return this.forecast;
    }

    public long getLastCheckedGameTime() {
        return this.lastCheckedGameTime;
    }

    public List<LunarEventInstance> getPastEvents() {
        return this.pastEvents;
    }

    public Holder<LunarEvent> getCurrentEvent(boolean isClearSkies) {
        if (((LunarDimensionSettings)this.dimensionSettingsHolder.m_203334_()).requiresClearSkies() && !isClearSkies) {
            return this.defaultEvent;
        }
        return this.currentEvent;
    }

    public Holder<LunarEvent> getCurrentEventRaw() {
        return this.currentEvent;
    }

    public Holder<LunarEvent> getMostRecentEvent() {
        return this.mostRecentEvent;
    }

    public float getBlend() {
        return this.blend;
    }

    public static boolean updateForecast(ServerLevel world, LunarDimensionSettings dimensionSettings, LunarForecast lunarForecast) {
        return LunarForecast.updateForecast(world, dimensionSettings, lunarForecast, day -> world.m_7328_() + (long)world.m_46472_().m_135782_().hashCode() + day);
    }

    public static boolean updateForecast(ServerLevel world, LunarDimensionSettings dimensionSettings, LunarForecast lunarForecast, Long2LongFunction seed) {
        long dayTime = world.m_46468_();
        long lastCheckedTime = lunarForecast.getLastCheckedGameTime();
        long dayLength = dimensionSettings.dayLength();
        long yearLengthInDays = dimensionSettings.yearLengthInDays();
        long lastCheckedDay = lastCheckedTime / dayLength;
        long currentDay = dayTime / dayLength;
        if (lastCheckedDay < currentDay) {
            lunarForecast.getForecast().clear();
            lunarForecast.setLastCheckedGameTime(currentDay * dayLength);
            lastCheckedTime = lunarForecast.getLastCheckedGameTime();
            lastCheckedDay = lastCheckedTime / dayLength;
        }
        if (currentDay + yearLengthInDays <= lastCheckedDay) {
            return false;
        }
        ArrayList<LunarEventInstance> newLunarEvents = new ArrayList<LunarEventInstance>();
        Object2LongArrayMap eventByLastTime = new Object2LongArrayMap();
        List<LunarEventInstance> forecast = lunarForecast.getForecast();
        long lastDay = !forecast.isEmpty() ? forecast.get(forecast.size() - 1).scheduledDay() : currentDay;
        long day = lastCheckedDay;
        for (LunarEventInstance lunarEventInstance : forecast) {
            eventByLastTime.put((Object)((LunarEvent)lunarEventInstance.getEvent(lunarForecast.lunarEventRegistry).m_203334_()), lunarEventInstance.scheduledDay());
        }
        while (day <= currentDay + yearLengthInDays) {
            dayTime += dayLength;
            Random random = new Random(seed.applyAsLong(day));
            Collections.shuffle(lunarForecast.scrambledKeys, random);
            for (Holder<LunarEvent> lunarEventHolder : lunarForecast.scrambledKeys) {
                LunarEvent value;
                LunarEvent.SpawnRequirements spawnRequirements;
                boolean canCreateEventInstance;
                Map<ResourceKey<Level>, LunarEvent.SpawnRequirements> eventChancesByDimension = ((LunarEvent)lunarEventHolder.m_203334_()).getEventChancesByDimension();
                if (!eventChancesByDimension.containsKey(world.m_46472_()) || !(canCreateEventInstance = LunarForecast.canCreateEventInstance(world, dimensionSettings, dayTime, currentDay, (Object2LongArrayMap<LunarEvent>)eventByLastTime, lastDay, day, random, spawnRequirements = eventChancesByDimension.get(world.m_46472_()), value = (LunarEvent)lunarEventHolder.m_203334_()))) continue;
                lastDay = day;
                newLunarEvents.add(new LunarEventInstance((ResourceKey<LunarEvent>)((ResourceKey)lunarEventHolder.m_203543_().orElseThrow()), day));
                eventByLastTime.put((Object)value, day);
            }
            ++day;
        }
        forecast.addAll(newLunarEvents);
        lunarForecast.setLastCheckedGameTime(day * dayLength);
        return true;
    }

    private static boolean canCreateEventInstance(ServerLevel world, LunarDimensionSettings dimensionSettings, long dayTime, long currentDay, Object2LongArrayMap<LunarEvent> eventByLastTime, long lastDay, long day, Random random, LunarEvent.SpawnRequirements spawnRequirements, LunarEvent value) {
        boolean pastMinNumberOfNightsBetweenThisTypeOfEvent = day - eventByLastTime.getOrDefault((Object)value, currentDay) > (long)spawnRequirements.minNumberOfNights();
        boolean pastMinNumberOfNightsBetweenAllEvents = day - lastDay > dimensionSettings.minDaysBetweenEvents();
        boolean isValidMoonPhase = spawnRequirements.validMoonPhases().contains(world.m_6042_().m_63936_(dayTime - 1L));
        boolean chance = spawnRequirements.chance() > random.nextDouble();
        return pastMinNumberOfNightsBetweenThisTypeOfEvent && pastMinNumberOfNightsBetweenAllEvents && chance && isValidMoonPhase;
    }

    private static void updatePastEventsAndRecentAndCurrentEvents(LunarForecast lunarForecast, long currentDay, long trackedPastEventsMaxCount) {
        LunarEventInstance mostRecentInstance;
        if (!lunarForecast.getForecast().isEmpty() && (mostRecentInstance = lunarForecast.getForecast().get(0)).passed(currentDay)) {
            lunarForecast.forecast.remove(0);
            List<LunarEventInstance> pastEvents = lunarForecast.pastEvents;
            pastEvents.add(0, mostRecentInstance);
            while ((long)pastEvents.size() > trackedPastEventsMaxCount) {
                pastEvents.remove(pastEvents.size() - 1);
            }
            lunarForecast.mostRecentEvent = mostRecentInstance.getEvent(lunarForecast.lunarEventRegistry);
        }
    }

    public record Data(List<LunarEventInstance> forecast, List<LunarEventInstance> pastEvents, long lastCheckedGameTime) {
        public static final Codec<Data> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)LunarEventInstance.CODEC.listOf().fieldOf("forecast").forGetter(Data::forecast), (App)LunarEventInstance.CODEC.listOf().fieldOf("past_events").forGetter(Data::pastEvents), (App)Codec.LONG.fieldOf("last_checked_game_time").forGetter(Data::lastCheckedGameTime)).apply((Applicative)builder, Data::new));
    }
}

