/*
 * Decompiled with CFR 0.152.
 */
package net.fabric_extras.ranged_weapon.mixin.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.fabric_extras.ranged_weapon.api.CustomRangedWeapon;
import net.fabric_extras.ranged_weapon.api.EntityAttributes_RangedWeapon;
import net.fabric_extras.ranged_weapon.api.RangedConfig;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ProjectileWeaponItem;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={ProjectileWeaponItem.class})
abstract class RangedWeaponItemMixin
extends Item
implements CustomRangedWeapon {
    private Multimap<Attribute, AttributeModifier> attributeModifiers = null;
    private List<EquipmentSlot> allowedSlots = List.of(EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND);
    private RangedConfig rangedWeaponConfig = RangedConfig.EMPTY;
    private static final UUID RANGED_DAMAGE_MODIFIER_UUID = UUID.fromString("e5d0a858-012b-11ed-b939-0242ac120002");

    RangedWeaponItemMixin(Item.Properties settings) {
        super(settings);
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        return this.allowedSlots.contains(slot) && this.attributeModifiers != null ? this.attributeModifiers : super.m_7167_(slot);
    }

    @Override
    public RangedConfig getRangedWeaponConfig() {
        return this.rangedWeaponConfig;
    }

    @Override
    public void setRangedWeaponConfig(RangedConfig config) {
        this.rangedWeaponConfig = config;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        float damage = config.damage();
        if (damage > 0.0f) {
            builder.put((Object)EntityAttributes_RangedWeapon.DAMAGE.attribute, (Object)new AttributeModifier(RANGED_DAMAGE_MODIFIER_UUID, "Ranged Weapon Damage", (double)damage, AttributeModifier.Operation.ADDITION));
        }
        this.attributeModifiers = builder.build();
    }
}

