/*
 * Decompiled with CFR 0.152.
 */
package net.fabric_extras.ranged_weapon.client;

import com.ibm.icu.text.DecimalFormat;
import java.util.List;
import net.fabric_extras.ranged_weapon.api.CustomRangedWeapon;
import net.fabric_extras.ranged_weapon.api.EntityAttributes_RangedWeapon;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class TooltipUtil {
    public static void addPullTime(ItemStack itemStack, List<Component> lines) {
        int lastAttributeLine;
        int pullTime = TooltipUtil.readablePullTime(itemStack);
        if (pullTime > 0 && (lastAttributeLine = TooltipUtil.getLastAttributeLine(lines)) > 0) {
            lines.add(lastAttributeLine + 1, (Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237110_((String)"item.ranged_weapon.pull_time", (Object[])new Object[]{TooltipUtil.formattedNumber((float)pullTime / 20.0f)}).m_130940_(ChatFormatting.DARK_GREEN)));
        }
    }

    private static int getLastAttributeLine(List<Component> lines) {
        int lastAttributeLine = -1;
        String attributePrefix = "attribute.modifier";
        String handPrefix = "item.modifiers";
        for (int i = 0; i < lines.size(); ++i) {
            TranslatableContents translatableText;
            String key;
            Component line = lines.get(i);
            ComponentContents content = line.m_214077_();
            if (!(content instanceof TranslatableContents) || !(key = (translatableText = (TranslatableContents)content).m_237508_()).startsWith(attributePrefix) && !key.startsWith(handPrefix)) continue;
            lastAttributeLine = i;
        }
        return lastAttributeLine;
    }

    private static int readablePullTime(ItemStack itemStack) {
        LocalPlayer player;
        Item item = itemStack.m_41720_();
        double pullTime = 0.0;
        if (item instanceof CustomRangedWeapon) {
            CustomRangedWeapon customBow = (CustomRangedWeapon)item;
            pullTime = customBow.getRangedWeaponConfig().pull_time();
        }
        if ((player = Minecraft.m_91087_().f_91074_) != null && pullTime > 0.0) {
            double haste = player.m_21133_(EntityAttributes_RangedWeapon.HASTE.attribute);
            pullTime /= EntityAttributes_RangedWeapon.HASTE.asMultiplier(haste);
        }
        return (int)pullTime;
    }

    private static String formattedNumber(float number) {
        DecimalFormat formatter = new DecimalFormat();
        formatter.setMaximumFractionDigits(1);
        return formatter.format((double)number);
    }
}

